/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import org.apache.activemq.transport.TransportSupport;
import org.apache.activemq.transport.amqp.AmqpFrameParser;
import org.apache.activemq.transport.amqp.AmqpWireFormat;
import org.apache.activemq.transport.ws.WSTransport;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.wireformat.WireFormat;

public class AmqpWSTransport
extends TransportSupport
implements WSTransport,
AmqpFrameParser.AMQPFrameSink {
    private final AmqpFrameParser frameReader = new AmqpFrameParser(this);
    private final URI remoteLocation;
    private WSTransport.WSTransportSink outputSink;
    private int receiveCounter;
    private X509Certificate[] certificates;

    public AmqpWSTransport(URI location, WireFormat wireFormat) {
        this.remoteLocation = location;
        this.frameReader.setWireFormat((AmqpWireFormat)wireFormat);
    }

    @Override
    public void setTransportSink(WSTransport.WSTransportSink outputSink) {
        this.outputSink = outputSink;
    }

    @Override
    public void oneway(Object command) throws IOException {
        if (!(command instanceof ByteBuffer)) {
            throw new IOException("Unexpected output command.");
        }
        this.outputSink.onSocketOutboundBinary((ByteBuffer)command);
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteLocation.toASCIIString();
    }

    @Override
    public int getReceiveCounter() {
        return this.receiveCounter;
    }

    @Override
    public X509Certificate[] getPeerCertificates() {
        return this.certificates;
    }

    @Override
    public void setPeerCertificates(X509Certificate[] certificates) {
        this.certificates = certificates;
    }

    @Override
    public String getSubProtocol() {
        return "amqp";
    }

    @Override
    public WireFormat getWireFormat() {
        return this.frameReader.getWireFormat();
    }

    @Override
    public int getMaxFrameSize() {
        return (int)Math.min(((AmqpWireFormat)this.getWireFormat()).getMaxFrameSize(), Integer.MAX_VALUE);
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
    }

    @Override
    protected void doStart() throws Exception {
        if (this.outputSink == null) {
            throw new IllegalStateException("Transport started before output sink assigned.");
        }
    }

    @Override
    public void onWebSocketText(String data) throws IOException {
        this.onException(new IOException("Illegal text content receive on AMQP WebSocket channel."));
    }

    @Override
    public void onWebSocketBinary(ByteBuffer data) throws IOException {
        try {
            this.frameReader.parse(data);
        }
        catch (Exception e) {
            throw IOExceptionSupport.create(e);
        }
    }

    @Override
    public void onWebSocketClosed() throws IOException {
        this.onException(new IOException("Unexpected close of AMQP WebSocket channel."));
    }

    @Override
    public void onFrame(Object frame) {
        this.doConsume(frame);
    }
}

