/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.message.LargeBodyReader;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.MessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.util.NettyReadable;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPTunneledCoreLargeMessageWriter
implements MessageWriter {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final byte DATA_DESCRIPTOR = 117;
    private static final int DATA_SECTION_ENCODING_BYTES = 8;
    private final ProtonServerSenderContext serverSender;
    private final AMQPConnectionContext connection;
    private final Sender protonSender;
    private DeliveryAnnotations annotations;
    private MessageReference reference;
    private LargeServerMessageImpl message;
    private Delivery delivery;
    private int frameSize;
    private ByteBuf encodingBuffer;
    private long position;
    private int dataSectionRemaining;
    private volatile State state = State.CLOSED;

    public AMQPTunneledCoreLargeMessageWriter(ProtonServerSenderContext serverSender) {
        this.serverSender = serverSender;
        this.connection = serverSender.getSessionContext().getAMQPConnectionContext();
        this.protonSender = serverSender.getSender();
    }

    @Override
    public boolean isWriting() {
        return this.state != State.CLOSED;
    }

    @Override
    public void close() {
        if (this.state != State.CLOSED) {
            try {
                if (this.message != null) {
                    this.message.usageDown();
                }
            }
            finally {
                this.reset(State.CLOSED);
            }
        }
    }

    @Override
    public AMQPTunneledCoreLargeMessageWriter open(MessageReference reference) {
        if (this.state != State.CLOSED) {
            throw new IllegalStateException("Trying to open an AMQP Large Message writer that was not closed");
        }
        this.reset(State.STREAMING_DELIVERY_ANNOTATIONS);
        return this;
    }

    private void reset(State newState) {
        this.message = null;
        this.reference = null;
        this.delivery = null;
        this.position = 0L;
        this.dataSectionRemaining = 0;
        this.state = newState;
        this.encodingBuffer = null;
    }

    @Override
    public void writeBytes(MessageReference messageReference) {
        if (this.protonSender.getLocalState() == EndpointState.CLOSED) {
            logger.debug("Not delivering message {} as the sender is closed and credits were available, if you see too many of these it means clients are issuing credits and closing the connection with pending credits a lot of times", (Object)messageReference);
            return;
        }
        if (this.state == State.CLOSED) {
            throw new IllegalStateException("Cannot write to an AMQP Large Message Writer that has been closed");
        }
        if (this.state == State.DONE) {
            throw new IllegalStateException("Cannot write to an AMQP Large Message Writer that was already used to write a message and was not reset");
        }
        this.reference = messageReference;
        this.message = (LargeServerMessageImpl)messageReference.getMessage();
        this.annotations = (DeliveryAnnotations)this.reference.getProtocolData(DeliveryAnnotations.class);
        this.delivery = this.serverSender.createDelivery(messageReference, 1183580672);
        this.frameSize = this.protonSender.getSession().getConnection().getTransport().getOutboundFrameSizeLimit() - 50 - (this.delivery.getTag() != null ? this.delivery.getTag().length : 0);
        this.message.usageUp();
        this.tryDelivering();
    }

    private void resume() {
        this.connection.runNow(this::tryDelivering);
    }

    private ByteBuf getOrCreateDeliveryAnnotationsBuffer() {
        if (this.encodingBuffer == null) {
            this.encodingBuffer = Unpooled.buffer();
            EncoderImpl encoder = TLSEncode.getEncoder();
            try {
                encoder.setByteBuffer((WritableBuffer)new NettyWritable(this.encodingBuffer));
                encoder.writeObject((Object)this.annotations);
            }
            finally {
                encoder.setByteBuffer((WritableBuffer)null);
            }
        }
        return this.encodingBuffer;
    }

    private ByteBuf getOrCreateMessageHeaderBuffer() {
        if (this.encodingBuffer == null) {
            int headersSize = this.message.getHeadersAndPropertiesEncodeSize();
            int bufferSize = headersSize + 8;
            this.encodingBuffer = Unpooled.buffer((int)bufferSize, (int)bufferSize);
            this.writeDataSectionTypeInfo(this.encodingBuffer, headersSize);
            this.message.encodeHeadersAndProperties(this.encodingBuffer);
        }
        return this.encodingBuffer;
    }

    private boolean trySendDeliveryAnnotations(ByteBuf frameBuffer, NettyReadable frameView) {
        while (this.protonSender.getLocalState() != EndpointState.CLOSED && this.state == State.STREAMING_DELIVERY_ANNOTATIONS) {
            if (this.annotations != null && this.annotations.getValue() != null && !this.annotations.getValue().isEmpty()) {
                if (!this.connection.flowControl(this::resume)) break;
                ByteBuf annotationsBuffer = this.getOrCreateDeliveryAnnotationsBuffer();
                int readSize = (int)Math.min((long)frameBuffer.writableBytes(), (long)annotationsBuffer.readableBytes() - this.position);
                this.position += (long)readSize;
                annotationsBuffer.readBytes(frameBuffer, readSize);
                if (!frameBuffer.isWritable()) {
                    this.protonSender.send((ReadableBuffer)frameView);
                    frameBuffer.clear();
                    this.connection.instantFlush();
                }
                if (annotationsBuffer.isReadable()) continue;
                this.encodingBuffer = null;
                this.position = 0L;
                this.state = State.STREAMING_CORE_HEADERS;
                continue;
            }
            this.state = State.STREAMING_CORE_HEADERS;
        }
        return this.state == State.STREAMING_CORE_HEADERS;
    }

    private boolean trySendHeadersAndProperties(ByteBuf frameBuffer, NettyReadable frameView) {
        while (this.protonSender.getLocalState() != EndpointState.CLOSED && this.state == State.STREAMING_CORE_HEADERS && this.connection.flowControl(this::resume)) {
            ByteBuf headerBuffer = this.getOrCreateMessageHeaderBuffer();
            int readSize = (int)Math.min((long)frameBuffer.writableBytes(), (long)headerBuffer.readableBytes() - this.position);
            this.position += (long)readSize;
            headerBuffer.readBytes(frameBuffer, readSize);
            if (!frameBuffer.isWritable()) {
                this.protonSender.send((ReadableBuffer)frameView);
                frameBuffer.clear();
                this.connection.instantFlush();
            }
            if (headerBuffer.isReadable()) continue;
            this.encodingBuffer = null;
            this.position = 0L;
            this.state = State.STREAMING_BODY;
        }
        return this.state == State.STREAMING_BODY;
    }

    private boolean tryDeliveryMessageBody(ByteBuf frameBuffer, NettyReadable frameView) throws ActiveMQException {
        try (LargeBodyReader context = this.message.getLargeBodyReader();){
            context.open();
            context.position(this.position);
            long bodySize = context.getSize();
            while (this.protonSender.getLocalState() != EndpointState.CLOSED && this.state == State.STREAMING_BODY && this.connection.flowControl(this::resume)) {
                if (this.dataSectionRemaining == 0) {
                    this.dataSectionRemaining = (int)Math.min(Integer.MAX_VALUE, bodySize - this.position);
                    if (frameBuffer.writableBytes() < 8) {
                        this.protonSender.send((ReadableBuffer)frameView);
                        frameBuffer.clear();
                    }
                    this.writeDataSectionTypeInfo(frameBuffer, this.dataSectionRemaining);
                }
                int readSize = context.readInto(frameBuffer.internalNioBuffer(frameBuffer.writerIndex(), frameBuffer.writableBytes()));
                frameBuffer.writerIndex(frameBuffer.writerIndex() + readSize);
                this.position += (long)readSize;
                this.dataSectionRemaining -= readSize;
                if (frameBuffer.isWritable() && this.position != bodySize) continue;
                this.protonSender.send((ReadableBuffer)frameView);
                frameBuffer.clear();
                if (this.position < bodySize) {
                    this.connection.instantFlush();
                    continue;
                }
                this.state = State.DONE;
            }
            boolean bl = this.state == State.DONE;
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tryDelivering() {
        ByteBuf frameBuffer = PooledByteBufAllocator.DEFAULT.directBuffer(this.frameSize, this.frameSize);
        try {
            NettyReadable frameView = new NettyReadable(frameBuffer);
            frameBuffer.ensureWritable(this.frameSize);
            switch (this.state) {
                case STREAMING_DELIVERY_ANNOTATIONS: {
                    if (!this.trySendDeliveryAnnotations(frameBuffer, frameView)) {
                        return;
                    }
                }
                case STREAMING_CORE_HEADERS: {
                    if (!this.trySendHeadersAndProperties(frameBuffer, frameView)) {
                        return;
                    }
                }
                case STREAMING_BODY: {
                    if (!this.tryDeliveryMessageBody(frameBuffer, frameView)) {
                        return;
                    }
                    this.serverSender.reportDeliveryComplete(this, this.reference, this.delivery, true);
                    return;
                }
                default: {
                    throw new IllegalStateException("The writer already wrote a message and was not reset");
                }
            }
        }
        catch (Exception deliveryError) {
            this.serverSender.reportDeliveryError(this, this.reference, deliveryError);
            return;
        }
        finally {
            frameBuffer.release();
        }
    }

    private void writeDataSectionTypeInfo(ByteBuf buffer, int encodedSize) {
        buffer.writeByte(0);
        buffer.writeByte(83);
        buffer.writeByte(117);
        buffer.writeByte(-80);
        buffer.writeInt(encodedSize);
    }

    private static enum State {
        STREAMING_DELIVERY_ANNOTATIONS,
        STREAMING_CORE_HEADERS,
        STREAMING_BODY,
        DONE,
        CLOSED;

    }
}

