/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsProducerId;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.meta.JmsTransactionId;
import org.apache.qpid.jms.meta.JmsTransactionInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.AmqpProducer;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpResource;
import org.apache.qpid.jms.provider.amqp.AmqpResourceParent;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.AmqpTransactionCoordinator;
import org.apache.qpid.jms.provider.amqp.builders.AmqpTransactionCoordinatorBuilder;
import org.apache.qpid.jms.provider.exceptions.ProviderIllegalStateException;
import org.apache.qpid.jms.provider.exceptions.ProviderTransactionRolledBackException;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpTransactionContext
implements AmqpResourceParent {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpTransactionContext.class);
    private final AmqpSession session;
    private final Map<JmsConsumerId, AmqpConsumer> txConsumers = new HashMap<JmsConsumerId, AmqpConsumer>();
    private final Map<JmsProducerId, AmqpProducer> txProducers = new HashMap<JmsProducerId, AmqpProducer>();
    private JmsTransactionId current;
    private TransactionalState cachedAcceptedState;
    private TransactionalState cachedTransactedState;
    private AmqpTransactionCoordinator coordinator;

    public AmqpTransactionContext(AmqpSession session, JmsSessionInfo resourceInfo) {
        this.session = session;
    }

    public void begin(final JmsTransactionId txId, final AsyncResult request) throws ProviderException {
        if (this.current != null) {
            throw new ProviderIllegalStateException("Begin called while a TX is still Active.");
        }
        final AsyncResult declareCompletion = new AsyncResult(){

            @Override
            public void onSuccess() {
                AmqpTransactionContext.this.current = txId;
                AmqpTransactionContext.this.cachedAcceptedState = new TransactionalState();
                AmqpTransactionContext.this.cachedAcceptedState.setOutcome((Outcome)Accepted.getInstance());
                AmqpTransactionContext.this.cachedAcceptedState.setTxnId(AmqpTransactionContext.this.getAmqpTransactionId());
                AmqpTransactionContext.this.cachedTransactedState = new TransactionalState();
                AmqpTransactionContext.this.cachedTransactedState.setTxnId(AmqpTransactionContext.this.getAmqpTransactionId());
                request.onSuccess();
            }

            @Override
            public void onFailure(ProviderException result) {
                AmqpTransactionContext.this.current = null;
                AmqpTransactionContext.this.cachedAcceptedState = null;
                AmqpTransactionContext.this.cachedTransactedState = null;
                request.onFailure(result);
            }

            @Override
            public boolean isComplete() {
                return AmqpTransactionContext.this.current != null;
            }
        };
        if (this.coordinator == null || this.coordinator.isClosed()) {
            AmqpTransactionCoordinatorBuilder builder = new AmqpTransactionCoordinatorBuilder(this, (JmsSessionInfo)this.session.getResourceInfo());
            builder.buildResource(new AsyncResult(){

                @Override
                public void onSuccess() {
                    try {
                        AmqpTransactionContext.this.coordinator.declare(txId, declareCompletion);
                    }
                    catch (ProviderException e) {
                        request.onFailure(e);
                    }
                }

                @Override
                public void onFailure(ProviderException result) {
                    request.onFailure(result);
                }

                @Override
                public boolean isComplete() {
                    return request.isComplete();
                }
            });
        } else {
            this.coordinator.declare(txId, declareCompletion);
        }
    }

    public void commit(JmsTransactionInfo transactionInfo, JmsTransactionInfo nextTransactionInfo, AsyncResult request) throws ProviderException {
        if (!transactionInfo.getId().equals(this.current)) {
            if (!transactionInfo.isInDoubt() && this.current == null) {
                throw new ProviderIllegalStateException("Commit called with no active Transaction.");
            }
            if (!transactionInfo.isInDoubt() && this.current != null) {
                throw new ProviderIllegalStateException("Attempt to Commit a transaction other than the current one");
            }
            throw new ProviderTransactionRolledBackException("Transaction in doubt and cannot be committed.");
        }
        this.preCommit();
        LOG.trace("TX Context[{}] committing current TX[[]]", (Object)this, (Object)this.current);
        DischargeCompletion completion = new DischargeCompletion(request, nextTransactionInfo, true);
        this.coordinator.discharge(this.current, completion);
        this.current = null;
        if (completion.isPipelined()) {
            if (!completion.isComplete()) {
                this.begin(nextTransactionInfo.getId(), completion.getDeclareCompletion());
            } else {
                completion.getDeclareCompletion().onFailure(completion.getFailureCause());
            }
        }
    }

    public void rollback(JmsTransactionInfo transactionInfo, JmsTransactionInfo nextTransactionInfo, AsyncResult request) throws ProviderException {
        if (!transactionInfo.getId().equals(this.current)) {
            if (!transactionInfo.isInDoubt() && this.current == null) {
                throw new ProviderIllegalStateException("Rollback called with no active Transaction.");
            }
            if (!transactionInfo.isInDoubt() && this.current != null) {
                throw new ProviderIllegalStateException("Attempt to rollback a transaction other than the current one");
            }
            request.onSuccess();
            return;
        }
        this.preRollback();
        LOG.trace("TX Context[{}] rolling back current TX[[]]", (Object)this, (Object)this.current);
        DischargeCompletion completion = new DischargeCompletion(request, nextTransactionInfo, false);
        this.coordinator.discharge(this.current, completion);
        this.current = null;
        if (completion.isPipelined()) {
            if (!completion.isComplete()) {
                this.begin(nextTransactionInfo.getId(), completion.getDeclareCompletion());
            } else {
                completion.getDeclareCompletion().onFailure(completion.getFailureCause());
            }
        }
    }

    public void registerTxConsumer(AmqpConsumer consumer) {
        this.txConsumers.put(consumer.getConsumerId(), consumer);
    }

    public boolean isInTransaction(JmsConsumerId consumerId) {
        return this.txConsumers.containsKey(consumerId);
    }

    public void registerTxProducer(AmqpProducer producer) {
        this.txProducers.put(producer.getProducerId(), producer);
    }

    public boolean isInTransaction(JmsProducerId producerId) {
        return this.txProducers.containsKey(producerId);
    }

    public AmqpSession getSession() {
        return this.session;
    }

    public TransactionalState getTxnAcceptState() {
        return this.cachedAcceptedState;
    }

    public TransactionalState getTxnEnrolledState() {
        return this.cachedTransactedState;
    }

    public JmsTransactionId getTransactionId() {
        return this.current;
    }

    public boolean isTransactionInDoubt() {
        return this.coordinator == null ? true : this.coordinator.isClosed();
    }

    public Binary getAmqpTransactionId() {
        Binary result = null;
        if (this.current != null) {
            result = (Binary)this.current.getProviderHint();
        }
        return result;
    }

    public String toString() {
        return this.session.getSessionId() + ": txContext";
    }

    private void preCommit() {
        for (AmqpConsumer consumer : this.txConsumers.values()) {
            consumer.preCommit();
        }
    }

    private void preRollback() {
        for (AmqpConsumer consumer : this.txConsumers.values()) {
            consumer.preRollback();
        }
    }

    private void postCommit() {
        for (AmqpConsumer consumer : this.txConsumers.values()) {
            consumer.postCommit();
        }
        this.txConsumers.clear();
        this.txProducers.clear();
    }

    private void postRollback() {
        for (AmqpConsumer consumer : this.txConsumers.values()) {
            consumer.postRollback();
        }
        this.txConsumers.clear();
        this.txProducers.clear();
    }

    @Override
    public void addChildResource(AmqpResource resource) {
        if (resource instanceof AmqpTransactionCoordinator) {
            this.coordinator = (AmqpTransactionCoordinator)resource;
        }
    }

    @Override
    public void removeChildResource(AmqpResource resource) {
    }

    @Override
    public AmqpProvider getProvider() {
        return this.session.getProvider();
    }

    public class DischargeCompletion
    extends Completion {
        private final DeclareCompletion declare;
        private final AsyncResult request;
        private final boolean commit;

        public DischargeCompletion(AsyncResult request, JmsTransactionInfo nextTx, boolean commit) {
            this.request = request;
            this.commit = commit;
            this.declare = nextTx != null ? new DeclareCompletion(this) : null;
        }

        public DeclareCompletion getDeclareCompletion() {
            return this.declare;
        }

        public boolean isCommit() {
            return this.commit;
        }

        public boolean isPipelined() {
            return this.declare != null;
        }

        @Override
        public void onFailure(ProviderException result) {
            this.complete = true;
            this.failure = result;
            this.onDischargeFailure(result);
        }

        @Override
        public void onSuccess() {
            this.complete = true;
            this.onDischargeSuccess();
        }

        public void onDeclareSuccess() {
            if (this.isComplete()) {
                if (this.getFailureCause() == null) {
                    this.request.onSuccess();
                } else {
                    this.request.onFailure(this.getFailureCause());
                }
            }
        }

        public void onDischargeSuccess() {
            this.cleanup();
            if (this.declare == null) {
                this.request.onSuccess();
            } else if (this.declare.isComplete()) {
                if (this.declare.getFailureCause() == null) {
                    this.request.onSuccess();
                } else {
                    this.request.onFailure(this.declare.getFailureCause());
                }
            }
        }

        public void onDeclareFailure(ProviderException failure) {
            if (this.isComplete()) {
                if (this.getFailureCause() == null) {
                    this.request.onFailure(failure);
                } else {
                    this.request.onFailure(this.getFailureCause());
                }
            }
        }

        public void onDischargeFailure(ProviderException failure) {
            this.cleanup();
            if (this.declare == null) {
                this.request.onFailure(failure);
            } else if (this.declare.isComplete()) {
                this.request.onFailure(failure);
            }
        }

        private void cleanup() {
            if (this.commit) {
                AmqpTransactionContext.this.postCommit();
            } else {
                AmqpTransactionContext.this.postRollback();
            }
        }
    }

    private class DeclareCompletion
    extends Completion {
        protected final DischargeCompletion parent;

        public DeclareCompletion(DischargeCompletion parent) {
            this.parent = parent;
        }

        @Override
        public void onFailure(ProviderException result) {
            this.complete = true;
            this.failure = result;
            this.parent.onDeclareFailure(result);
        }

        @Override
        public void onSuccess() {
            this.complete = true;
            this.parent.onDeclareSuccess();
        }
    }

    private abstract class Completion
    implements AsyncResult {
        protected boolean complete;
        protected ProviderException failure;

        private Completion() {
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }

        public ProviderException getFailureCause() {
            return this.failure;
        }
    }
}

