/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.transports.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import org.apache.qpid.jms.transports.TransportOptions;
import org.apache.qpid.jms.transports.netty.EpollSupport;
import org.apache.qpid.jms.transports.netty.KQueueSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EventLoopType {
    EPOLL,
    KQUEUE,
    NIO;

    private static final Logger LOG;

    public void createChannel(Bootstrap bootstrap) {
        EventLoopType.createChannel(this, Objects.requireNonNull(bootstrap));
    }

    public EventLoopGroup createEventLoopGroup(int threads, ThreadFactory ioThreadFactory) {
        return EventLoopType.createEventLoopGroup(this, threads, ioThreadFactory);
    }

    private static EventLoopGroup createEventLoopGroup(EventLoopType type, int threads, ThreadFactory ioThreadFactory) {
        switch (type) {
            case EPOLL: {
                LOG.trace("Netty Transport using Epoll mode");
                return EpollSupport.createGroup(threads, ioThreadFactory);
            }
            case KQUEUE: {
                LOG.trace("Netty Transport using KQueue mode");
                return KQueueSupport.createGroup(threads, ioThreadFactory);
            }
            case NIO: {
                LOG.trace("Netty Transport using Nio mode");
                return new NioEventLoopGroup(threads, ioThreadFactory);
            }
        }
        throw new IllegalArgumentException("Unknown event loop type:" + type);
    }

    private static void createChannel(EventLoopType type, Bootstrap bootstrap) {
        switch (type) {
            case EPOLL: {
                EpollSupport.createChannel(bootstrap);
                break;
            }
            case KQUEUE: {
                KQueueSupport.createChannel(bootstrap);
                break;
            }
            case NIO: {
                bootstrap.channel(NioSocketChannel.class);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown event loop type:" + type);
            }
        }
    }

    public static EventLoopType valueOf(TransportOptions transportOptions) {
        boolean useKQueue = KQueueSupport.isAvailable(transportOptions);
        boolean useEpoll = EpollSupport.isAvailable(transportOptions);
        if (useKQueue) {
            return KQUEUE;
        }
        if (useEpoll) {
            return EPOLL;
        }
        return NIO;
    }

    static {
        LOG = LoggerFactory.getLogger(EventLoopType.class);
    }
}

