/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client.authn;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.samly2.assertion.AssertionParser;
import eu.unicore.samly2.assertion.AttributeAssertionParser;
import eu.unicore.samly2.elements.NameID;
import eu.unicore.samly2.exceptions.SAMLValidationException;
import eu.unicore.security.canl.PasswordCallback;
import eu.unicore.security.canl.TruststoreProperties;
import eu.unicore.security.etd.TrustDelegation;
import eu.unicore.security.wsutil.client.authn.AssertionsCache;
import eu.unicore.security.wsutil.client.authn.DelegationSpecification;
import eu.unicore.security.wsutil.client.authn.InMemoryAssertionCache;
import eu.unicore.security.wsutil.client.authn.PropertiesBasedAuthenticationProvider;
import eu.unicore.security.wsutil.client.authn.SAMLAuthNProperties;
import eu.unicore.security.wsutil.client.authn.UsernameCallback;
import eu.unicore.security.wsutil.samlclient.AuthnResponseAssertions;
import eu.unicore.security.wsutil.samlclient.SAMLAuthnClient;
import eu.unicore.util.httpclient.DefaultClientConfiguration;
import eu.unicore.util.httpclient.ETDClientSettings;
import eu.unicore.util.httpclient.SessionIDProviderImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;

public class SAMLAuthN
extends PropertiesBasedAuthenticationProvider {
    public static final String NAME = "unity";
    protected UsernameCallback usernameCallback;
    protected AssertionsCache assertionsCache = new InMemoryAssertionCache();

    public SAMLAuthN(Properties properties, PasswordCallback passwordCallback, UsernameCallback usernameCallback, AssertionsCache assertionsCache) {
        super(properties, passwordCallback);
        this.usernameCallback = usernameCallback;
        this.assertionsCache = assertionsCache;
    }

    protected SAMLAuthN() {
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return "Authenticate with login and password to a Unity service. The obtained SAML credentials are locally stored and used until they expire. For this method, a truststore must be properly configured, but no keystore/certificate credential is required.";
    }

    @Override
    public DefaultClientConfiguration getClientConfiguration(String targetAddress, String targetDn, DelegationSpecification delegate) throws Exception {
        SAMLAuthNProperties samlConfig = new SAMLAuthNProperties(this.properties);
        DefaultClientConfiguration baseClientConfiguration = this.getAnonymousClientConfiguration();
        if (targetAddress == null) {
            throw new IllegalArgumentException("SAMLAuthN always require target service address");
        }
        String idpAddress = samlConfig.getValue("address");
        AuthnResponseAssertions samlResponse = this.assertionsCache.get(this.getKey(targetAddress = SessionIDProviderImpl.extractServerID(targetAddress), targetDn));
        if (samlResponse == null) {
            samlResponse = this.doSAMLAuthn(this.getUsername(samlConfig), this.getPassword(samlConfig), idpAddress, targetDn, targetAddress, baseClientConfiguration);
            this.assertionsCache.store(this.getKey(targetAddress, targetDn), samlResponse);
        }
        return this.buildFinalSettings(samlResponse, baseClientConfiguration, delegate);
    }

    @Override
    public String getUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("The following properties can be used in the UCC preference file to configure the Unity/SAML authentication. Many of these are optional. Refer to the manual and/or the example files.\n");
        sb.append(this.getMeta(SAMLAuthNProperties.class, "unity."));
        sb.append("\nFor configuring your trusted CAs:\n");
        sb.append(this.getMeta(TruststoreProperties.class, "truststore."));
        return sb.toString();
    }

    private AuthnResponseAssertions doSAMLAuthn(String username, char[] password, String idpAddress, String targetIdentity, String targetUrl, DefaultClientConfiguration anonymousClientCfg) throws MalformedURLException, SAMLValidationException {
        anonymousClientCfg.setHttpAuthn(true);
        anonymousClientCfg.setHttpPassword(String.valueOf(password));
        anonymousClientCfg.setHttpUser(username);
        SAMLAuthnClient client = new SAMLAuthnClient(idpAddress, anonymousClientCfg);
        NameID requester = targetIdentity != null ? new NameID(targetIdentity, "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName") : new NameID(targetUrl, "urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        return client.authenticate("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName", requester, targetUrl);
    }

    private String getKey(String targetAddress, String targetDn) {
        return targetDn == null ? "" : X500NameUtils.getComparableForm((String)targetDn) + "|||||" + targetAddress;
    }

    private DefaultClientConfiguration buildFinalSettings(AuthnResponseAssertions response, DefaultClientConfiguration baseClientConfiguration, DelegationSpecification delegate) throws IOException {
        List<AssertionParser> authNAssertions = response.getAuthNAssertions();
        List<AssertionDocument> otherAssertions = response.getOtherAssertions();
        List<AttributeAssertionParser> attributeAssertions = response.getAttributeAssertions();
        DefaultClientConfiguration ret = baseClientConfiguration.clone();
        ArrayList<Assertion> assertionsToBePushed = new ArrayList<Assertion>();
        ArrayList<TrustDelegation> tds = new ArrayList<TrustDelegation>();
        if (authNAssertions.size() != 1) {
            throw new IOException("SAML service returned " + authNAssertions.size() + " authentication " + "assertions. We need exactly one - this service is unsupported.");
        }
        AssertionDocument authnAssertionXml = authNAssertions.get(0).getXMLBeanDoc();
        assertionsToBePushed.add(new Assertion(authnAssertionXml));
        for (AttributeAssertionParser attributeAssertion : attributeAssertions) {
            AssertionDocument attributeAssertionXml = attributeAssertion.getXMLBeanDoc();
            try {
                TrustDelegation td = new TrustDelegation(attributeAssertionXml);
                tds.add(td);
            }
            catch (Exception e) {
                assertionsToBePushed.add(new Assertion(attributeAssertionXml));
            }
        }
        if (otherAssertions.size() > 0) {
            System.out.println("SAML service returned some unknown assertions which are neither attribute nor authentication assertions. Those assertions will be ignored.");
        }
        ret.getExtraSecurityTokens().put("SAMLPushedassertions", assertionsToBePushed);
        if (delegate.isDelegate()) {
            if (tds.isEmpty()) {
                throw new IOException("Trust delegation was not found in the received assertions. Probably you are using a UNICORE unaware SAML service.");
            }
            if (tds.size() > 1) {
                throw new IOException("Multiple trust delegations were found in the received assertions. This is unsupported.");
            }
            ETDClientSettings etdSettings = ret.getETDSettings();
            etdSettings.setTrustDelegationTokens(Collections.singletonList(tds.get(0)));
            etdSettings.setRequestedUser(((TrustDelegation)tds.get(0)).getCustodianDN());
        }
        return ret;
    }

    private String getUsername(SAMLAuthNProperties stsConfig) throws IOException {
        String ret = stsConfig.getValue("username");
        if (ret == null) {
            return this.usernameCallback.getUsername();
        }
        return ret;
    }

    private char[] getPassword(SAMLAuthNProperties stsConfig) {
        String ret = stsConfig.getValue("password");
        if (ret == null) {
            return this.truststorePasswordCallback.getPassword("login", "Unity password");
        }
        return ret.toCharArray();
    }

    protected void setAssertionsCache(AssertionsCache cacheImpl) {
        this.assertionsCache = cacheImpl;
    }
}

