/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.jparss;

import eu.unicore.uftp.jparss.PConfig;
import eu.unicore.uftp.jparss.PInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class PReader
implements Runnable {
    private byte[] buffer_ = null;
    private int offset_ = 0;
    private int len_ = 0;
    public int num_ = 0;
    private InputStream input_ = null;
    private DataInputStream istream_ = null;
    private int pos_ = 0;
    private PInputStream parent_ = null;
    byte[] header_ = null;
    ByteArrayInputStream headerArrayStream_ = null;
    DataInputStream headerStream_ = null;
    private boolean eof = false;

    public PReader(PInputStream parent, InputStream stream, int pos, int numreadrs) {
        this.parent_ = parent;
        this.input_ = stream;
        this.pos_ = pos;
        this.num_ = numreadrs;
        this.istream_ = new DataInputStream(this.input_);
        this.header_ = new byte[16];
        this.headerArrayStream_ = new ByteArrayInputStream(this.header_);
        this.headerStream_ = new DataInputStream(this.headerArrayStream_);
    }

    public synchronized void set(byte[] buf, int off, int length) {
        this.buffer_ = buf;
        this.offset_ = off;
        this.len_ = length;
        if (this.buffer_ != null) {
            this.notify();
        }
    }

    private void reset() {
        this.buffer_ = null;
        this.offset_ = 0;
        this.len_ = 0;
    }

    public synchronized int readData() throws IOException {
        boolean doit = true;
        int bytes = 0;
        if (PConfig.debug) {
            System.out.println("Readr[" + String.valueOf(this.pos_) + "] is waiting");
        }
        while (this.buffer_ == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                doit = false;
            }
        }
        if (PConfig.debug) {
            System.out.println("Readr[" + String.valueOf(this.pos_) + "] is awaken");
        }
        if (!this.parent_.finished() && doit && this.len_ > 0) {
            try {
                bytes = this.doRead();
            }
            catch (EOFException ee) {
                this.eof = true;
                this.reset();
                return 0;
            }
            this.reset();
        }
        return bytes;
    }

    private int doRead() throws IOException, EOFException {
        short pos = 0;
        short magic = 0;
        int expseq = 0;
        int numtoread = 0;
        int seq = 0;
        int chunk = 0;
        this.headerArrayStream_.reset();
        try {
            this.istream_.readFully(this.header_);
        }
        catch (EOFException ee) {
            throw ee;
        }
        catch (IOException e) {
            System.err.println(e);
            throw e;
        }
        magic = this.headerStream_.readShort();
        pos = this.headerStream_.readShort();
        seq = this.headerStream_.readInt();
        int totalnum = this.headerStream_.readInt();
        numtoread = this.headerStream_.readInt();
        if (PConfig.debug) {
            System.out.println("Reader[" + String.valueOf(this.pos_) + "] Received header: magic: " + Integer.toHexString(magic) + " stream position: " + String.valueOf(pos) + " seq: " + String.valueOf(seq) + " number to read: " + String.valueOf(numtoread) + " with total number of bytes " + String.valueOf(totalnum));
        }
        if (magic != -12609) {
            throw new IOException("Bad magic number");
        }
        if (pos < 0 || pos >= this.num_) {
            throw new IOException("Parallel stream position error");
        }
        if (seq < 0) {
            throw new IOException("Negative sequence number");
        }
        if (totalnum < 0 || totalnum > this.len_) {
            throw new IOException("Total number of bytes error");
        }
        if (numtoread < 0) {
            throw new IOException("NUmber to read is negative");
        }
        expseq = this.parent_.getSeq();
        if (expseq == -1) {
            this.parent_.setSeq(seq);
        } else if (expseq != seq) {
            throw new IOException("Sequence number mismatch");
        }
        chunk = totalnum / this.num_;
        int toffset = this.offset_ + pos * chunk;
        int tlen = pos == this.num_ - 1 ? this.len_ - pos * chunk : chunk;
        if (PConfig.debug) {
            System.out.println("Reader[" + String.valueOf(this.pos_) + "] reads from " + String.valueOf(toffset) + " with buffer size " + String.valueOf(tlen));
        }
        if (numtoread > tlen) {
            throw new IOException("Read buffer overflow");
        }
        try {
            this.istream_.readFully(this.buffer_, toffset, numtoread);
        }
        catch (EOFException ee) {
            throw ee;
        }
        catch (IOException e) {
            System.err.println(e);
            throw e;
        }
        return numtoread;
    }

    @Override
    public void run() {
        boolean status = true;
        int bytes = 0;
        while (!this.parent_.finished()) {
            status = true;
            try {
                bytes = this.readData();
            }
            catch (IOException e) {
                e.printStackTrace();
                status = false;
                bytes = 0;
            }
            this.parent_.readerStatus(this.pos_, status, bytes);
        }
    }

    public boolean isEOF() {
        return this.eof;
    }
}

