/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.util;

import java.io.IOException;
import java.io.OutputStream;

public final class PEMUtil {
    public static final String LINE_SEP;
    static final byte[] LINE_SEP_BYTES;
    static final int LINE_LENGTH = 64;
    private static final char[] HEX;

    private PEMUtil() {
    }

    public static void writeBase64(OutputStream out, String header, byte[] base64Data, String footer) throws IOException {
        int length = 64;
        int offset = 0;
        if (header != null) {
            out.write(header.getBytes());
            out.write(LINE_SEP_BYTES);
        }
        int size = base64Data.length;
        while (offset < size) {
            if (64 > size - offset) {
                length = size - offset;
            }
            out.write(base64Data, offset, length);
            out.write(LINE_SEP_BYTES);
            offset += 64;
        }
        if (footer != null) {
            out.write(footer.getBytes());
            out.write(LINE_SEP_BYTES);
        }
    }

    public static String toHex(byte[] b) {
        char[] buf = new char[b.length * 2];
        int j = 0;
        byte[] arr$ = b;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte aB;
            byte k = aB = arr$[i$];
            buf[j++] = HEX[k >>> 4 & 0xF];
            buf[j++] = HEX[k & 0xF];
        }
        return new String(buf);
    }

    static {
        HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        LINE_SEP = System.getProperty("line.separator");
        LINE_SEP_BYTES = LINE_SEP.getBytes();
    }
}

