/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateOptionGroupRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String optionGroupName;
    private String engineName;
    private String majorEngineVersion;
    private String optionGroupDescription;
    private ListWithAutoConstructFlag<Tag> tags;

    public String getOptionGroupName() {
        return this.optionGroupName;
    }

    public void setOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
    }

    public CreateOptionGroupRequest withOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
        return this;
    }

    public String getEngineName() {
        return this.engineName;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public CreateOptionGroupRequest withEngineName(String engineName) {
        this.engineName = engineName;
        return this;
    }

    public String getMajorEngineVersion() {
        return this.majorEngineVersion;
    }

    public void setMajorEngineVersion(String majorEngineVersion) {
        this.majorEngineVersion = majorEngineVersion;
    }

    public CreateOptionGroupRequest withMajorEngineVersion(String majorEngineVersion) {
        this.majorEngineVersion = majorEngineVersion;
        return this;
    }

    public String getOptionGroupDescription() {
        return this.optionGroupDescription;
    }

    public void setOptionGroupDescription(String optionGroupDescription) {
        this.optionGroupDescription = optionGroupDescription;
    }

    public CreateOptionGroupRequest withOptionGroupDescription(String optionGroupDescription) {
        this.optionGroupDescription = optionGroupDescription;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public CreateOptionGroupRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public CreateOptionGroupRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOptionGroupName() != null) {
            sb.append("OptionGroupName: " + this.getOptionGroupName() + ",");
        }
        if (this.getEngineName() != null) {
            sb.append("EngineName: " + this.getEngineName() + ",");
        }
        if (this.getMajorEngineVersion() != null) {
            sb.append("MajorEngineVersion: " + this.getMajorEngineVersion() + ",");
        }
        if (this.getOptionGroupDescription() != null) {
            sb.append("OptionGroupDescription: " + this.getOptionGroupDescription() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOptionGroupName() == null ? 0 : this.getOptionGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getEngineName() == null ? 0 : this.getEngineName().hashCode());
        hashCode = 31 * hashCode + (this.getMajorEngineVersion() == null ? 0 : this.getMajorEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getOptionGroupDescription() == null ? 0 : this.getOptionGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOptionGroupRequest)) {
            return false;
        }
        CreateOptionGroupRequest other = (CreateOptionGroupRequest)obj;
        if (other.getOptionGroupName() == null ^ this.getOptionGroupName() == null) {
            return false;
        }
        if (other.getOptionGroupName() != null && !other.getOptionGroupName().equals(this.getOptionGroupName())) {
            return false;
        }
        if (other.getEngineName() == null ^ this.getEngineName() == null) {
            return false;
        }
        if (other.getEngineName() != null && !other.getEngineName().equals(this.getEngineName())) {
            return false;
        }
        if (other.getMajorEngineVersion() == null ^ this.getMajorEngineVersion() == null) {
            return false;
        }
        if (other.getMajorEngineVersion() != null && !other.getMajorEngineVersion().equals(this.getMajorEngineVersion())) {
            return false;
        }
        if (other.getOptionGroupDescription() == null ^ this.getOptionGroupDescription() == null) {
            return false;
        }
        if (other.getOptionGroupDescription() != null && !other.getOptionGroupDescription().equals(this.getOptionGroupDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }
}

