/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class VersionInputStream
extends InputStream {
    private int available = 0;
    private int read = 0;
    private List<Long> versionList;
    private static final int SIZE_OF_BYTE = 8;
    private static final int SIZE_OF_LONG = 64;
    private static final int SIZE_OF_MULTIPLIER = 8;

    public VersionInputStream(List<Long> versionList) {
        this.versionList = versionList;
        this.available = versionList.size() * 8;
        this.read = 0;
    }

    @Override
    public int read() throws IOException {
        int nextIndex = this.read / 8;
        int shiftOffset = 7 - this.read % 8;
        if (nextIndex >= this.versionList.size()) {
            return -1;
        }
        long nextVersion = this.versionList.get(nextIndex);
        int valueToRead = (int)(nextVersion >> shiftOffset * 8 & 0xFFL);
        ++this.read;
        --this.available;
        return valueToRead;
    }

    @Override
    public int available() throws IOException {
        return this.available;
    }
}

