/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.job;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.cluster.OutputParser;
import org.apache.airavata.gfac.impl.job.PBSOutputParser;
import org.apache.airavata.model.status.JobState;
import org.apache.airavata.model.status.JobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UGEOutputParser
implements OutputParser {
    private static final Logger log = LoggerFactory.getLogger(PBSOutputParser.class);
    public static final String JOB_ID = "jobId";

    public String parseJobSubmission(String rawOutput) {
        log.debug(rawOutput);
        if (rawOutput != null && !rawOutput.isEmpty() && !this.isJobSubmissionFailed(rawOutput)) {
            String[] info = rawOutput.split("\n");
            String lastLine = info[info.length - 1];
            return lastLine.split(" ")[2];
        }
        return "";
    }

    public boolean isJobSubmissionFailed(String rawOutput) {
        Pattern pattern = Pattern.compile("Rejecting");
        Matcher matcher = pattern.matcher(rawOutput);
        return matcher.find();
    }

    public JobStatus parseJobStatus(String jobID, String rawOutput) {
        Pattern pattern = Pattern.compile("job_number:[\\s]+" + jobID);
        Matcher matcher = pattern.matcher(rawOutput);
        if (matcher.find()) {
            return new JobStatus(JobState.QUEUED);
        }
        return new JobStatus(JobState.UNKNOWN);
    }

    public void parseJobStatuses(String userName, Map<String, JobStatus> statusMap, String rawOutput) {
        log.debug(rawOutput);
        String[] info = rawOutput.split("\n");
        int lastStop = 0;
        block0: for (String jobID : statusMap.keySet()) {
            for (int i = lastStop; i < info.length; ++i) {
                if (!jobID.split(",")[0].contains(info[i].split(" ")[0]) || "".equals(info[i].split(" ")[0])) continue;
                log.info(info[i]);
                String correctLine = info[i];
                String[] columns = correctLine.split(" ");
                ArrayList<String> columnList = new ArrayList<String>();
                for (String s : columns) {
                    if ("".equals(s)) continue;
                    columnList.add(s);
                }
                lastStop = i + 1;
                if ("E".equals(columnList.get(4))) {
                    columnList.set(4, "Er");
                }
                statusMap.put(jobID, new JobStatus(JobState.valueOf((String)((String)columnList.get(4)))));
                continue block0;
            }
        }
    }

    public String parseJobId(String jobName, String rawOutput) throws GFacException {
        Pattern pattern;
        Matcher matcher;
        if (jobName.length() > 10) {
            jobName = jobName.substring(0, 10);
        }
        if ((matcher = (pattern = Pattern.compile("(?<jobId>\\S+)\\s+\\S+\\s+(" + jobName + ")")).matcher(rawOutput)).find()) {
            return matcher.group(JOB_ID);
        }
        return null;
    }
}

