/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.query;

import java.util.ArrayList;
import org.apache.lucene.search.Filter;
import org.compass.core.engine.SearchEngineQueryFilter;
import org.compass.core.engine.SearchEngineQueryFilterBuilder;
import org.compass.core.lucene.engine.LuceneSearchEngineQueryFilter;
import org.compass.core.lucene.util.ChainedFilter;

public class LuceneSearchEngineBooleanQueryFilterBuilder
implements SearchEngineQueryFilterBuilder.SearchEngineBooleanQueryFilterBuilder {
    private ArrayList types = new ArrayList();
    private ArrayList filters = new ArrayList();

    public void and(SearchEngineQueryFilter filter) {
        this.types.add(ChainedFilter.ChainedFilterType.AND);
        this.filters.add(((LuceneSearchEngineQueryFilter)filter).getFilter());
    }

    public void or(SearchEngineQueryFilter filter) {
        this.types.add(ChainedFilter.ChainedFilterType.OR);
        this.filters.add(((LuceneSearchEngineQueryFilter)filter).getFilter());
    }

    public void andNot(SearchEngineQueryFilter filter) {
        this.types.add(ChainedFilter.ChainedFilterType.ANDNOT);
        this.filters.add(((LuceneSearchEngineQueryFilter)filter).getFilter());
    }

    public void xor(SearchEngineQueryFilter filter) {
        this.types.add(ChainedFilter.ChainedFilterType.XOR);
        this.filters.add(((LuceneSearchEngineQueryFilter)filter).getFilter());
    }

    public SearchEngineQueryFilter toFilter() {
        if (this.filters.size() == 0) {
            throw new IllegalArgumentException("Must add at least one filter");
        }
        Filter[] filtersArr = this.filters.toArray(new Filter[this.filters.size()]);
        ChainedFilter.ChainedFilterType[] typesArr = this.types.toArray(new ChainedFilter.ChainedFilterType[this.types.size()]);
        return new LuceneSearchEngineQueryFilter(new ChainedFilter(filtersArr, typesArr));
    }
}

