/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.LuceneResource;
import org.compass.core.lucene.engine.DefaultLuceneSearchEngineHits;
import org.compass.core.lucene.engine.EmptyLuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngineHits;
import org.compass.core.lucene.engine.LuceneSearchEngineInternalSearch;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.manager.LuceneIndexHolder;
import org.compass.core.lucene.engine.transaction.AbstractTransaction;
import org.compass.core.lucene.util.LuceneUtils;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.ResourceKey;
import org.compass.core.transaction.context.TransactionalCallable;
import org.compass.core.util.StringUtils;

public class LuceneTransaction
extends AbstractTransaction {
    private static final Log log = LogFactory.getLog(LuceneTransaction.class);
    private Map<String, IndexWriter> indexWriterBySubIndex = new HashMap<String, IndexWriter>();

    protected void doBegin() throws SearchEngineException {
    }

    protected void doRollback() throws SearchEngineException {
        SearchEngineException exception = null;
        for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
            try {
                entry.getValue().abort();
            }
            catch (AlreadyClosedException e) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Failed to abort transaction for sub index [" + entry.getKey() + "] since it is alreayd closed"));
            }
            catch (IOException e) {
                Directory dir = this.indexManager.getStore().openDirectory(entry.getKey());
                try {
                    if (IndexReader.isLocked(dir)) {
                        IndexReader.unlock(dir);
                    }
                }
                catch (Exception e1) {
                    log.warn((Object)("Failed to check for locks or unlock failed commit for sub index [" + entry.getKey() + "]"), (Throwable)e);
                }
                exception = new SearchEngineException("Failed to rollback transaction for sub index [" + entry.getKey() + "]", e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void doPrepare() throws SearchEngineException {
        this.flush();
    }

    protected void doCommit(boolean onePhase) throws SearchEngineException {
        if (this.indexWriterBySubIndex.isEmpty()) {
            return;
        }
        if (onePhase) {
            this.doPrepare();
        }
        if (this.indexManager.supportsConcurrentOperations()) {
            ArrayList prepareCallables = new ArrayList();
            for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
                prepareCallables.add(new TransactionalCallable(this.indexManager.getTransactionContext(), new CommitCallable(entry.getKey(), entry.getValue())));
            }
            this.indexManager.getExecutorManager().invokeAllWithLimitBailOnException(prepareCallables, 1);
        } else {
            for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
                try {
                    new CommitCallable(entry.getKey(), entry.getValue()).call();
                }
                catch (SearchEngineException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SearchEngineException("Failed to commit transaction for sub index [" + entry.getKey() + "]", e);
                }
            }
        }
    }

    public void flush() throws SearchEngineException {
        if (this.indexWriterBySubIndex.isEmpty()) {
            return;
        }
        ArrayList prepareCallables = new ArrayList();
        for (Map.Entry<String, IndexWriter> entry : this.indexWriterBySubIndex.entrySet()) {
            prepareCallables.add(new TransactionalCallable(this.indexManager.getTransactionContext(), new FlushCallable(entry.getKey(), entry.getValue())));
        }
        this.indexManager.getExecutorManager().invokeAllWithLimitBailOnException(prepareCallables, 1);
    }

    protected LuceneSearchEngineHits doFind(LuceneSearchEngineQuery query) throws SearchEngineException {
        LuceneSearchEngineInternalSearch internalSearch = (LuceneSearchEngineInternalSearch)this.internalSearch(query.getSubIndexes(), query.getAliases());
        if (internalSearch.isEmpty()) {
            return new EmptyLuceneSearchEngineHits();
        }
        Filter qFilter = null;
        if (query.getFilter() != null) {
            qFilter = query.getFilter().getFilter();
        }
        Hits hits = this.findByQuery(internalSearch, query, qFilter);
        return new DefaultLuceneSearchEngineHits(hits, this.searchEngine, query, internalSearch);
    }

    /*
     * Loose catch block
     */
    public Resource[] get(ResourceKey resourceKey) throws SearchEngineException {
        LuceneIndexHolder indexHolder = this.indexManager.openIndexHolderBySubIndex(resourceKey.getSubIndex());
        try {
            Resource[] resourceArray;
            Term t = new Term(resourceKey.getUIDPath(), resourceKey.buildUID());
            TermDocs termDocs = null;
            try {
                termDocs = indexHolder.getIndexReader().termDocs(t);
                if (termDocs != null) {
                    Resource[] resourceArray2 = LuceneUtils.hitsToResourceArray(termDocs, indexHolder.getIndexReader(), this.searchEngine);
                    return resourceArray2;
                }
                resourceArray = new Resource[]{};
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to search for property [" + resourceKey + "]", e);
            }
            finally {
                try {
                    if (termDocs != null) {
                        termDocs.close();
                    }
                }
                catch (IOException e) {}
            }
            return resourceArray;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            indexHolder.release();
        }
    }

    protected void doCreate(InternalResource resource, Analyzer analyzer) throws SearchEngineException {
        try {
            IndexWriter indexWriter = this.getOrCreateIndexWriter(resource.getSubIndex());
            indexWriter.addDocument(((LuceneResource)resource).getDocument(), analyzer);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to create resource for alias [" + resource.getAlias() + "] and resource " + resource, e);
        }
    }

    protected void doDelete(ResourceKey resourceKey) throws SearchEngineException {
        try {
            IndexWriter indexWriter = this.getOrCreateIndexWriter(resourceKey.getSubIndex());
            indexWriter.deleteDocuments(new Term(resourceKey.getUIDPath(), resourceKey.buildUID()));
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to delete alias [" + resourceKey.getAlias() + "] and ids [" + StringUtils.arrayToCommaDelimitedString(resourceKey.getIds()) + "]", e);
        }
    }

    protected void doUpdate(InternalResource resource, Analyzer analyzer) throws SearchEngineException {
        try {
            IndexWriter indexWriter = this.getOrCreateIndexWriter(resource.getSubIndex());
            indexWriter.updateDocument(new Term(resource.resourceKey().getUIDPath(), resource.resourceKey().buildUID()), ((LuceneResource)resource).getDocument(), analyzer);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to update resource for alias [" + resource.getAlias() + "] and resource " + resource, e);
        }
    }

    protected IndexWriter getOrCreateIndexWriter(String subIndex) throws IOException {
        IndexWriter indexWriter = this.indexWriterBySubIndex.get(subIndex);
        if (indexWriter != null) {
            return indexWriter;
        }
        indexWriter = this.indexManager.openIndexWriter(this.searchEngine.getSettings(), subIndex, false);
        this.indexWriterBySubIndex.put(subIndex, indexWriter);
        return indexWriter;
    }

    private class CommitCallable
    implements Callable {
        private String subIndex;
        private IndexWriter indexWriter;

        private CommitCallable(String subIndex, IndexWriter indexWriter) {
            this.subIndex = subIndex;
            this.indexWriter = indexWriter;
        }

        public Object call() throws Exception {
            try {
                this.indexWriter.close();
            }
            catch (IOException e) {
                Directory dir = LuceneTransaction.this.indexManager.getStore().openDirectory(this.subIndex);
                try {
                    if (IndexReader.isLocked(dir)) {
                        IndexReader.unlock(dir);
                    }
                }
                catch (Exception e1) {
                    log.warn((Object)("Failed to check for locks or unlock failed commit for sub index [" + this.subIndex + "]"), (Throwable)e);
                }
                throw new SearchEngineException("Failed commit transaction sub index [" + this.subIndex + "]", e);
            }
            if (LuceneTransaction.this.indexManager.getSettings().isClearCacheOnCommit()) {
                LuceneTransaction.this.indexManager.refreshCache(this.subIndex);
            }
            return null;
        }
    }

    private class FlushCallable
    implements Callable {
        private String subIndex;
        private IndexWriter indexWriter;

        private FlushCallable(String subIndex, IndexWriter indexWriter) {
            this.subIndex = subIndex;
            this.indexWriter = indexWriter;
        }

        public Object call() throws Exception {
            this.indexWriter.flush();
            return null;
        }
    }
}

