/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.DistributedObjectAccessor;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.InitializingObject;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PostJoinAwareService;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.spi.impl.DistributedObjectEventPacket;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.executor.StripedRunnable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ProxyServiceImpl
implements ProxyService,
PostJoinAwareService,
EventPublishingService<DistributedObjectEventPacket, Object> {
    static final String SERVICE_NAME = "hz:core:proxyService";
    private final NodeEngineImpl nodeEngine;
    private final ConcurrentMap<String, ProxyRegistry> registries = new ConcurrentHashMap<String, ProxyRegistry>();
    private final ConcurrentMap<String, DistributedObjectListener> listeners = new ConcurrentHashMap<String, DistributedObjectListener>();
    private final ILogger logger;
    private final ConstructorFunction<String, ProxyRegistry> registryConstructor = new ConstructorFunction<String, ProxyRegistry>(){

        @Override
        public ProxyRegistry createNew(String serviceName) {
            return new ProxyRegistry(serviceName);
        }
    };

    ProxyServiceImpl(NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(ProxyService.class.getName());
    }

    void init() {
        this.nodeEngine.getEventService().registerListener(SERVICE_NAME, SERVICE_NAME, new Object());
    }

    @Override
    public void initializeDistributedObject(String serviceName, Object objectId) {
        if (serviceName == null) {
            throw new NullPointerException("Service name is required!");
        }
        if (objectId == null) {
            throw new NullPointerException("Object id is required!");
        }
        this.getDistributedObject(serviceName, objectId);
    }

    @Override
    public DistributedObject getDistributedObject(String serviceName, Object objectId) {
        if (serviceName == null) {
            throw new NullPointerException("Service name is required!");
        }
        if (objectId == null) {
            throw new NullPointerException("Object id is required!");
        }
        ProxyRegistry registry = ConcurrencyUtil.getOrPutIfAbsent(this.registries, serviceName, this.registryConstructor);
        return registry.getProxy(objectId, true);
    }

    @Override
    public void destroyDistributedObject(String serviceName, Object objectId) {
        if (serviceName == null) {
            throw new NullPointerException("Service name is required!");
        }
        if (objectId == null) {
            throw new NullPointerException("Object id is required!");
        }
        Collection<MemberImpl> members = this.nodeEngine.getClusterService().getMemberList();
        ArrayList<Future> calls = new ArrayList<Future>(members.size());
        for (MemberImpl member : members) {
            if (member.localMember()) continue;
            Invocation inv = this.nodeEngine.getOperationService().createInvocationBuilder(SERVICE_NAME, (Operation)new DistributedObjectDestroyOperation(serviceName, objectId), member.getAddress()).setTryCount(10).build();
            calls.add(inv.invoke());
        }
        this.destroyLocalDistributedObject(serviceName, objectId);
        for (Future f : calls) {
            try {
                f.get(3L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                this.logger.finest(e);
            }
        }
        ProxyRegistry registry = (ProxyRegistry)this.registries.get(serviceName);
        if (registry != null) {
            registry.destroyProxy(objectId, true);
        }
    }

    private void destroyLocalDistributedObject(String serviceName, Object objectId) {
        RemoteService service = (RemoteService)this.nodeEngine.getService(serviceName);
        if (service != null) {
            service.destroyDistributedObject(objectId);
        }
        this.nodeEngine.waitNotifyService.cancelWaitingOps(serviceName, objectId, new DistributedObjectDestroyedException(serviceName, objectId));
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects(String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("Service name is required!");
        }
        LinkedList<DistributedObject> objects = new LinkedList<DistributedObject>();
        ProxyRegistry registry = (ProxyRegistry)this.registries.get(serviceName);
        if (registry != null) {
            objects.addAll(registry.proxies.values());
        }
        return objects;
    }

    @Override
    public Collection<DistributedObject> getAllDistributedObjects() {
        LinkedList<DistributedObject> objects = new LinkedList<DistributedObject>();
        for (ProxyRegistry registry : this.registries.values()) {
            objects.addAll(registry.proxies.values());
        }
        return objects;
    }

    @Override
    public String addProxyListener(DistributedObjectListener distributedObjectListener) {
        String id = UUID.randomUUID().toString();
        this.listeners.put(id, distributedObjectListener);
        return id;
    }

    @Override
    public boolean removeProxyListener(String registrationId) {
        return this.listeners.remove(registrationId) != null;
    }

    @Override
    public void dispatchEvent(DistributedObjectEventPacket eventPacket, Object ignore) {
        String serviceName = eventPacket.getServiceName();
        if (eventPacket.getEventType() == DistributedObjectEvent.EventType.CREATED) {
            try {
                ProxyRegistry registry = ConcurrencyUtil.getOrPutIfAbsent(this.registries, serviceName, this.registryConstructor);
                if (!registry.contains(eventPacket.getObjectId())) {
                    registry.getProxy(eventPacket.getObjectId(), false);
                }
            }
            catch (HazelcastInstanceNotActiveException ignored) {}
        } else {
            ProxyRegistry registry = (ProxyRegistry)this.registries.get(serviceName);
            if (registry != null) {
                registry.destroyProxy(eventPacket.getObjectId(), false);
            }
        }
    }

    @Override
    public Operation getPostJoinOperation() {
        LinkedList<ProxyInfo> proxies = new LinkedList<ProxyInfo>();
        for (ProxyRegistry registry : this.registries.values()) {
            for (DistributedObject distributedObject : registry.proxies.values()) {
                if (!(distributedObject instanceof InitializingObject)) continue;
                proxies.add(new ProxyInfo(registry.serviceName, distributedObject.getId()));
            }
        }
        return proxies.isEmpty() ? null : new PostJoinProxyOperation(proxies);
    }

    void shutdown() {
        for (ProxyRegistry registry : this.registries.values()) {
            registry.destroy();
        }
        this.registries.clear();
        this.listeners.clear();
    }

    private static class ProxyInfo {
        final String serviceName;
        final Object objectId;

        private ProxyInfo(String serviceName, Object objectId) {
            this.serviceName = serviceName;
            this.objectId = objectId;
        }
    }

    public static class PostJoinProxyOperation
    extends AbstractOperation {
        private Collection<ProxyInfo> proxies;

        public PostJoinProxyOperation() {
        }

        public PostJoinProxyOperation(Collection<ProxyInfo> proxies) {
            this.proxies = proxies;
        }

        @Override
        public void run() throws Exception {
            if (this.proxies != null && this.proxies.size() > 0) {
                NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
                ProxyService proxyService = nodeEngine.getProxyService();
                for (ProxyInfo proxy : this.proxies) {
                    proxyService.getDistributedObject(proxy.serviceName, proxy.objectId);
                }
            }
        }

        @Override
        public boolean returnsResponse() {
            return false;
        }

        @Override
        protected void writeInternal(ObjectDataOutput out) throws IOException {
            super.writeInternal(out);
            int len = this.proxies != null ? this.proxies.size() : 0;
            out.writeInt(len);
            if (len > 0) {
                for (ProxyInfo proxy : this.proxies) {
                    out.writeUTF(proxy.serviceName);
                    out.writeObject(proxy.objectId);
                }
            }
        }

        @Override
        protected void readInternal(ObjectDataInput in) throws IOException {
            super.readInternal(in);
            int len = in.readInt();
            if (len > 0) {
                this.proxies = new ArrayList<ProxyInfo>(len);
                for (int i = 0; i < len; ++i) {
                    ProxyInfo proxy = new ProxyInfo(in.readUTF(), in.readObject());
                    this.proxies.add(proxy);
                }
            }
        }
    }

    public static class DistributedObjectDestroyOperation
    extends AbstractOperation {
        private String serviceName;
        private Object objectId;

        public DistributedObjectDestroyOperation() {
        }

        public DistributedObjectDestroyOperation(String serviceName, Object objectId) {
            this.serviceName = serviceName;
            this.objectId = objectId;
        }

        @Override
        public void run() throws Exception {
            ProxyServiceImpl proxyService = (ProxyServiceImpl)this.getService();
            ProxyRegistry registry = (ProxyRegistry)proxyService.registries.get(this.serviceName);
            if (registry != null) {
                registry.destroyProxy(this.objectId, false);
            }
            proxyService.destroyLocalDistributedObject(this.serviceName, this.objectId);
        }

        @Override
        public boolean returnsResponse() {
            return true;
        }

        @Override
        public Object getResponse() {
            return Boolean.TRUE;
        }

        @Override
        protected void writeInternal(ObjectDataOutput out) throws IOException {
            super.writeInternal(out);
            out.writeUTF(this.serviceName);
            out.writeObject(this.objectId);
        }

        @Override
        protected void readInternal(ObjectDataInput in) throws IOException {
            super.readInternal(in);
            this.serviceName = in.readUTF();
            this.objectId = in.readObject();
        }
    }

    private class ProxyEventProcessor
    implements StripedRunnable {
        final DistributedObjectEvent.EventType type;
        final String serviceName;
        final DistributedObject object;

        private ProxyEventProcessor(DistributedObjectEvent.EventType eventType, String serviceName, DistributedObject object) {
            this.type = eventType;
            this.serviceName = serviceName;
            this.object = object;
        }

        @Override
        public void run() {
            DistributedObjectEvent event = new DistributedObjectEvent(this.type, this.serviceName, this.object);
            for (DistributedObjectListener listener : ProxyServiceImpl.this.listeners.values()) {
                listener.distributedObjectCreated(event);
            }
        }

        @Override
        public int getKey() {
            return this.object.getId().hashCode();
        }
    }

    private class ProxyRegistry {
        final String serviceName;
        final RemoteService service;
        final ConcurrentMap<Object, DistributedObject> proxies = new ConcurrentHashMap<Object, DistributedObject>();

        private ProxyRegistry(String serviceName) {
            this.serviceName = serviceName;
            this.service = (RemoteService)ProxyServiceImpl.this.nodeEngine.getService(serviceName);
            if (this.service == null) {
                if (ProxyServiceImpl.this.nodeEngine.isActive()) {
                    throw new IllegalArgumentException("Unknown service: " + serviceName);
                }
                throw new HazelcastInstanceNotActiveException();
            }
        }

        DistributedObject getProxy(Object objectId, boolean publishEvent) {
            DistributedObject proxy = (DistributedObject)this.proxies.get(objectId);
            if (proxy == null) {
                if (!ProxyServiceImpl.this.nodeEngine.isActive()) {
                    throw new HazelcastInstanceNotActiveException();
                }
                proxy = this.service.createDistributedObject(objectId);
                DistributedObject current = this.proxies.putIfAbsent(objectId, proxy);
                if (current == null) {
                    if (proxy instanceof InitializingObject) {
                        try {
                            ((InitializingObject)((Object)proxy)).initialize();
                        }
                        catch (Exception e) {
                            ProxyServiceImpl.this.logger.warning("Error while initializing proxy: " + proxy, e);
                        }
                    }
                    ((ProxyServiceImpl)ProxyServiceImpl.this).nodeEngine.eventService.executeEvent(new ProxyEventProcessor(DistributedObjectEvent.EventType.CREATED, this.serviceName, proxy));
                    if (publishEvent) {
                        this.publish(new DistributedObjectEventPacket(DistributedObjectEvent.EventType.CREATED, this.serviceName, objectId));
                    }
                } else {
                    proxy = current;
                }
            }
            return proxy;
        }

        void destroyProxy(Object objectId, boolean publishEvent) {
            DistributedObject proxy = (DistributedObject)this.proxies.remove(objectId);
            if (proxy != null) {
                ((ProxyServiceImpl)ProxyServiceImpl.this).nodeEngine.eventService.executeEvent(new ProxyEventProcessor(DistributedObjectEvent.EventType.DESTROYED, this.serviceName, proxy));
                if (publishEvent) {
                    this.publish(new DistributedObjectEventPacket(DistributedObjectEvent.EventType.DESTROYED, this.serviceName, objectId));
                }
            }
        }

        private void publish(DistributedObjectEventPacket event) {
            EventService eventService = ProxyServiceImpl.this.nodeEngine.getEventService();
            Collection<EventRegistration> registrations = eventService.getRegistrations(ProxyServiceImpl.SERVICE_NAME, ProxyServiceImpl.SERVICE_NAME);
            eventService.publishEvent(ProxyServiceImpl.SERVICE_NAME, registrations, (Object)event, event.getObjectId().hashCode());
        }

        private boolean contains(Object objectId) {
            return this.proxies.containsKey(objectId);
        }

        void destroy() {
            for (DistributedObject distributedObject : this.proxies.values()) {
                if (!(distributedObject instanceof AbstractDistributedObject)) continue;
                DistributedObjectAccessor.onNodeShutdown((AbstractDistributedObject)distributedObject);
            }
            this.proxies.clear();
        }
    }
}

