/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.util.function.Supplier;
import org.springframework.data.util.DefaultLock;
import org.springframework.util.Assert;

public interface Lock {
    public static Lock of(java.util.concurrent.locks.Lock delegate) {
        Assert.notNull((Object)delegate, (String)"Lock delegate must not be null");
        return new DefaultLock(delegate);
    }

    public AcquiredLock lock();

    public AcquiredLock lockInterruptibly() throws InterruptedException;

    default public <T> T execute(Supplier<T> action) {
        try (AcquiredLock l = this.lock();){
            T t = action.get();
            return t;
        }
    }

    default public void executeWithoutResult(Runnable action) {
        try (AcquiredLock l = this.lock();){
            action.run();
        }
    }

    public static interface AcquiredLock
    extends AutoCloseable {
        @Override
        public void close();
    }
}

