/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.loader.ast.spi.MultiIdEntityLoader;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;

public abstract class AbstractMultiIdEntityLoader<T>
implements MultiIdEntityLoader<T> {
    private final EntityMappingType entityDescriptor;
    private final SessionFactoryImplementor sessionFactory;
    private final EntityIdentifierMapping identifierMapping;

    public AbstractMultiIdEntityLoader(EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.sessionFactory = sessionFactory;
        this.identifierMapping = this.getLoadable().getIdentifierMapping();
    }

    protected EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }

    protected SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public EntityIdentifierMapping getIdentifierMapping() {
        return this.identifierMapping;
    }

    @Override
    public EntityMappingType getLoadable() {
        return this.getEntityDescriptor();
    }

    @Override
    public final <K> List<T> load(K[] ids, MultiIdLoadOptions loadOptions, EventSource session) {
        assert (ids != null);
        if (loadOptions.isOrderReturnEnabled()) {
            return this.performOrderedMultiLoad(ids, loadOptions, session);
        }
        return this.performUnorderedMultiLoad(ids, loadOptions, session);
    }

    protected abstract <K> List<T> performOrderedMultiLoad(K[] var1, MultiIdLoadOptions var2, EventSource var3);

    protected abstract <K> List<T> performUnorderedMultiLoad(K[] var1, MultiIdLoadOptions var2, EventSource var3);
}

