/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.resource;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.concurrent.Callable;
import org.keycloak.authorization.client.representation.ServerConfiguration;
import org.keycloak.authorization.client.util.Http;
import org.keycloak.authorization.client.util.Throwables;
import org.keycloak.authorization.client.util.TokenCallable;
import org.keycloak.common.util.Encode;
import org.keycloak.representations.idm.authorization.UmaPermissionRepresentation;
import org.keycloak.util.JsonSerialization;

public class PolicyResource {
    private String resourceId;
    private final Http http;
    private final ServerConfiguration serverConfiguration;
    private final TokenCallable pat;

    public PolicyResource(String resourceId, Http http, ServerConfiguration serverConfiguration, TokenCallable pat) {
        this.resourceId = resourceId;
        this.http = http;
        this.serverConfiguration = serverConfiguration;
        this.pat = pat;
    }

    public UmaPermissionRepresentation create(final UmaPermissionRepresentation permission) {
        if (permission == null) {
            throw new IllegalArgumentException("Permission must not be null");
        }
        Callable<UmaPermissionRepresentation> callable = new Callable<UmaPermissionRepresentation>(){

            @Override
            public UmaPermissionRepresentation call() throws Exception {
                return PolicyResource.this.http.post(PolicyResource.this.serverConfiguration.getPolicyEndpoint() + "/" + Encode.encodePathAsIs((String)PolicyResource.this.resourceId)).authorizationBearer(PolicyResource.this.pat.call()).json(JsonSerialization.writeValueAsBytes((Object)permission)).response().json(UmaPermissionRepresentation.class).execute();
            }
        };
        try {
            return (UmaPermissionRepresentation)callable.call();
        }
        catch (Exception cause) {
            return Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Error creating policy for resource [" + this.resourceId + "]", cause);
        }
    }

    public void update(final UmaPermissionRepresentation permission) {
        if (permission == null) {
            throw new IllegalArgumentException("Permission must not be null");
        }
        if (permission.getId() == null) {
            throw new IllegalArgumentException("Permission id must not be null");
        }
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                PolicyResource.this.http.put(PolicyResource.this.serverConfiguration.getPolicyEndpoint() + "/" + Encode.encodePathAsIs((String)permission.getId())).authorizationBearer(PolicyResource.this.pat.call()).json(JsonSerialization.writeValueAsBytes((Object)permission)).execute();
                return null;
            }
        };
        try {
            callable.call();
        }
        catch (Exception cause) {
            Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Error updating policy for resource [" + this.resourceId + "]", cause);
        }
    }

    public void delete(final String id) {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() {
                PolicyResource.this.http.delete(PolicyResource.this.serverConfiguration.getPolicyEndpoint() + "/" + Encode.encodePathAsIs((String)id)).authorizationBearer(PolicyResource.this.pat.call()).response().execute();
                return null;
            }
        };
        try {
            callable.call();
        }
        catch (Exception cause) {
            Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Error updating policy for resource [" + this.resourceId + "]", cause);
        }
    }

    public List<UmaPermissionRepresentation> find(final String name, final String scope, final Integer firstResult, final Integer maxResult) {
        Callable<List<UmaPermissionRepresentation>> callable = new Callable<List<UmaPermissionRepresentation>>(){

            @Override
            public List<UmaPermissionRepresentation> call() {
                return (List)PolicyResource.this.http.get(PolicyResource.this.serverConfiguration.getPolicyEndpoint()).authorizationBearer(PolicyResource.this.pat.call()).param("name", name).param("resource", PolicyResource.this.resourceId).param("scope", scope).param("first", firstResult == null ? null : firstResult.toString()).param("max", maxResult == null ? null : maxResult.toString()).response().json((TypeReference)new TypeReference<List<UmaPermissionRepresentation>>(){}).execute();
            }
        };
        try {
            return (List)callable.call();
        }
        catch (Exception cause) {
            return Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Error querying policies for resource [" + this.resourceId + "]", cause);
        }
    }

    public UmaPermissionRepresentation findById(final String id) {
        if (id == null) {
            throw new IllegalArgumentException("Permission id must not be null");
        }
        Callable<UmaPermissionRepresentation> callable = new Callable<UmaPermissionRepresentation>(){

            @Override
            public UmaPermissionRepresentation call() {
                return PolicyResource.this.http.get(PolicyResource.this.serverConfiguration.getPolicyEndpoint() + "/" + Encode.encodePathAsIs((String)id)).authorizationBearer(PolicyResource.this.pat.call()).response().json(UmaPermissionRepresentation.class).execute();
            }
        };
        try {
            return (UmaPermissionRepresentation)callable.call();
        }
        catch (Exception cause) {
            return Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Error creating policy for resource [" + this.resourceId + "]", cause);
        }
    }
}

