/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;

public class AttributesImplSerializer
implements Attributes {
    private Map m_uri2LocalMap;
    private Map m_qName2Index;
    private static final int MAX = 12;
    private static final int MAXMinus1 = 11;
    private int m_numUsed = 0;
    private AttributeImpl[] m_data = new AttributeImpl[this.m_capacity];
    private static final int s_initialCapacity = 0;
    private int m_capacity = 0;

    @Override
    public int getIndex(String string) {
        int n = this.m_numUsed;
        if (n < 12) {
            for (int i = 0; i < n; ++i) {
                if (!this.m_data[i].m_qName.equals(string)) continue;
                return i;
            }
            return -1;
        }
        Integer n2 = (Integer)this.m_qName2Index.get(string);
        int n3 = n2 == null ? -1 : n2;
        return n3;
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5, int n) {
        int n2 = this.m_numUsed++;
        this.ensureCapacity(n2 + 1);
        AttributeImpl attributeImpl = this.m_data[n2];
        attributeImpl.m_uri = string;
        attributeImpl.m_localName = string2;
        attributeImpl.m_qName = string3;
        attributeImpl.m_type = string4;
        attributeImpl.m_value = string5;
        attributeImpl.m_flags = n;
        if (n2 < 11) {
            return;
        }
        if (n2 == 11) {
            this.switchOverToHash(12);
        } else {
            Integer n3;
            if (attributeImpl.m_index == null) {
                n3 = new Integer(n2);
                attributeImpl.m_index = n3;
            } else {
                n3 = attributeImpl.m_index;
            }
            this.m_qName2Index.put(string3, n3);
            HashMap<String, Integer> hashMap = (HashMap<String, Integer>)this.m_uri2LocalMap.get(string);
            if (hashMap == null) {
                hashMap = new HashMap<String, Integer>();
                this.m_uri2LocalMap.put(string, hashMap);
            }
            hashMap.put(string2, n3);
        }
    }

    private void switchOverToHash(int n) {
        if (this.m_qName2Index == null) {
            this.m_qName2Index = new HashMap();
            this.m_uri2LocalMap = new HashMap();
        }
        for (int i = 0; i < n; ++i) {
            Integer n2;
            AttributeImpl attributeImpl = this.m_data[i];
            if (attributeImpl.m_index != null) {
                n2 = attributeImpl.m_index;
            } else {
                n2 = new Integer(i);
                attributeImpl.m_index = n2;
            }
            String string = attributeImpl.m_qName;
            this.m_qName2Index.put(string, n2);
            String string2 = attributeImpl.m_uri;
            String string3 = attributeImpl.m_localName;
            HashMap<String, Integer> hashMap = (HashMap<String, Integer>)this.m_uri2LocalMap.get(string2);
            if (hashMap == null) {
                hashMap = new HashMap<String, Integer>();
                this.m_uri2LocalMap.put(string2, hashMap);
            }
            hashMap.put(string3, n2);
        }
    }

    public void clear() {
        if (12 <= this.m_numUsed) {
            this.m_qName2Index.clear();
            this.m_uri2LocalMap.clear();
        }
        this.m_numUsed = 0;
    }

    private void setAttributes(Attributes attributes) {
        this.setAttributes2(attributes);
        int n = attributes.getLength();
        if (12 <= n) {
            this.switchOverToHash(n);
        }
    }

    @Override
    public int getIndex(String string, String string2) {
        Integer n;
        int n2 = this.m_numUsed;
        if (n2 < 12) {
            for (int i = 0; i < n2; ++i) {
                if (!this.m_data[i].m_uri.equals(string) || !this.m_data[i].m_localName.equals(string2)) continue;
                return i;
            }
            return -1;
        }
        Map map = (Map)this.m_uri2LocalMap.get(string);
        int n3 = map == null ? -1 : ((n = (Integer)map.get(string2)) == null ? -1 : n);
        return n3;
    }

    public AttributesImplSerializer() {
    }

    private AttributesImplSerializer(Attributes attributes) {
        this.setAttributes(attributes);
    }

    @Override
    public int getLength() {
        return this.m_numUsed;
    }

    @Override
    public String getURI(int n) {
        try {
            return this.m_data[n].m_uri;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public String getLocalName(int n) {
        try {
            return this.m_data[n].m_localName;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public String getQName(int n) {
        try {
            return this.m_data[n].m_qName;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public String getType(int n) {
        try {
            return this.m_data[n].m_type;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public String getValue(int n) {
        try {
            return this.m_data[n].m_value;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public String getType(String string, String string2) {
        int n = this.m_numUsed;
        for (int i = 0; i < n; ++i) {
            if (!this.m_data[i].m_uri.equals(string) || !this.m_data[i].m_localName.equals(string2)) continue;
            return this.m_data[i].m_type;
        }
        return null;
    }

    @Override
    public String getType(String string) {
        int n = this.m_numUsed;
        for (int i = 0; i < n; ++i) {
            if (!this.m_data[i].m_qName.equals(string)) continue;
            return this.m_data[i].m_type;
        }
        return null;
    }

    @Override
    public String getValue(String string, String string2) {
        int n = this.m_numUsed;
        for (int i = 0; i < n; ++i) {
            if (!this.m_data[i].m_uri.equals(string) || !this.m_data[i].m_localName.equals(string2)) continue;
            return this.m_data[i].m_value;
        }
        return null;
    }

    @Override
    public String getValue(String string) {
        int n = this.m_numUsed;
        for (int i = 0; i < n; ++i) {
            if (!this.m_data[i].m_qName.equals(string)) continue;
            return this.m_data[i].m_value;
        }
        return null;
    }

    AttributeImpl getAttribute(int n) {
        try {
            return this.m_data[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    private void setAttributes2(Attributes attributes) {
        this.clear();
        int n = attributes.getLength();
        this.ensureCapacity(n + 1);
        this.m_numUsed = attributes.getLength();
        if (this.m_numUsed > 0) {
            this.m_data = new AttributeImpl[this.m_numUsed];
            for (int i = 0; i < this.m_numUsed; ++i) {
                AttributeImpl attributeImpl = this.m_data[i];
                attributeImpl.m_uri = attributes.getURI(i);
                attributeImpl.m_localName = attributes.getLocalName(i);
                attributeImpl.m_qName = attributes.getQName(i);
                attributeImpl.m_type = attributes.getType(i);
                attributeImpl.m_value = attributes.getValue(i);
                attributeImpl.m_flags = 0;
            }
        }
    }

    private void setAttribute(int n, String string, String string2, String string3, String string4, String string5) {
        if (n >= 0 && n < this.m_numUsed) {
            AttributeImpl attributeImpl = this.m_data[n];
            attributeImpl.m_uri = string;
            attributeImpl.m_localName = string2;
            attributeImpl.m_qName = string3;
            attributeImpl.m_type = string4;
            attributeImpl.m_value = string5;
        } else {
            this.indexOutOfBounds(n);
        }
    }

    private void setURI(int n, String string) {
        if (n >= 0 && n < this.m_numUsed) {
            this.m_data[n].m_uri = string;
        } else {
            this.indexOutOfBounds(n);
        }
    }

    private void setLocalName(int n, String string) {
        if (n >= 0 && n < this.m_numUsed) {
            this.m_data[n].m_localName = string;
        } else {
            this.indexOutOfBounds(n);
        }
    }

    private void setQName(int n, String string) {
        if (n >= 0 && n < this.m_numUsed) {
            this.m_data[n].m_qName = string;
        } else {
            this.indexOutOfBounds(n);
        }
    }

    private void setType(int n, String string) {
        if (n >= 0 && n < this.m_numUsed) {
            this.m_data[n].m_type = string;
        } else {
            this.indexOutOfBounds(n);
        }
    }

    void setValue(int n, String string) {
        if (n >= 0 && n < this.m_numUsed) {
            this.m_data[n].m_value = string;
        } else {
            this.indexOutOfBounds(n);
        }
    }

    private void ensureCapacity(int n) {
        if (this.m_capacity <= n) {
            int n2 = n * 2 + 1;
            AttributeImpl[] attributeImplArray = new AttributeImpl[n2];
            if (0 < this.m_capacity) {
                System.arraycopy(this.m_data, 0, attributeImplArray, 0, this.m_capacity);
            }
            for (int i = this.m_capacity; i < n2; ++i) {
                attributeImplArray[i] = new AttributeImpl();
            }
            this.m_capacity = n2;
            this.m_data = attributeImplArray;
        }
    }

    private void indexOutOfBounds(int n) throws ArrayIndexOutOfBoundsException {
        String string = "AttributesImplSerializer: Attempt access illegal index: " + n;
        throw new ArrayIndexOutOfBoundsException(string);
    }

    class AttributeImpl {
        private String m_uri;
        private String m_localName;
        String m_qName;
        private String m_type;
        String m_value;
        int m_flags;
        private Integer m_index;

        private AttributeImpl() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Attribute: name '" + this.m_qName + "', value '" + this.m_value + "', optflags " + this.m_flags);
            return stringBuffer.toString();
        }
    }
}

