/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandlerContainer;

public class HandlerWrapper
extends AbstractHandlerContainer {
    private Handler _handler;

    public Handler getHandler() {
        return this._handler;
    }

    public void setHandler(Handler handler) {
        try {
            Handler old_handler = this._handler;
            if (this.getServer() != null) {
                this.getServer().getContainer().update((Object)this, old_handler, handler, "handler");
            }
            if (handler != null) {
                handler.setServer(this.getServer());
            }
            this._handler = handler;
            if (old_handler != null && old_handler.isStarted()) {
                old_handler.stop();
            }
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(e);
            throw ise;
        }
    }

    @Override
    public void addHandler(Handler handler) {
        Handler old = this.getHandler();
        if (old != null && !(handler instanceof HandlerContainer)) {
            throw new IllegalArgumentException("Cannot add");
        }
        this.setHandler(handler);
        if (old != null) {
            ((HandlerContainer)((Object)handler)).addHandler(old);
        }
    }

    @Override
    public void removeHandler(Handler handler) {
        Handler old = this.getHandler();
        if (old != null && old instanceof HandlerContainer) {
            ((HandlerContainer)((Object)old)).removeHandler(handler);
        } else if (old != null && handler.equals(old)) {
            this.setHandler(null);
        } else {
            throw new IllegalStateException("Cannot remove");
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (this._handler != null) {
            this._handler.start();
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this._handler != null) {
            this._handler.stop();
        }
    }

    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        if (this._handler != null && this.isStarted()) {
            this._handler.handle(target, request, response, dispatch);
        }
    }

    @Override
    public void setServer(Server server) {
        Server old_server = this.getServer();
        super.setServer(server);
        Handler h = this.getHandler();
        if (h != null) {
            h.setServer(server);
        }
        if (server != null && server != old_server) {
            server.getContainer().update((Object)this, null, this._handler, "handler");
        }
    }

    @Override
    protected Object expandChildren(Object list, Class byClass) {
        return this.expandHandler(this._handler, list, byClass);
    }
}

