/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.compiler;

import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xpath.Expression;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.UnionPathIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.functions.FuncCoreExtFunction;
import org.apache.xpath.functions.FuncExtFunction;
import org.apache.xpath.functions.FuncExtFunctionAvailable;
import org.apache.xpath.functions.Function;
import org.apache.xpath.functions.WrongNumberArgsException;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XString;
import org.apache.xpath.operations.And;
import org.apache.xpath.operations.Bool;
import org.apache.xpath.operations.Div;
import org.apache.xpath.operations.Equals;
import org.apache.xpath.operations.Gt;
import org.apache.xpath.operations.Gte;
import org.apache.xpath.operations.Lt;
import org.apache.xpath.operations.Lte;
import org.apache.xpath.operations.Minus;
import org.apache.xpath.operations.Mod;
import org.apache.xpath.operations.Mult;
import org.apache.xpath.operations.Neg;
import org.apache.xpath.operations.NotEquals;
import org.apache.xpath.operations.Number;
import org.apache.xpath.operations.Operation;
import org.apache.xpath.operations.Or;
import org.apache.xpath.operations.Plus;
import org.apache.xpath.operations.UnaryOperation;
import org.apache.xpath.operations.Variable;
import org.apache.xpath.patterns.FunctionPattern;
import org.apache.xpath.patterns.StepPattern;
import org.apache.xpath.patterns.UnionPattern;
import org.apache.xpath.res.XPATHMessages;

public class Compiler
extends OpMap {
    private boolean m_fromXPathAPI = false;
    private boolean m_isSecureProcessing = false;
    private boolean m_allowNullFcnPrefix = false;
    private XPathVariableResolver m_variableResolver;
    private XPathFunctionResolver m_functionResolver;
    private int locPathDepth = -1;
    private static final boolean DEBUG = false;
    private static long s_nextMethodId = 0L;
    private PrefixResolver m_currentPrefixResolver = null;
    private PrefixResolver defaultNamespaceContext = null;
    ErrorListener m_errorHandler;
    SourceLocator m_locator;
    Vector m_DTMIterators = null;
    private FunctionTable m_functionTable;

    public Compiler(ErrorListener errorListener, SourceLocator sourceLocator, FunctionTable functionTable) {
        this(errorListener, sourceLocator, functionTable, false);
    }

    public Compiler(ErrorListener errorListener, SourceLocator sourceLocator, FunctionTable functionTable, boolean bl) {
        this(errorListener, sourceLocator, functionTable, bl, false);
    }

    public Compiler(ErrorListener errorListener, SourceLocator sourceLocator, FunctionTable functionTable, boolean bl, boolean bl2) {
        this.m_errorHandler = errorListener;
        this.m_locator = sourceLocator;
        this.m_functionTable = functionTable;
        this.m_fromXPathAPI = bl;
        this.m_allowNullFcnPrefix = bl2;
    }

    public Compiler() {
        this.m_errorHandler = null;
        this.m_locator = null;
    }

    public void setFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        this.m_functionResolver = xPathFunctionResolver;
    }

    public void setVariableResolver(XPathVariableResolver xPathVariableResolver) {
        this.m_variableResolver = xPathVariableResolver;
    }

    public void setSecureProcessing(boolean bl) {
        this.m_isSecureProcessing = bl;
    }

    public boolean isSecureProcessing() {
        return this.m_isSecureProcessing;
    }

    public Expression compile(int n) throws TransformerException {
        int n2 = this.getOp(n);
        Expression expression = null;
        switch (n2) {
            case 1: {
                expression = this.compile(n + 2);
                break;
            }
            case 2: {
                expression = this.or(n);
                break;
            }
            case 3: {
                expression = this.and(n);
                break;
            }
            case 4: {
                expression = this.notequals(n);
                break;
            }
            case 5: {
                expression = this.equals(n);
                break;
            }
            case 6: {
                expression = this.lte(n);
                break;
            }
            case 7: {
                expression = this.lt(n);
                break;
            }
            case 8: {
                expression = this.gte(n);
                break;
            }
            case 9: {
                expression = this.gt(n);
                break;
            }
            case 10: {
                expression = this.plus(n);
                break;
            }
            case 11: {
                expression = this.minus(n);
                break;
            }
            case 12: {
                expression = this.mult(n);
                break;
            }
            case 13: {
                expression = this.div(n);
                break;
            }
            case 14: {
                expression = this.mod(n);
                break;
            }
            case 16: {
                expression = this.neg(n);
                break;
            }
            case 17: {
                expression = this.string(n);
                break;
            }
            case 18: {
                expression = this.bool(n);
                break;
            }
            case 19: {
                expression = this.number(n);
                break;
            }
            case 20: {
                expression = this.union(n);
                break;
            }
            case 21: {
                expression = this.literal(n);
                break;
            }
            case 22: {
                expression = this.variable(n);
                break;
            }
            case 23: {
                expression = this.group(n);
                break;
            }
            case 28: {
                expression = this.numberlit(n);
                break;
            }
            case 27: {
                expression = this.arg(n);
                break;
            }
            case 24: {
                expression = this.compileExtension(n);
                break;
            }
            case 25: {
                expression = this.compileExtensionShort(n);
                break;
            }
            case 26: {
                expression = this.compileFunction(n, false);
                break;
            }
            case 29: {
                expression = this.locationPath(n);
                break;
            }
            case 30: {
                expression = null;
                break;
            }
            case 31: {
                expression = this.matchPattern(n + 2);
                break;
            }
            case 32: {
                expression = this.locationPathPattern(n);
                break;
            }
            case 15: {
                this.error("ER_UNKNOWN_OPCODE", new Object[]{"quo"});
                break;
            }
            default: {
                this.error("ER_UNKNOWN_OPCODE", new Object[]{Integer.toString(this.getOp(n))});
            }
        }
        return expression;
    }

    private Expression compileOperation(Operation operation, int n) throws TransformerException {
        int n2 = Compiler.getFirstChildPos(n);
        int n3 = this.getNextOpPos(n2);
        operation.setLeftRight(this.compile(n2), this.compile(n3));
        return operation;
    }

    private Expression compileUnary(UnaryOperation unaryOperation, int n) throws TransformerException {
        int n2 = Compiler.getFirstChildPos(n);
        unaryOperation.setRight(this.compile(n2));
        return unaryOperation;
    }

    protected Expression or(int n) throws TransformerException {
        return this.compileOperation(new Or(), n);
    }

    protected Expression and(int n) throws TransformerException {
        return this.compileOperation(new And(), n);
    }

    protected Expression notequals(int n) throws TransformerException {
        return this.compileOperation(new NotEquals(), n);
    }

    protected Expression equals(int n) throws TransformerException {
        return this.compileOperation(new Equals(), n);
    }

    protected Expression lte(int n) throws TransformerException {
        return this.compileOperation(new Lte(), n);
    }

    protected Expression lt(int n) throws TransformerException {
        return this.compileOperation(new Lt(), n);
    }

    protected Expression gte(int n) throws TransformerException {
        return this.compileOperation(new Gte(), n);
    }

    protected Expression gt(int n) throws TransformerException {
        return this.compileOperation(new Gt(), n);
    }

    protected Expression plus(int n) throws TransformerException {
        return this.compileOperation(new Plus(), n);
    }

    protected Expression minus(int n) throws TransformerException {
        return this.compileOperation(new Minus(), n);
    }

    protected Expression mult(int n) throws TransformerException {
        return this.compileOperation(new Mult(), n);
    }

    protected Expression div(int n) throws TransformerException {
        return this.compileOperation(new Div(), n);
    }

    protected Expression mod(int n) throws TransformerException {
        return this.compileOperation(new Mod(), n);
    }

    protected Expression neg(int n) throws TransformerException {
        return this.compileUnary(new Neg(), n);
    }

    protected Expression string(int n) throws TransformerException {
        return this.compileUnary(new org.apache.xpath.operations.String(), n);
    }

    protected Expression bool(int n) throws TransformerException {
        return this.compileUnary(new Bool(), n);
    }

    protected Expression number(int n) throws TransformerException {
        return this.compileUnary(new Number(), n);
    }

    protected Expression literal(int n) {
        n = Compiler.getFirstChildPos(n);
        return (XString)this.getTokenQueue().elementAt(this.getOp(n));
    }

    protected Expression numberlit(int n) {
        n = Compiler.getFirstChildPos(n);
        return (XNumber)this.getTokenQueue().elementAt(this.getOp(n));
    }

    protected Expression variable(int n) throws TransformerException {
        int n2;
        Variable variable = new Variable(this.m_fromXPathAPI);
        if (this.m_fromXPathAPI) {
            variable.setVariableResolver(this.m_variableResolver);
        }
        String string = -2 == (n2 = this.getOp(n = Compiler.getFirstChildPos(n))) ? null : (String)this.getTokenQueue().elementAt(n2);
        String string2 = (String)this.getTokenQueue().elementAt(this.getOp(n + 1));
        QName qName = new QName(string, string2);
        variable.setQName(qName);
        return variable;
    }

    protected Expression group(int n) throws TransformerException {
        return this.compile(n + 2);
    }

    protected Expression arg(int n) throws TransformerException {
        return this.compile(n + 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression union(int n) throws TransformerException {
        ++this.locPathDepth;
        try {
            LocPathIterator locPathIterator = UnionPathIterator.createUnionIterator(this, n);
            return locPathIterator;
        }
        finally {
            --this.locPathDepth;
        }
    }

    public int getLocationPathDepth() {
        return this.locPathDepth;
    }

    FunctionTable getFunctionTable() {
        return this.m_functionTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression locationPath(int n) throws TransformerException {
        ++this.locPathDepth;
        try {
            DTMIterator dTMIterator = WalkerFactory.newDTMIterator(this, n, this.locPathDepth == 0);
            if (this.m_DTMIterators != null && dTMIterator != null) {
                this.m_DTMIterators.add(dTMIterator);
            }
            Expression expression = (Expression)((Object)dTMIterator);
            return expression;
        }
        finally {
            --this.locPathDepth;
        }
    }

    public Expression predicate(int n) throws TransformerException {
        return this.compile(n + 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression matchPattern(int n) throws TransformerException {
        ++this.locPathDepth;
        try {
            int n2 = n;
            int n3 = 0;
            while (this.getOp(n2) == 32) {
                n2 = this.getNextOpPos(n2);
                ++n3;
            }
            if (n3 == 1) {
                Expression expression = this.compile(n);
                return expression;
            }
            UnionPattern unionPattern = new UnionPattern();
            StepPattern[] stepPatternArray = new StepPattern[n3];
            n3 = 0;
            while (this.getOp(n) == 32) {
                n2 = this.getNextOpPos(n);
                stepPatternArray[n3] = (StepPattern)this.compile(n);
                n = n2;
                ++n3;
            }
            unionPattern.setPatterns(stepPatternArray);
            UnionPattern unionPattern2 = unionPattern;
            return unionPattern2;
        }
        finally {
            --this.locPathDepth;
        }
    }

    public Expression locationPathPattern(int n) throws TransformerException {
        n = Compiler.getFirstChildPos(n);
        return this.stepPattern(n, 0, null);
    }

    public int getWhatToShow(int n) {
        int n2 = this.getOp(n);
        int n3 = this.getOp(n + 3);
        switch (n3) {
            case 1030: {
                return 128;
            }
            case 1031: {
                return 12;
            }
            case 1032: {
                return 64;
            }
            case 1033: {
                switch (n2) {
                    case 49: {
                        return 4096;
                    }
                    case 39: 
                    case 51: {
                        return 2;
                    }
                    case 38: 
                    case 42: 
                    case 48: {
                        return -1;
                    }
                }
                if (this.getOp(0) == 31) {
                    return -1283;
                }
                return -3;
            }
            case 35: {
                return 1280;
            }
            case 1034: {
                return 65536;
            }
            case 34: {
                switch (n2) {
                    case 49: {
                        return 4096;
                    }
                    case 39: 
                    case 51: {
                        return 2;
                    }
                    case 52: 
                    case 53: {
                        return 1;
                    }
                }
                return 1;
            }
        }
        return -1;
    }

    protected StepPattern stepPattern(int n, int n2, StepPattern stepPattern) throws TransformerException {
        StepPattern stepPattern2;
        int n3;
        int n4 = n;
        int n5 = this.getOp(n);
        if (-1 == n5) {
            return null;
        }
        boolean bl = true;
        int n6 = this.getNextOpPos(n);
        switch (n5) {
            case 26: {
                bl = false;
                n3 = this.getOp(n + 1);
                stepPattern2 = new FunctionPattern(this.compileFunction(n, true), 10, 3);
                break;
            }
            case 50: {
                bl = false;
                n3 = this.getArgLengthOfStep(n);
                n = Compiler.getFirstChildPosOfStep(n);
                stepPattern2 = new StepPattern(1280, 10, 3);
                break;
            }
            case 51: {
                n3 = this.getArgLengthOfStep(n);
                n = Compiler.getFirstChildPosOfStep(n);
                stepPattern2 = new StepPattern(2, this.getStepNS(n4), this.getStepLocalName(n4), 10, 2);
                break;
            }
            case 52: {
                n3 = this.getArgLengthOfStep(n);
                n = Compiler.getFirstChildPosOfStep(n);
                int n7 = this.getWhatToShow(n4);
                if (1280 == n7) {
                    bl = false;
                }
                stepPattern2 = new StepPattern(this.getWhatToShow(n4), this.getStepNS(n4), this.getStepLocalName(n4), 0, 3);
                break;
            }
            case 53: {
                n3 = this.getArgLengthOfStep(n);
                n = Compiler.getFirstChildPosOfStep(n);
                stepPattern2 = new StepPattern(this.getWhatToShow(n4), this.getStepNS(n4), this.getStepLocalName(n4), 10, 3);
                break;
            }
            default: {
                this.error("ER_UNKNOWN_MATCH_OPERATION", null);
                return null;
            }
        }
        stepPattern2.setPredicates(this.getCompiledPredicates(n + n3));
        if (null != stepPattern) {
            stepPattern2.setRelativePathPattern(stepPattern);
        }
        StepPattern stepPattern3 = this.stepPattern(n6, n2 + 1, stepPattern2);
        return null != stepPattern3 ? stepPattern3 : stepPattern2;
    }

    public Expression[] getCompiledPredicates(int n) throws TransformerException {
        int n2 = this.countPredicates(n);
        if (n2 > 0) {
            Expression[] expressionArray = new Expression[n2];
            this.compilePredicates(n, expressionArray);
            return expressionArray;
        }
        return null;
    }

    public int countPredicates(int n) throws TransformerException {
        int n2 = 0;
        while (30 == this.getOp(n)) {
            ++n2;
            n = this.getNextOpPos(n);
        }
        return n2;
    }

    private void compilePredicates(int n, Expression[] expressionArray) throws TransformerException {
        int n2 = 0;
        while (30 == this.getOp(n)) {
            expressionArray[n2] = this.predicate(n);
            n = this.getNextOpPos(n);
            ++n2;
        }
    }

    Expression compileFunction(int n, boolean bl) throws TransformerException {
        int n2 = n + this.getOp(n + 1) - 1;
        n = Compiler.getFirstChildPos(n);
        int n3 = this.getOp(n);
        ++n;
        Function function = null;
        XPathFunction xPathFunction = null;
        if (-1 != n3) {
            Vector<Expression> vector = new Vector<Expression>();
            int n4 = 0;
            int n5 = n;
            while (n5 < n2) {
                if (bl && this.getOp(n5 + 2) != 21) {
                    this.m_errorHandler.fatalError(new TransformerException(XSLMessages.createXPATHMessage("ER_ID_KEY_PATTERN_NOT_LITERAL", new Object[0]), this.m_locator));
                }
                vector.add(this.compile(n5));
                n5 = this.getNextOpPos(n5);
                ++n4;
            }
            String string = this.m_functionTable.getOrigFunctionName(n3);
            if (!this.m_allowNullFcnPrefix) {
                function = this.m_functionTable.getFunction(n3);
            } else {
                xPathFunction = this.m_functionTable.getJAXPFunction(n3);
                if (null == xPathFunction && !this.m_functionTable.overrideKeyExists(n3)) {
                    if (null != this.m_functionResolver) {
                        xPathFunction = this.m_functionResolver.resolveFunction(new javax.xml.namespace.QName(string), n4);
                        if (null != xPathFunction) {
                            if (this.m_isSecureProcessing) {
                                XPathFunctionException xPathFunctionException = new XPathFunctionException(XPATHMessages.createXPATHMessage("ER_EXTENSION_NOT_ALLOWED_IN_SECURE_PROCESSING", new Object[]{string}));
                                throw new TransformerException(xPathFunctionException);
                            }
                            this.m_functionTable.installFunction(string, xPathFunction);
                        } else {
                            function = this.m_functionTable.getFunction(n3);
                            this.m_functionTable.installFunction(string, (XPathFunction)null);
                        }
                    }
                } else if (null == xPathFunction) {
                    function = this.m_functionTable.getFunction(n3);
                }
            }
            if (null != function) {
                if (function instanceof FuncExtFunctionAvailable) {
                    ((FuncExtFunctionAvailable)function).setFunctionTable(this.m_functionTable);
                }
                function.postCompileStep(this);
                try {
                    for (int i = 0; i < vector.size(); ++i) {
                        function.setArg((Expression)vector.get(i), i);
                    }
                    function.checkNumberArgs(vector.size());
                }
                catch (WrongNumberArgsException wrongNumberArgsException) {
                    String string2 = this.m_functionTable.getFunctionName(n3);
                    this.m_errorHandler.fatalError(new TransformerException(XSLMessages.createXPATHMessage("ER_ONLY_ALLOWS", new Object[]{string2, wrongNumberArgsException.getMessage()}), this.m_locator));
                }
                return function;
            }
            if (null != xPathFunction) {
                FuncExtFunction funcExtFunction = new FuncExtFunction(null, string, String.valueOf(this.getNextMethodId()), true);
                if (this.m_isSecureProcessing) {
                    XPathFunctionException xPathFunctionException = new XPathFunctionException(XPATHMessages.createXPATHMessage("ER_EXTENSION_NOT_ALLOWED_IN_SECURE_PROCESSING", new Object[]{((Object)funcExtFunction).toString()}));
                    throw new TransformerException(xPathFunctionException);
                }
                funcExtFunction.setXPathFunction(xPathFunction);
                try {
                    for (int i = 0; i < vector.size(); ++i) {
                        ((Function)funcExtFunction).setArg((Expression)vector.get(i), i);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return funcExtFunction;
            }
            this.error("ER_FUNCTION_TOKEN_NOT_FOUND", null);
            return null;
        }
        return null;
    }

    private synchronized long getNextMethodId() {
        if (s_nextMethodId == Long.MAX_VALUE) {
            s_nextMethodId = 0L;
        }
        return s_nextMethodId++;
    }

    private Expression compileExtension(int n) throws TransformerException {
        int n2 = n + this.getOp(n + 1) - 1;
        n = Compiler.getFirstChildPos(n);
        String string = (String)this.getTokenQueue().elementAt(this.getOp(n));
        String string2 = (String)this.getTokenQueue().elementAt(this.getOp(++n));
        ++n;
        FuncExtFunction funcExtFunction = new FuncExtFunction(string, string2, String.valueOf(this.getNextMethodId()), this.m_fromXPathAPI);
        int n3 = 0;
        try {
            while (n < n2) {
                int n4 = this.getNextOpPos(n);
                funcExtFunction.setArg(this.compile(n), n3);
                n = n4;
                ++n3;
            }
        }
        catch (WrongNumberArgsException wrongNumberArgsException) {
            // empty catch block
        }
        if (this.m_fromXPathAPI) {
            if (this.m_isSecureProcessing) {
                XPathFunctionException xPathFunctionException = new XPathFunctionException(XPATHMessages.createXPATHMessage("ER_EXTENSION_NOT_ALLOWED_IN_SECURE_PROCESSING", new Object[]{funcExtFunction.toString()}));
                throw new TransformerException(xPathFunctionException);
            }
            if (this.m_functionResolver == null) {
                XPathExpressionException xPathExpressionException = new XPathExpressionException(XPATHMessages.createXPATHMessage("ER_UNDEFINED_FUNCTION_RESOLVER", new Object[]{funcExtFunction.toString()}));
                throw new TransformerException(xPathExpressionException);
            }
            XPathFunction xPathFunction = this.m_functionResolver.resolveFunction(new javax.xml.namespace.QName(string, string2), n3);
            if (xPathFunction == null) {
                XPathExpressionException xPathExpressionException = new XPathExpressionException(XPATHMessages.createXPATHMessage("ER_UNRESOLVED_EXTENSION_FUNCTION", new Object[]{funcExtFunction.toString()}));
                throw new TransformerException(xPathExpressionException);
            }
            funcExtFunction.setXPathFunction(xPathFunction);
        }
        return funcExtFunction;
    }

    private Expression compileExtensionShort(int n) throws TransformerException {
        FuncExtFunction funcExtFunction = null;
        int n2 = n + this.getOp(n + 1) - 1;
        n = Compiler.getFirstChildPos(n);
        String string = (String)this.getTokenQueue().elementAt(this.getOp(n));
        ++n;
        if (this.m_allowNullFcnPrefix && this.m_fromXPathAPI) {
            funcExtFunction = new FuncExtFunction(null, string, String.valueOf(this.getNextMethodId()), this.m_fromXPathAPI);
            int n3 = 0;
            try {
                while (n < n2) {
                    int n4 = this.getNextOpPos(n);
                    ((Function)funcExtFunction).setArg(this.compile(n), n3);
                    n = n4;
                    ++n3;
                }
            }
            catch (WrongNumberArgsException wrongNumberArgsException) {
                // empty catch block
            }
            if (this.m_isSecureProcessing) {
                XPathFunctionException xPathFunctionException = new XPathFunctionException(XPATHMessages.createXPATHMessage("ER_EXTENSION_NOT_ALLOWED_IN_SECURE_PROCESSING", new Object[]{((Object)funcExtFunction).toString()}));
                throw new TransformerException(xPathFunctionException);
            }
            if (this.m_functionResolver == null) {
                XPathExpressionException xPathExpressionException = new XPathExpressionException(XPATHMessages.createXPATHMessage("ER_UNDEFINED_FUNCTION_RESOLVER", new Object[]{((Object)funcExtFunction).toString()}));
                throw new TransformerException(xPathExpressionException);
            }
            XPathFunction xPathFunction = this.m_functionResolver.resolveFunction(new javax.xml.namespace.QName(string), n3);
            if (xPathFunction == null) {
                XPathExpressionException xPathExpressionException = new XPathExpressionException(XPATHMessages.createXPATHMessage("ER_UNRESOLVED_EXTENSION_FUNCTION", new Object[]{((Object)funcExtFunction).toString()}));
                throw new TransformerException(xPathExpressionException);
            }
            funcExtFunction.setXPathFunction(xPathFunction);
        } else {
            String string2;
            PrefixResolver prefixResolver = this.getDefaultNamespaceContext();
            if (prefixResolver == null) {
                this.m_errorHandler.fatalError(new TransformerException(XSLMessages.createXPATHMessage("ER_COULDNOT_FIND_FUNCTION", new Object[]{string})));
            }
            if ((string2 = prefixResolver.getBaseIdentifier()) == null) {
                this.m_errorHandler.fatalError(new TransformerException(XSLMessages.createXPATHMessage("ER_COULDNOT_FIND_FUNCTION", new Object[]{string})));
            }
            funcExtFunction = new FuncCoreExtFunction(string2, string, String.valueOf(this.getNextMethodId()));
            funcExtFunction.postCompileStep(this);
            try {
                int n5 = 0;
                while (n < n2) {
                    int n6 = this.getNextOpPos(n);
                    ((Function)funcExtFunction).setArg(this.compile(n), n5);
                    n = n6;
                    ++n5;
                }
            }
            catch (WrongNumberArgsException wrongNumberArgsException) {
                this.m_errorHandler.fatalError(new TransformerException(XSLMessages.createXPATHMessage("ER_ONLY_ALLOWS", new Object[]{string, wrongNumberArgsException.getMessage()}), this.m_locator));
            }
        }
        return funcExtFunction;
    }

    public void warn(String string, Object[] objectArray) throws TransformerException {
        String string2 = XSLMessages.createXPATHWarning(string, objectArray);
        if (null != this.m_errorHandler) {
            this.m_errorHandler.warning(new TransformerException(string2, this.m_locator));
        } else {
            System.out.println(string2 + "; file " + this.m_locator.getSystemId() + "; line " + this.m_locator.getLineNumber() + "; column " + this.m_locator.getColumnNumber());
        }
    }

    public void assertion(boolean bl, String string) {
        if (!bl) {
            String string2 = XSLMessages.createXPATHMessage("ER_INCORRECT_PROGRAMMER_ASSERTION", new Object[]{string});
            throw new RuntimeException(string2);
        }
    }

    @Override
    public void error(String string, Object[] objectArray) throws TransformerException {
        String string2 = XSLMessages.createXPATHMessage(string, objectArray);
        if (null == this.m_errorHandler) {
            throw new TransformerException(string2, (SAXSourceLocator)this.m_locator);
        }
        this.m_errorHandler.fatalError(new TransformerException(string2, this.m_locator));
    }

    public PrefixResolver getNamespaceContext() {
        return this.m_currentPrefixResolver;
    }

    public void setNamespaceContext(PrefixResolver prefixResolver) {
        this.m_currentPrefixResolver = prefixResolver;
    }

    public PrefixResolver getDefaultNamespaceContext() {
        return this.defaultNamespaceContext;
    }

    public void setDefaultNamespaceContext(PrefixResolver prefixResolver) {
        this.defaultNamespaceContext = prefixResolver;
    }

    public void setSaveDTMIterators(Vector vector) {
        this.m_DTMIterators = vector;
    }
}

