/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.drivers;

import com.ibm.xtq.xslt.drivers.AutoFunctorizingXSLTLinker;
import com.ibm.xtq.xslt.drivers.ParamReferenceIdentifier;
import com.ibm.xtq.xslt.drivers.XDMTypeUpdater;
import com.ibm.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.FunctionSignature;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.LogManager;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.ModuleSignatureStore;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.Program;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.TopLevelModuleImportDirective;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.types.IntType;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class OverlapDetectionXSLTLinker {
    static final Logger s_logger = Logger.getInstance(OverlapDetectionXSLTLinker.class);

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        Cloneable cloneable;
        Object object4;
        LogManager.initializeLogger();
        XSLTCompilerSettings xSLTCompilerSettings = new XSLTCompilerSettings();
        XSLTLinkerSettings xSLTLinkerSettings = new XSLTLinkerSettings(xSLTCompilerSettings);
        xSLTLinkerSettings.setOverlapDetection(true);
        if (stringArray.length == 0) {
            s_logger.info("Usage: OverlapDetectionXSLTLinker\n        [-split n]\n        [-dumpxylem]\n        [-disablejavac]\n        [-generateBCEL]\n        [-suppressComments]\n        filename+ | -command file-with-list-of-filenames");
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            object4 = stringArray[n];
            if (((String)object4).equals("-split")) {
                if (++n == stringArray.length) {
                    s_logger.error("-split requires parameter");
                    return;
                }
                xSLTCompilerSettings.setPrereductionSplitLimit(Integer.parseInt(stringArray[n++]));
                continue;
            }
            if (((String)object4).equals("-dumpxylem")) {
                xSLTLinkerSettings.setDumpXylem(true);
                ++n;
                continue;
            }
            if (((String)object4).equals("-disablejavac")) {
                xSLTLinkerSettings.getCodeGenerationSettings().getJavaCSettings().setJavaCDisabled(true);
                ++n;
                continue;
            }
            if (((String)object4).equals("-generateBCEL")) {
                xSLTLinkerSettings.getCodeGenerationSettings().setTargetLanguage(2);
                ++n;
                continue;
            }
            if (((String)object4).equals("-suppressComments")) {
                xSLTLinkerSettings.getCodeGenerationSettings().setSuppressComments(true);
                ++n;
                continue;
            }
            if (!((String)object4).equals("-command")) break;
            if (++n == stringArray.length) {
                s_logger.error("-split requires parameter");
                return;
            }
            try {
                cloneable = new ArrayList();
                object3 = new FileReader(stringArray[n]);
                object2 = new BufferedReader((Reader)object3);
                while ((object = ((BufferedReader)object2).readLine()) != null) {
                    if (((String)(object = ((String)object).trim())).length() <= 0) continue;
                    ((ArrayList)cloneable).add(object);
                }
                ((BufferedReader)object2).close();
                ((InputStreamReader)object3).close();
            }
            catch (IOException iOException) {
                s_logger.error("Could not read command file " + stringArray[n], iOException);
                return;
            }
            stringArray = ((ArrayList)cloneable).toArray(stringArray);
            n = 0;
            break;
        }
        try {
            Object object5;
            Serializable serializable;
            object4 = new HashMap();
            cloneable = new HashMap();
            object3 = new ArrayList();
            object2 = new ArrayList();
            object = new ArrayList();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length - n; i += 2) {
                serializable = new File(stringArray[i + n]);
                s_logger.info("Reading catalog for module " + serializable);
                object5 = stringArray[i + n + 1];
                OverlapDetectionXSLTLinker.readIndividualModule(i / 2, (String)object5, serializable, (HashMap)object4, (HashMap)cloneable, (ArrayList)object3, (ArrayList)object2, (ArrayList)object);
                arrayList.add((String)object5);
            }
            Module module = new Module((String)arrayList.get(0), null, new ModuleSignature(""));
            s_logger.info("Detecting overlap");
            OverlapDetectionXSLTLinker.detectOverlap(module, (HashMap)object4, cloneable, (ArrayList)object3, (ArrayList)object2, (ArrayList)object);
            serializable = XSLTCompiler.compileRuntimeLibrary("1.0");
            module.addModuleImportDirective(new TopLevelModuleImportDirective("xslt1", ((Module)serializable).m_signature, "xslt1"));
            AutoFunctorizingXSLTLinker.handleStandardExports(module);
            object5 = ((HashMap)cloneable).values().iterator();
            while (object5.hasNext()) {
                ((ModuleRecord)object5.next()).m_raf.close();
            }
            cloneable = null;
            object4 = null;
            ParamReferenceIdentifier.fixParamReferences(module);
            module.clearTypeInformation(true);
            module.removeFunctionDerivativeInformation();
            Program.dumpXylemFile(module, null, "master");
            XSLTCompiler.postASTProcessing(module, null, xSLTCompilerSettings.getPrereductionSplitLimit(), xSLTCompilerSettings.isStreamResultOnly());
            XSLTLinker.compileProgram(module, (Module)serializable, arrayList.size(), arrayList, xSLTLinkerSettings);
            s_logger.info("Done");
        }
        catch (Exception exception) {
            s_logger.error("", exception);
        }
    }

    public static void detectOverlap(Module module, HashMap hashMap, HashMap hashMap2, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) throws Exception {
        int n;
        int[] nArray;
        Object[] objectArray;
        Object[] objectArray2;
        Object object;
        Object object2;
        String[] stringArray;
        String[] stringArray2;
        Object object3;
        Object object42;
        byte[] byArray = new byte[0x100000];
        HashMap<Object, Object> hashMap3 = new HashMap<Object, Object>();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object42 : hashMap.keySet()) {
            object3 = ((FunctionSignature)object42).getFunctionName();
            int n2 = 0;
            while (hashSet.contains(object3)) {
                object3 = (String)object3 + "$" + ++n2;
            }
            hashMap3.put(object42, object3);
            hashSet.add(object3);
        }
        object42 = new ArrayList(hashMap.values());
        Collections.sort(object42, new Comparator(){

            public int compare(Object object, Object object2) {
                ArrayList arrayList = (ArrayList)object;
                ArrayList arrayList2 = (ArrayList)object2;
                int n = arrayList2.size() - arrayList.size();
                if (n != 0) {
                    return n;
                }
                FunctionRecord functionRecord = (FunctionRecord)arrayList.get(0);
                FunctionRecord functionRecord2 = (FunctionRecord)arrayList2.get(0);
                return functionRecord.m_signature.getFunctionName().compareTo(functionRecord2.m_signature.getFunctionName());
            }
        });
        object3 = new ArrayList();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        Iterator iterator = arrayList.iterator();
        Iterator iterator2 = arrayList2.iterator();
        Iterator iterator3 = arrayList3.iterator();
        Function function = null;
        Function function2 = null;
        Function function3 = null;
        Module module2 = new Module("", null);
        int[][] nArrayArray = new int[arrayList.size()][];
        int n3 = 0;
        while (iterator.hasNext()) {
            stringArray2 = (String[])iterator.next();
            stringArray = (String[])iterator2.next();
            object2 = (FunctionRecord)iterator3.next();
            function = OverlapDetectionXSLTLinker.readFunction((FunctionRecord)stringArray2, hashMap2, byArray);
            function2 = OverlapDetectionXSLTLinker.readFunction((FunctionRecord)stringArray, hashMap2, byArray);
            function3 = OverlapDetectionXSLTLinker.readFunction((FunctionRecord)object2, hashMap2, byArray);
            function.typeCheckReduced(module2, new LinkedList());
            function2.typeCheckReduced(module2, new LinkedList());
            function3.typeCheckReduced(module2, new LinkedList());
            object = XSLTLinker.retrieveXDMStringArray(function);
            objectArray2 = XSLTLinker.retrieveXDMStringArray(function2);
            objectArray = XSLTLinker.retrieveXDMIntArray(function3);
            nArrayArray[n3] = new int[((String[])object).length];
            nArray = nArrayArray[n3];
            for (n = 0; n < ((String[])object).length; ++n) {
                nArray[n] = -1;
                for (int i = 0; i < ((ArrayList)object3).size(); ++i) {
                    if (!XSLTLinker.areStringRefsEqual(((ArrayList)object3).get(i), (String)object[n]) || !XSLTLinker.areStringRefsEqual(arrayList4.get(i), (String)objectArray2[n]) || !arrayList5.get(i).equals(new Integer(objectArray[n]))) continue;
                    nArray[n] = i;
                    break;
                }
                if (nArray[n] != -1) continue;
                nArray[n] = ((ArrayList)object3).size();
                ((ArrayList)object3).add(object[n]);
                arrayList4.add(objectArray2[n]);
                arrayList5.add(new Integer(objectArray[n]));
            }
            ++n3;
        }
        stringArray2 = new String[((ArrayList)object3).size()];
        ((ArrayList)object3).toArray(stringArray2);
        stringArray = new String[arrayList4.size()];
        arrayList4.toArray(stringArray);
        function.setBody(XSLTLinker.makeStringArrayBody(stringArray2));
        function2.setBody(XSLTLinker.makeStringArrayBody(stringArray));
        function3.setBody(XSLTLinker.makeIntArrayBody(arrayList5));
        module.addFunction(function);
        module.addFunction(function2);
        module.addFunction(function3);
        module.forceFunctionGeneration(function);
        module.forceFunctionGeneration(function2);
        module.forceFunctionGeneration(function3);
        Iterator<Object> iterator4 = ((ArrayList)object42).iterator();
        block5: while (iterator4.hasNext()) {
            Object object5;
            Binding[] bindingArray;
            Object object6;
            object2 = (ArrayList)iterator4.next();
            object = ((ArrayList)object2).iterator();
            objectArray2 = new Instruction[((ArrayList)object2).size()];
            objectArray = new Function[((ArrayList)object2).size()];
            nArray = new int[((ArrayList)object2).size()];
            n = 0;
            while (object.hasNext()) {
                object6 = (FunctionRecord)object.next();
                Function function4 = null;
                function4 = OverlapDetectionXSLTLinker.readFunction((FunctionRecord)object6, hashMap2, byArray);
                if (function4.getName().equals("main")) {
                    function4.setName("main-functor");
                } else if (!(function4.getName().equals("setupOutput") || function4.getName().equals("whitespaceRules") || function4.getName().equals("setupCharacterMaps") || function4.getName().equals("get-ns-prefix-counter"))) {
                    if (((FunctionRecord)object6).m_exported) {
                        if (module.getFunction(function4.getName()) != null) continue block5;
                        module.addFunction(function4);
                        module.forceFunctionGeneration(function4);
                        continue block5;
                    }
                    function4.setName((String)hashMap3.get(((FunctionRecord)object6).m_signature));
                }
                bindingArray = (Binding[])hashMap2.get(((FunctionRecord)object6).m_moduleName);
                nArray[n] = bindingArray.m_index;
                object5 = new XDMTypeUpdater((ModuleRecord)bindingArray, hashMap3){
                    final /* synthetic */ ModuleRecord val$mr;
                    final /* synthetic */ HashMap val$unifiedFunctionNameMap;
                    {
                        this.val$mr = moduleRecord;
                        this.val$unifiedFunctionNameMap = hashMap;
                    }

                    @Override
                    protected Instruction optimizeStep2(Instruction instruction) {
                        if (instruction instanceof FunctionCallInstruction) {
                            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction;
                            FunctionSignature functionSignature = (FunctionSignature)this.val$mr.m_functionNames.get(functionCallInstruction.getFunction());
                            String string = (String)this.val$unifiedFunctionNameMap.get(functionSignature);
                            Instruction[] instructionArray = new Instruction[instruction.getChildInstructionCount() + 1];
                            System.arraycopy(functionCallInstruction.m_parameters, 0, instructionArray, 1, functionCallInstruction.m_parameters.length);
                            instructionArray[0] = new IdentifierInstruction("__functorindex__");
                            functionCallInstruction.m_parameters = instructionArray;
                            functionCallInstruction.setFunction(string);
                        }
                        return super.optimizeStep2(instruction);
                    }
                };
                ((XDMTypeUpdater)object5).m_newIndices = nArrayArray[bindingArray.m_index];
                ((Optimizer)object5).optimizeFunction(function4);
                objectArray[n] = (int)function4;
                objectArray2[n++] = function4.getBody();
            }
            object6 = objectArray[0];
            boolean bl = false;
            if (((Function)object6).getName().equals("build_key")) {
                bl = true;
            }
            s_logger.debug("Merging function " + ((Function)object6).getName() + " from " + ((ArrayList)object2).size() + " modules");
            bindingArray = new Binding[((Function)object6).m_parameters.length + 1];
            System.arraycopy(((Function)object6).m_parameters, 0, bindingArray, 1, ((Function)object6).m_parameters.length);
            bindingArray[0] = new Binding((Object)"__functorindex__", IntType.s_intType);
            ((Function)object6).m_parameters = bindingArray;
            object5 = AutoFunctorizingXSLTLinker.foldTogetherOrMakeChoice((Instruction[])objectArray2, true, module, (Function)object6, nArray, hashMap2.size(), bl, null);
            ((Function)object6).setBody((Instruction)object5);
            module.addFunction((Function)object6);
        }
    }

    public static void readIndividualModule(int n, String string, File file, HashMap hashMap, HashMap hashMap2, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) throws Exception {
        int n2;
        FileInputStream fileInputStream = new FileInputStream(file);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        ModuleRecord moduleRecord = new ModuleRecord();
        moduleRecord.m_baseOffset = dataInputStream.readInt() + 4;
        ObjectInputStream objectInputStream = new ObjectInputStream(dataInputStream);
        ReadObjectFileHelper readObjectFileHelper = new ReadObjectFileHelper(new ModuleSignature(), objectInputStream, new ModuleSignatureStore(Collections.EMPTY_LIST));
        moduleRecord.m_functionNames = new HashMap();
        int n3 = readObjectFileHelper.readInt();
        for (n2 = 0; n2 < n3; ++n2) {
            FunctionRecord functionRecord = new FunctionRecord();
            functionRecord.m_offset = readObjectFileHelper.readInt();
            functionRecord.m_size = readObjectFileHelper.readInt();
            functionRecord.m_originalName = readObjectFileHelper.readString();
            functionRecord.m_exported = readObjectFileHelper.readBoolean();
            functionRecord.m_signature = new FunctionSignature();
            functionRecord.m_signature.read(readObjectFileHelper);
            functionRecord.m_moduleName = string;
            ArrayList<FunctionRecord> arrayList4 = (ArrayList<FunctionRecord>)hashMap.get(functionRecord.m_signature);
            if (arrayList4 == null) {
                arrayList4 = new ArrayList<FunctionRecord>();
                hashMap.put(functionRecord.m_signature, arrayList4);
            }
            arrayList4.add(functionRecord);
            moduleRecord.m_functionNames.put(functionRecord.m_originalName, functionRecord.m_signature);
            if (functionRecord.m_originalName.equals("xdm-names")) {
                arrayList.add(functionRecord);
                continue;
            }
            if (functionRecord.m_originalName.equals("xdm-types")) {
                arrayList3.add(functionRecord);
                continue;
            }
            if (!functionRecord.m_originalName.equals("xdm-uris")) continue;
            arrayList2.add(functionRecord);
        }
        n2 = objectInputStream.readInt();
        moduleRecord.m_instructionNames = new HashMap();
        for (int i = 0; i < n2; ++i) {
            moduleRecord.m_instructionNames.put(objectInputStream.readObject(), objectInputStream.readObject());
        }
        fileInputStream.close();
        moduleRecord.m_raf = new RandomAccessFile(file, "r");
        moduleRecord.m_index = n;
        hashMap2.put(string, moduleRecord);
    }

    public static Function readFunction(FunctionRecord functionRecord, HashMap hashMap, byte[] byArray) throws Exception {
        final ModuleRecord moduleRecord = (ModuleRecord)hashMap.get(functionRecord.m_moduleName);
        if (byArray.length < functionRecord.m_size) {
            byArray = new byte[functionRecord.m_size];
        }
        moduleRecord.m_raf.seek(moduleRecord.m_baseOffset + functionRecord.m_offset);
        moduleRecord.m_raf.read(byArray, 0, functionRecord.m_size);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        ReadObjectFileHelper readObjectFileHelper = new ReadObjectFileHelper(new ModuleSignature(), objectInputStream, new ModuleSignatureStore(Collections.EMPTY_LIST)){

            @Override
            public Instruction readInstruction(BindingEnvironment bindingEnvironment) throws Exception {
                int n = this.readInt();
                Class clazz = (Class)moduleRecord.m_instructionNames.get(new Integer(n));
                Instruction instruction = (Instruction)clazz.newInstance();
                instruction.setCachedType(this.readType());
                instruction.read(this, bindingEnvironment);
                return instruction;
            }
        };
        Function function = new Function();
        function.read(readObjectFileHelper);
        return function;
    }

    static class ModuleRecord {
        HashMap m_instructionNames;
        HashMap m_functionNames;
        RandomAccessFile m_raf;
        int m_baseOffset;
        int m_index;

        ModuleRecord() {
        }
    }

    static class FunctionRecord {
        FunctionSignature m_signature;
        int m_offset;
        int m_size;
        String m_originalName;
        String m_moduleName;
        boolean m_exported;

        FunctionRecord() {
        }
    }
}

