/*
 * Decompiled with CFR 0.152.
 */
package storm.starter;

import backtype.storm.Config;
import backtype.storm.LocalCluster;
import backtype.storm.coordination.BatchOutputCollector;
import backtype.storm.coordination.IBatchBolt;
import backtype.storm.task.TopologyContext;
import backtype.storm.testing.MemoryTransactionalSpout;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseBatchBolt;
import backtype.storm.topology.base.BaseTransactionalBolt;
import backtype.storm.transactional.ICommitter;
import backtype.storm.transactional.TransactionAttempt;
import backtype.storm.transactional.TransactionalTopologyBuilder;
import backtype.storm.transactional.partitioned.IPartitionedTransactionalSpout;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransactionalGlobalCount {
    public static final int PARTITION_TAKE_PER_BATCH = 3;
    public static final Map<Integer, List<List<Object>>> DATA = new HashMap<Integer, List<List<Object>>>(){
        {
            this.put(0, new ArrayList<List<Object>>(){
                {
                    this.add(new Values(new Object[]{"cat"}));
                    this.add(new Values(new Object[]{"dog"}));
                    this.add(new Values(new Object[]{"chicken"}));
                    this.add(new Values(new Object[]{"cat"}));
                    this.add(new Values(new Object[]{"dog"}));
                    this.add(new Values(new Object[]{"apple"}));
                }
            });
            this.put(1, new ArrayList<List<Object>>(){
                {
                    this.add(new Values(new Object[]{"cat"}));
                    this.add(new Values(new Object[]{"dog"}));
                    this.add(new Values(new Object[]{"apple"}));
                    this.add(new Values(new Object[]{"banana"}));
                }
            });
            this.put(2, new ArrayList<List<Object>>(){
                {
                    this.add(new Values(new Object[]{"cat"}));
                    this.add(new Values(new Object[]{"cat"}));
                    this.add(new Values(new Object[]{"cat"}));
                    this.add(new Values(new Object[]{"cat"}));
                    this.add(new Values(new Object[]{"cat"}));
                    this.add(new Values(new Object[]{"dog"}));
                    this.add(new Values(new Object[]{"dog"}));
                    this.add(new Values(new Object[]{"dog"}));
                    this.add(new Values(new Object[]{"dog"}));
                }
            });
        }
    };
    public static Map<String, Value> DATABASE = new HashMap<String, Value>();
    public static final String GLOBAL_COUNT_KEY = "GLOBAL-COUNT";

    public static void main(String[] args) throws Exception {
        MemoryTransactionalSpout spout = new MemoryTransactionalSpout(DATA, new Fields(new String[]{"word"}), 3);
        TransactionalTopologyBuilder builder = new TransactionalTopologyBuilder("global-count", "spout", (IPartitionedTransactionalSpout)spout, (Number)3);
        builder.setBolt("partial-count", (IBatchBolt)new BatchCount(), (Number)5).noneGrouping("spout");
        builder.setBolt("sum", (IBatchBolt)new UpdateGlobalCount()).globalGrouping("partial-count");
        LocalCluster cluster = new LocalCluster();
        Config config = new Config();
        config.setDebug(true);
        config.setMaxSpoutPending(3);
        cluster.submitTopology("global-count-topology", (Map)config, builder.buildTopology());
        Thread.sleep(3000L);
        cluster.shutdown();
    }

    public static class UpdateGlobalCount
    extends BaseTransactionalBolt
    implements ICommitter {
        TransactionAttempt _attempt;
        BatchOutputCollector _collector;
        int _sum = 0;

        public void prepare(Map conf, TopologyContext context, BatchOutputCollector collector, TransactionAttempt attempt) {
            this._collector = collector;
            this._attempt = attempt;
        }

        public void execute(Tuple tuple) {
            this._sum += tuple.getInteger(1).intValue();
        }

        public void finishBatch() {
            Value newval;
            Value val = DATABASE.get(TransactionalGlobalCount.GLOBAL_COUNT_KEY);
            if (val == null || !val.txid.equals(this._attempt.getTransactionId())) {
                newval = new Value();
                newval.txid = this._attempt.getTransactionId();
                newval.count = val == null ? this._sum : this._sum + val.count;
                DATABASE.put(TransactionalGlobalCount.GLOBAL_COUNT_KEY, newval);
            } else {
                newval = val;
            }
            this._collector.emit((List)new Values(new Object[]{this._attempt, newval.count}));
        }

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
            declarer.declare(new Fields(new String[]{"id", "sum"}));
        }
    }

    public static class BatchCount
    extends BaseBatchBolt {
        Object _id;
        BatchOutputCollector _collector;
        int _count = 0;

        public void prepare(Map conf, TopologyContext context, BatchOutputCollector collector, Object id) {
            this._collector = collector;
            this._id = id;
        }

        public void execute(Tuple tuple) {
            ++this._count;
        }

        public void finishBatch() {
            this._collector.emit((List)new Values(new Object[]{this._id, this._count}));
        }

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
            declarer.declare(new Fields(new String[]{"id", "count"}));
        }
    }

    public static class Value {
        int count = 0;
        BigInteger txid;
    }
}

