/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.tools.rumen.DeepCompare;
import org.apache.hadoop.tools.rumen.DeepInequalityException;
import org.apache.hadoop.tools.rumen.JhCounter;
import org.apache.hadoop.tools.rumen.JhCounterGroup;
import org.apache.hadoop.tools.rumen.JhCounters;
import org.apache.hadoop.tools.rumen.LoggedLocation;
import org.apache.hadoop.tools.rumen.Pre21JobHistoryConstants;
import org.apache.hadoop.tools.rumen.ResourceUsageMetrics;
import org.apache.hadoop.tools.rumen.TreePath;
import org.codehaus.jackson.annotate.JsonAnySetter;

public class LoggedTaskAttempt
implements DeepCompare {
    String attemptID;
    Pre21JobHistoryConstants.Values result;
    long startTime = -1L;
    long finishTime = -1L;
    String hostName;
    long hdfsBytesRead = -1L;
    long hdfsBytesWritten = -1L;
    long fileBytesRead = -1L;
    long fileBytesWritten = -1L;
    long mapInputRecords = -1L;
    long mapInputBytes = -1L;
    long mapOutputBytes = -1L;
    long mapOutputRecords = -1L;
    long combineInputRecords = -1L;
    long reduceInputGroups = -1L;
    long reduceInputRecords = -1L;
    long reduceShuffleBytes = -1L;
    long reduceOutputRecords = -1L;
    long spilledRecords = -1L;
    long shuffleFinished = -1L;
    long sortFinished = -1L;
    LoggedLocation location;
    ResourceUsageMetrics metrics = new ResourceUsageMetrics();
    private static Set<String> alreadySeenAnySetterAttributes = new TreeSet<String>();

    LoggedTaskAttempt() {
    }

    @JsonAnySetter
    public void setUnknownAttribute(String attributeName, Object ignored) {
        if (!alreadySeenAnySetterAttributes.contains(attributeName)) {
            alreadySeenAnySetterAttributes.add(attributeName);
            System.err.println("In LoggedJob, we saw the unknown attribute " + attributeName + ".");
        }
    }

    void adjustTimes(long adjustment) {
        this.startTime += adjustment;
        this.finishTime += adjustment;
    }

    public long getShuffleFinished() {
        return this.shuffleFinished;
    }

    void setShuffleFinished(long shuffleFinished) {
        this.shuffleFinished = shuffleFinished;
    }

    public long getSortFinished() {
        return this.sortFinished;
    }

    void setSortFinished(long sortFinished) {
        this.sortFinished = sortFinished;
    }

    public String getAttemptID() {
        return this.attemptID;
    }

    void setAttemptID(String attemptID) {
        this.attemptID = attemptID;
    }

    public Pre21JobHistoryConstants.Values getResult() {
        return this.result;
    }

    void setResult(Pre21JobHistoryConstants.Values result) {
        this.result = result;
    }

    public long getStartTime() {
        return this.startTime;
    }

    void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    void setFinishTime(long finishTime) {
        this.finishTime = finishTime;
    }

    public String getHostName() {
        return this.hostName;
    }

    void setHostName(String hostName) {
        this.hostName = hostName == null ? null : hostName.intern();
    }

    public long getHdfsBytesRead() {
        return this.hdfsBytesRead;
    }

    void setHdfsBytesRead(long hdfsBytesRead) {
        this.hdfsBytesRead = hdfsBytesRead;
    }

    public long getHdfsBytesWritten() {
        return this.hdfsBytesWritten;
    }

    void setHdfsBytesWritten(long hdfsBytesWritten) {
        this.hdfsBytesWritten = hdfsBytesWritten;
    }

    public long getFileBytesRead() {
        return this.fileBytesRead;
    }

    void setFileBytesRead(long fileBytesRead) {
        this.fileBytesRead = fileBytesRead;
    }

    public long getFileBytesWritten() {
        return this.fileBytesWritten;
    }

    void setFileBytesWritten(long fileBytesWritten) {
        this.fileBytesWritten = fileBytesWritten;
    }

    public long getMapInputRecords() {
        return this.mapInputRecords;
    }

    void setMapInputRecords(long mapInputRecords) {
        this.mapInputRecords = mapInputRecords;
    }

    public long getMapOutputBytes() {
        return this.mapOutputBytes;
    }

    void setMapOutputBytes(long mapOutputBytes) {
        this.mapOutputBytes = mapOutputBytes;
    }

    public long getMapOutputRecords() {
        return this.mapOutputRecords;
    }

    void setMapOutputRecords(long mapOutputRecords) {
        this.mapOutputRecords = mapOutputRecords;
    }

    public long getCombineInputRecords() {
        return this.combineInputRecords;
    }

    void setCombineInputRecords(long combineInputRecords) {
        this.combineInputRecords = combineInputRecords;
    }

    public long getReduceInputGroups() {
        return this.reduceInputGroups;
    }

    void setReduceInputGroups(long reduceInputGroups) {
        this.reduceInputGroups = reduceInputGroups;
    }

    public long getReduceInputRecords() {
        return this.reduceInputRecords;
    }

    void setReduceInputRecords(long reduceInputRecords) {
        this.reduceInputRecords = reduceInputRecords;
    }

    public long getReduceShuffleBytes() {
        return this.reduceShuffleBytes;
    }

    void setReduceShuffleBytes(long reduceShuffleBytes) {
        this.reduceShuffleBytes = reduceShuffleBytes;
    }

    public long getReduceOutputRecords() {
        return this.reduceOutputRecords;
    }

    void setReduceOutputRecords(long reduceOutputRecords) {
        this.reduceOutputRecords = reduceOutputRecords;
    }

    public long getSpilledRecords() {
        return this.spilledRecords;
    }

    void setSpilledRecords(long spilledRecords) {
        this.spilledRecords = spilledRecords;
    }

    public LoggedLocation getLocation() {
        return this.location;
    }

    void setLocation(LoggedLocation location) {
        this.location = location;
    }

    public long getMapInputBytes() {
        return this.mapInputBytes;
    }

    void setMapInputBytes(long mapInputBytes) {
        this.mapInputBytes = mapInputBytes;
    }

    public void incorporateCounters(JhCounters counters) {
        LoggedTaskAttempt.incorporateCounter(new SetField(this){

            @Override
            void set(long val) {
                this.attempt.hdfsBytesRead = val;
            }
        }, counters, "HDFS_BYTES_READ");
        LoggedTaskAttempt.incorporateCounter(new SetField(this){

            @Override
            void set(long val) {
                this.attempt.hdfsBytesWritten = val;
            }
        }, counters, "HDFS_BYTES_WRITTEN");
        LoggedTaskAttempt.incorporateCounter(new SetField(this){

            @Override
            void set(long val) {
                this.attempt.fileBytesRead = val;
            }
        }, counters, "FILE_BYTES_READ");
        LoggedTaskAttempt.incorporateCounter(new SetField(this){

            @Override
            void set(long val) {
                this.attempt.fileBytesWritten = val;
            }
        }, counters, "FILE_BYTES_WRITTEN");
        LoggedTaskAttempt.incorporateCounter(new SetField(this){

            @Override
            void set(long val) {
                this.attempt.mapInputBytes = val;
            }
        }, counters, "MAP_INPUT_BYTES");
        LoggedTaskAttempt.incorporateCounter(new SetField(this){

            @Override
            void set(long val) {
                this.attempt.mapInputRecords = val;
            }
        }, counters, "MAP_INPUT_RECORDS");
        LoggedTaskAttempt.incorporateCounter(new SetField(this){

            @Override
            void set(long val) {
                this.attempt.mapOutputBytes = val;
            }
        }, counters, "MAP_OUTPUT_BYTES");
        LoggedTaskAttempt.incorporateCounter(new SetField(this){

            @Override
            void set(long val) {
                this.attempt.mapOutputRecords = val;
            }
        }, counters, "MAP_OUTPUT_RECORDS");
        LoggedTaskAttempt.incorporateCounter(new SetField(this){

            @Override
            void set(long val) {
                this.attempt.combineInputRecords = val;
            }
        }, counters, "COMBINE_INPUT_RECORDS");
        LoggedTaskAttempt.incorporateCounter(new SetField(this){

            @Override
            void set(long val) {
                this.attempt.reduceInputGroups = val;
            }
        }, counters, "REDUCE_INPUT_GROUPS");
        LoggedTaskAttempt.incorporateCounter(new SetField(this){

            @Override
            void set(long val) {
                this.attempt.reduceInputRecords = val;
            }
        }, counters, "REDUCE_INPUT_RECORDS");
        LoggedTaskAttempt.incorporateCounter(new SetField(this){

            @Override
            void set(long val) {
                this.attempt.reduceShuffleBytes = val;
            }
        }, counters, "REDUCE_SHUFFLE_BYTES");
        LoggedTaskAttempt.incorporateCounter(new SetField(this){

            @Override
            void set(long val) {
                this.attempt.reduceOutputRecords = val;
            }
        }, counters, "REDUCE_OUTPUT_RECORDS");
        LoggedTaskAttempt.incorporateCounter(new SetField(this){

            @Override
            void set(long val) {
                this.attempt.spilledRecords = val;
            }
        }, counters, "SPILLED_RECORDS");
        LoggedTaskAttempt.incorporateCounter(new SetField(this){

            @Override
            void set(long val) {
                LoggedTaskAttempt.this.metrics.setCumulativeCpuUsage(val);
            }
        }, counters, "CPU_MILLISECONDS");
        LoggedTaskAttempt.incorporateCounter(new SetField(this){

            @Override
            void set(long val) {
                LoggedTaskAttempt.this.metrics.setVirtualMemoryUsage(val);
            }
        }, counters, "VIRTUAL_MEMORY_BYTES");
        LoggedTaskAttempt.incorporateCounter(new SetField(this){

            @Override
            void set(long val) {
                LoggedTaskAttempt.this.metrics.setPhysicalMemoryUsage(val);
            }
        }, counters, "PHYSICAL_MEMORY_BYTES");
        LoggedTaskAttempt.incorporateCounter(new SetField(this){

            @Override
            void set(long val) {
                LoggedTaskAttempt.this.metrics.setHeapUsage(val);
            }
        }, counters, "COMMITTED_HEAP_BYTES");
    }

    public ResourceUsageMetrics getResourceUsageMetrics() {
        return this.metrics;
    }

    void setResourceUsageMetrics(ResourceUsageMetrics metrics) {
        this.metrics = metrics;
    }

    private static String canonicalizeCounterName(String nonCanonicalName) {
        String result = nonCanonicalName.toLowerCase();
        result = result.replace(' ', '|');
        result = result.replace('-', '|');
        result = result.replace('_', '|');
        result = result.replace('.', '|');
        return result;
    }

    private static void incorporateCounter(SetField thunk, JhCounters counters, String counterName) {
        counterName = LoggedTaskAttempt.canonicalizeCounterName(counterName);
        for (JhCounterGroup group : counters.groups) {
            for (JhCounter counter : group.counts) {
                if (!counterName.equals(LoggedTaskAttempt.canonicalizeCounterName(counter.name.toString()))) continue;
                thunk.set(counter.value);
                return;
            }
        }
    }

    private void compare1(String c1, String c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 == null && c2 == null) {
            return;
        }
        if (c1 == null || c2 == null || !c1.equals(c2)) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
    }

    private void compare1(long c1, long c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 != c2) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
    }

    private void compare1(Pre21JobHistoryConstants.Values c1, Pre21JobHistoryConstants.Values c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 != c2) {
            throw new DeepInequalityException(eltname + " miscompared", new TreePath(loc, eltname));
        }
    }

    private void compare1(LoggedLocation c1, LoggedLocation c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 == null && c2 == null) {
            return;
        }
        TreePath recurse = new TreePath(loc, eltname);
        if (c1 == null || c2 == null) {
            throw new DeepInequalityException(eltname + " miscompared", recurse);
        }
        c1.deepCompare(c2, recurse);
    }

    @Override
    public void deepCompare(DeepCompare comparand, TreePath loc) throws DeepInequalityException {
        if (!(comparand instanceof LoggedTaskAttempt)) {
            throw new DeepInequalityException("comparand has wrong type", loc);
        }
        LoggedTaskAttempt other = (LoggedTaskAttempt)comparand;
        this.compare1(this.attemptID, other.attemptID, loc, "attemptID");
        this.compare1(this.result, other.result, loc, "result");
        this.compare1(this.startTime, other.startTime, loc, "startTime");
        this.compare1(this.finishTime, other.finishTime, loc, "finishTime");
        this.compare1(this.hostName, other.hostName, loc, "hostName");
        this.compare1(this.hdfsBytesRead, other.hdfsBytesRead, loc, "hdfsBytesRead");
        this.compare1(this.hdfsBytesWritten, other.hdfsBytesWritten, loc, "hdfsBytesWritten");
        this.compare1(this.fileBytesRead, other.fileBytesRead, loc, "fileBytesRead");
        this.compare1(this.fileBytesWritten, other.fileBytesWritten, loc, "fileBytesWritten");
        this.compare1(this.mapInputBytes, other.mapInputBytes, loc, "mapInputBytes");
        this.compare1(this.mapInputRecords, other.mapInputRecords, loc, "mapInputRecords");
        this.compare1(this.mapOutputBytes, other.mapOutputBytes, loc, "mapOutputBytes");
        this.compare1(this.mapOutputRecords, other.mapOutputRecords, loc, "mapOutputRecords");
        this.compare1(this.combineInputRecords, other.combineInputRecords, loc, "combineInputRecords");
        this.compare1(this.reduceInputGroups, other.reduceInputGroups, loc, "reduceInputGroups");
        this.compare1(this.reduceInputRecords, other.reduceInputRecords, loc, "reduceInputRecords");
        this.compare1(this.reduceShuffleBytes, other.reduceShuffleBytes, loc, "reduceShuffleBytes");
        this.compare1(this.reduceOutputRecords, other.reduceOutputRecords, loc, "reduceOutputRecords");
        this.compare1(this.spilledRecords, other.spilledRecords, loc, "spilledRecords");
        this.compare1(this.shuffleFinished, other.shuffleFinished, loc, "shuffleFinished");
        this.compare1(this.sortFinished, other.sortFinished, loc, "sortFinished");
        this.compare1(this.location, other.location, loc, "location");
    }

    private abstract class SetField {
        LoggedTaskAttempt attempt;

        SetField(LoggedTaskAttempt attempt) {
            this.attempt = attempt;
        }

        abstract void set(long var1);
    }
}

