/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms.iowrappers;

import java.io.InputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import org.apache.axis2.transport.jms.iowrappers.JMSExceptionWrapper;

public class BytesMessageInputStream
extends InputStream {
    private final BytesMessage message;

    public BytesMessageInputStream(BytesMessage message) {
        this.message = message;
    }

    @Override
    public int read() throws JMSExceptionWrapper {
        try {
            return this.message.readByte() & 0xFF;
        }
        catch (MessageEOFException ex) {
            return -1;
        }
        catch (JMSException ex) {
            throw new JMSExceptionWrapper(ex);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws JMSExceptionWrapper {
        if (off == 0) {
            try {
                return this.message.readBytes(b, len);
            }
            catch (JMSException ex) {
                throw new JMSExceptionWrapper(ex);
            }
        }
        byte[] b2 = new byte[len];
        int c = this.read(b2);
        if (c > 0) {
            System.arraycopy(b2, 0, b, off, c);
        }
        return c;
    }

    @Override
    public int read(byte[] b) throws JMSExceptionWrapper {
        try {
            return this.message.readBytes(b);
        }
        catch (JMSException ex) {
            throw new JMSExceptionWrapper(ex);
        }
    }
}

