/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class ModuleRequires
implements Cloneable,
Node {
    private final int requires_index;
    private final int requires_flags;
    private final int requires_version_index;

    ModuleRequires(DataInput file) throws IOException {
        this.requires_index = file.readUnsignedShort();
        this.requires_flags = file.readUnsignedShort();
        this.requires_version_index = file.readUnsignedShort();
    }

    @Override
    public void accept(Visitor v) {
        v.visitModuleRequires(this);
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.requires_index);
        file.writeShort(this.requires_flags);
        file.writeShort(this.requires_version_index);
    }

    public String toString() {
        return "requires(" + this.requires_index + ", " + String.format("%04x", this.requires_flags) + ", " + this.requires_version_index + ")";
    }

    public String toString(ConstantPool constant_pool) {
        StringBuilder buf = new StringBuilder();
        String module_name = constant_pool.constantToString(this.requires_index, (byte)19);
        buf.append(Utility.compactClassName(module_name, false));
        buf.append(", ").append(String.format("%04x", this.requires_flags));
        String version = this.requires_version_index == 0 ? "0" : constant_pool.getConstantString(this.requires_version_index, (byte)1);
        buf.append(", ").append(version);
        return buf.toString();
    }

    public ModuleRequires copy() {
        try {
            return (ModuleRequires)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

