/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.nested;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import org.eclipse.jetty.ee9.nested.HandlerWrapper;
import org.eclipse.jetty.ee9.nested.HttpChannel;
import org.eclipse.jetty.ee9.nested.InetAccessSet;
import org.eclipse.jetty.ee9.nested.Request;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.InetAddressPattern;
import org.eclipse.jetty.util.component.DumpableCollection;

public class InetAccessHandler
extends HandlerWrapper {
    private final IncludeExcludeSet<InetAccessSet.PatternTuple, InetAccessSet.AccessTuple> _set = new IncludeExcludeSet(InetAccessSet.class);

    public void clear() {
        this._set.clear();
    }

    public void include(String pattern) {
        this._set.include((Object)InetAccessSet.PatternTuple.from(pattern));
    }

    public void include(String ... patterns) {
        for (String pattern : patterns) {
            this.include(pattern);
        }
    }

    public void include(String connectorName, String addressPattern, PathSpec pathSpec) {
        this._set.include((Object)new InetAccessSet.PatternTuple(connectorName, InetAddressPattern.from((String)addressPattern), pathSpec));
    }

    public void exclude(String pattern) {
        this._set.exclude((Object)InetAccessSet.PatternTuple.from(pattern));
    }

    public void exclude(String ... patterns) {
        for (String pattern : patterns) {
            this.exclude(pattern);
        }
    }

    public void exclude(String connectorName, String addressPattern, PathSpec pathSpec) {
        this._set.exclude((Object)new InetAccessSet.PatternTuple(connectorName, InetAddressPattern.from((String)addressPattern), pathSpec));
    }

    @Deprecated
    public void includeConnector(String name) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void excludeConnector(String name) {
        this._set.exclude((Object)new InetAccessSet.PatternTuple(name, null, null));
    }

    @Deprecated
    public void includeConnectors(String ... names) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void excludeConnectors(String ... names) {
        for (String name : names) {
            this.excludeConnector(name);
        }
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        InetSocketAddress address;
        HttpChannel channel = baseRequest.getHttpChannel();
        if (channel != null && (address = channel.getRemoteAddress()) != null && !this.isAllowed(address.getAddress(), baseRequest, request)) {
            response.sendError(403);
            baseRequest.setHandled(true);
            return;
        }
        this.getHandler().handle(target, baseRequest, request, response);
    }

    protected boolean isAllowed(InetAddress addr, Request baseRequest, HttpServletRequest request) {
        String connectorName = baseRequest.getHttpChannel().getConnector().getName();
        String path = baseRequest.getMetaData().getHttpURI().getCanonicalPath();
        return this._set.test((Object)new InetAccessSet.AccessTuple(connectorName, addr, path));
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new Object[]{new DumpableCollection("included", (Collection)this._set.getIncluded()), new DumpableCollection("excluded", (Collection)this._set.getExcluded())});
    }
}

