/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Policy;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.SecurityContextToken;

public class SecureConversationToken
extends SecurityContextToken {
    private Policy bootstrapPolicy;
    private OMElement issuerEpr;

    public SecureConversationToken(int version) {
        super(version);
    }

    public Policy getBootstrapPolicy() {
        return this.bootstrapPolicy;
    }

    public void setBootstrapPolicy(Policy bootstrapPolicy) {
        this.bootstrapPolicy = bootstrapPolicy;
    }

    @Override
    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.SECURE_CONVERSATION_TOKEN;
        }
        return SP11Constants.SECURE_CONVERSATION_TOKEN;
    }

    @Override
    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String prefix = this.getName().getPrefix();
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        SecureConversationToken.writeStartElement(writer, prefix, localname, namespaceURI);
        String inclusion = this.version == 2 ? SP12Constants.getAttributeValueFromInclusion(this.getInclusion()) : SP11Constants.getAttributeValueFromInclusion(this.getInclusion());
        if (inclusion != null) {
            SecureConversationToken.writeAttribute(writer, prefix, namespaceURI, "IncludeToken", inclusion);
        }
        if (this.issuerEpr != null) {
            SecureConversationToken.writeStartElement(writer, prefix, "Issuer", namespaceURI);
            this.issuerEpr.serialize(writer);
            writer.writeEndElement();
        }
        if (this.isDerivedKeys() || this.isRequireExternalUriRef() || this.isSc10SecurityContextToken() || this.bootstrapPolicy != null) {
            SecureConversationToken.writeStartElement(writer, SPConstants.POLICY);
            if (this.isDerivedKeys()) {
                SecureConversationToken.writeEmptyElement(writer, prefix, "RequireDerivedKeys", namespaceURI);
            }
            if (this.isRequireExternalUriRef()) {
                SecureConversationToken.writeEmptyElement(writer, prefix, "RequireExternalUriReference", namespaceURI);
            }
            if (this.isSc10SecurityContextToken()) {
                SecureConversationToken.writeEmptyElement(writer, prefix, "SC10SecurityContextToken", namespaceURI);
            }
            if (this.bootstrapPolicy != null) {
                SecureConversationToken.writeStartElement(writer, prefix, "BootstrapPolicy", namespaceURI);
                this.bootstrapPolicy.serialize(writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public OMElement getIssuerEpr() {
        return this.issuerEpr;
    }

    public void setIssuerEpr(OMElement issuerEpr) {
        this.issuerEpr = issuerEpr;
    }
}

