/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.policy;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.Assertion;
import org.apache.neethi.PolicyComponent;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.util.PropertyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SandeshaPolicyBean
implements Assertion {
    private SandeshaPolicyBean parent = null;
    boolean inOrder = true;
    private boolean inOrderSet = false;
    ArrayList<Integer> msgTypesToDrop = null;
    private String inMemoryStorageManagerClass = null;
    private String permanentStorageManagerClass = null;
    private String securityManagerClass = null;
    private String eprDecoratorClass = null;
    private String contextManagerClass = null;
    private long inactiveTimeoutValue;
    private boolean inactiveTimeoutValueSet = false;
    private String inactivityTimeoutMeasure;
    private long inactivityTimeoutInterval = -1L;
    private boolean inactivityTimeoutIntervalSet = false;
    private long sequenceRemovalTimeoutValue;
    private String sequenceRemovalTimeoutMeasure;
    private long sequenceRemovalTimeoutInterval = -1L;
    private boolean sequenceRemovalTimeoutIntervalSet = false;
    private long acknowledgementInterval;
    private boolean acknowledgementIntervalSet = false;
    private long retransmissionInterval;
    private boolean retransmissionIntervalSet = false;
    private boolean exponentialBackoff;
    private boolean exponentialBackoffSet = false;
    private int maximumRetransmissionCount;
    private boolean maximumRetransmissionCountSet = false;
    private boolean enableMakeConnection;
    private boolean enableMakeConnectionSet = false;
    private boolean enableRMAnonURI;
    private boolean enableRMAnonURISet = false;
    private boolean useMessageSerialization;
    private boolean useMessageSerializationSet = false;
    private boolean enforceRM;
    private boolean enforceRMSet = false;

    public SandeshaPolicyBean() {
        PropertyManager.loadPropertiesFromDefaultValues(this);
    }

    public void setInactiveTimeoutInterval(long value, String measure) {
        long timeOut = -1L;
        if (measure == null) {
            timeOut = value;
        } else if ("seconds".equals(measure)) {
            timeOut = value * 1000L;
        } else if ("minutes".equals(measure)) {
            timeOut = value * 60L * 1000L;
        } else if ("hours".equals(measure)) {
            timeOut = value * 60L * 60L * 1000L;
        } else if ("days".equals(measure)) {
            timeOut = value * 24L * 60L * 60L * 1000L;
        }
        this.inactivityTimeoutInterval = timeOut;
    }

    public void setSequenceRemovalTimeoutInterval(long value, String measure) {
        long timeOut = 0L;
        if (measure == null) {
            timeOut = value;
        } else if ("seconds".equals(measure)) {
            timeOut = value * 1000L;
        } else if ("minutes".equals(measure)) {
            timeOut = value * 60L * 1000L;
        } else if ("hours".equals(measure)) {
            timeOut = value * 60L * 60L * 1000L;
        } else if ("days".equals(measure)) {
            timeOut = value * 24L * 60L * 60L * 1000L;
        }
        this.sequenceRemovalTimeoutInterval = timeOut;
    }

    public void setAcknowledgementInterval(long acknowledgementInterval) {
        this.acknowledgementInterval = acknowledgementInterval;
        this.setAcknowledgementIntervalSet(true);
    }

    public String getInMemoryStorageManagerClass() {
        return this.inMemoryStorageManagerClass;
    }

    public void setInMemoryStorageManagerClass(String inMemoryStorageManagerClass) {
        this.inMemoryStorageManagerClass = inMemoryStorageManagerClass;
    }

    public String getPermanentStorageManagerClass() {
        return this.permanentStorageManagerClass;
    }

    public void setPermanentStorageManagerClass(String permanentStorageManagerClass) {
        this.permanentStorageManagerClass = permanentStorageManagerClass;
    }

    public boolean isInOrder() {
        return this.inOrder;
    }

    public void setInOrder(boolean inOrder) {
        this.inOrder = inOrder;
        this.setInOrderSet(true);
    }

    public ArrayList<Integer> getMsgTypesToDrop() {
        return this.msgTypesToDrop;
    }

    public void setMsgTypesToDrop(ArrayList<Integer> msgTypesToDrop) {
        this.msgTypesToDrop = msgTypesToDrop;
    }

    public void addMsgTypeToDrop(Integer typeNo) {
        if (typeNo != null) {
            if (this.msgTypesToDrop == null) {
                this.msgTypesToDrop = new ArrayList();
            }
            this.msgTypesToDrop.add(typeNo);
        }
    }

    public int getMaximumRetransmissionCount() throws SandeshaException {
        if (this.isMaximumRetransmissionCountSet()) {
            return this.maximumRetransmissionCount;
        }
        if (this.parent != null) {
            return this.parent.getMaximumRetransmissionCount();
        }
        String message = SandeshaMessageHelper.getMessage("policyHasNotBeenSet", "MaximumRetransmissionCount");
        throw new SandeshaException(message);
    }

    public void setMaximumRetransmissionCount(int maximumRetransmissionCount) {
        this.maximumRetransmissionCount = maximumRetransmissionCount;
        this.setMaximumRetransmissionCountSet(true);
    }

    public String getSecurityManagerClass() {
        return this.securityManagerClass;
    }

    public void setSecurityManagerClass(String className) {
        this.securityManagerClass = className;
    }

    public String getEPRDecoratorClass() {
        return this.eprDecoratorClass;
    }

    public void setEPRDecoratorClass(String className) {
        this.eprDecoratorClass = className;
    }

    public String getContextManagerClass() {
        return this.contextManagerClass;
    }

    public void setContextManagerClass(String className) {
        this.contextManagerClass = className;
    }

    public QName getName() {
        return Sandesha2Constants.Assertions.Q_ELEM__RMBEAN;
    }

    public boolean isOptional() {
        return false;
    }

    public PolicyComponent normalize() {
        return this;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        try {
            String localName = Sandesha2Constants.Assertions.Q_ELEM_RMASSERTION.getLocalPart();
            String namespaceURI = Sandesha2Constants.Assertions.Q_ELEM_RMASSERTION.getNamespaceURI();
            String prefix = writer.getPrefix(namespaceURI);
            if (prefix == null) {
                prefix = Sandesha2Constants.Assertions.Q_ELEM_RMASSERTION.getPrefix();
                writer.setPrefix(prefix, namespaceURI);
            }
            writer.writeStartElement(prefix, localName, namespaceURI);
            writer.writeNamespace(prefix, namespaceURI);
            String policyLocalName = Sandesha2Constants.Assertions.Q_ELEM_POLICY.getLocalPart();
            String policyNamespaceURI = Sandesha2Constants.Assertions.Q_ELEM_POLICY.getNamespaceURI();
            String wspPrefix = writer.getPrefix(policyNamespaceURI);
            if (wspPrefix == null) {
                wspPrefix = Sandesha2Constants.Assertions.Q_ELEM_POLICY.getPrefix();
                writer.writeNamespace(wspPrefix, policyNamespaceURI);
            }
            writer.writeStartElement(wspPrefix, policyLocalName, policyNamespaceURI);
            writer.writeStartElement(prefix, Sandesha2Constants.Assertions.Q_ELEM_ACK_INTERVAL.getLocalPart(), namespaceURI);
            writer.writeCharacters(Long.toString(this.getAcknowledgementInterval()));
            writer.writeEndElement();
            writer.writeStartElement(prefix, Sandesha2Constants.Assertions.Q_ELEM_RETRANS_INTERVAL.getLocalPart(), namespaceURI);
            writer.writeCharacters(Long.toString(this.getRetransmissionInterval()));
            writer.writeEndElement();
            writer.writeStartElement(prefix, Sandesha2Constants.Assertions.Q_ELEM_MAX_RETRANS_COUNT.getLocalPart(), namespaceURI);
            writer.writeCharacters(Long.toString(this.getMaximumRetransmissionCount()));
            writer.writeEndElement();
            writer.writeStartElement(prefix, Sandesha2Constants.Assertions.Q_ELEM_EXP_BACKOFF.getLocalPart(), namespaceURI);
            writer.writeCharacters(Boolean.toString(this.isExponentialBackoff()));
            writer.writeEndElement();
            writer.writeStartElement(prefix, Sandesha2Constants.Assertions.Q_ELEM_INACTIVITY_TIMEOUT.getLocalPart(), namespaceURI);
            writer.writeCharacters(Long.toString(this.getInactivityTimeoutInterval()));
            writer.writeEndElement();
            writer.writeStartElement(prefix, Sandesha2Constants.Assertions.Q_ELEM_SEQUENCE_REMOVAL_TIMEOUT.getLocalPart(), namespaceURI);
            writer.writeCharacters(Long.toString(this.getSequenceRemovalTimeoutInterval()));
            writer.writeEndElement();
            writer.writeStartElement(prefix, Sandesha2Constants.Assertions.Q_ELEM_INVOKE_INORDER.getLocalPart(), namespaceURI);
            writer.writeCharacters(Boolean.toString(this.isInOrder()));
            writer.writeEndElement();
            writer.writeStartElement(prefix, Sandesha2Constants.Assertions.Q_ELEM_MSG_TYPES_TO_DROP.getLocalPart(), namespaceURI);
            writer.writeCharacters("none");
            writer.writeEndElement();
            writer.writeStartElement(prefix, Sandesha2Constants.Assertions.Q_ELEM_STORAGE_MGR.getLocalPart(), namespaceURI);
            writer.writeStartElement(prefix, Sandesha2Constants.Assertions.Q_ELEM_INMEMORY_STORAGE_MGR.getLocalPart(), namespaceURI);
            writer.writeCharacters(this.getInMemoryStorageManagerClass());
            writer.writeEndElement();
            writer.writeStartElement(prefix, Sandesha2Constants.Assertions.Q_ELEM_PERMANENT_STORAGE_MGR.getLocalPart(), namespaceURI);
            writer.writeCharacters(this.getPermanentStorageManagerClass());
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement(prefix, Sandesha2Constants.Assertions.Q_ELEM_SEC_MGR.getLocalPart(), namespaceURI);
            writer.writeCharacters(this.getSecurityManagerClass());
            writer.writeEndElement();
            writer.writeStartElement(prefix, Sandesha2Constants.Assertions.Q_ELEM_EPR_DECORATOR.getLocalPart(), namespaceURI);
            writer.writeCharacters(this.getEPRDecoratorClass());
            writer.writeEndElement();
            writer.writeStartElement(prefix, Sandesha2Constants.Assertions.Q_ELEM_CONTEXT_MGR.getLocalPart(), namespaceURI);
            writer.writeCharacters(this.getContextManagerClass());
            writer.writeEndElement();
            writer.writeStartElement(prefix, Sandesha2Constants.Assertions.Q_ELEM_MAKE_CONNECTION.getLocalPart(), namespaceURI);
            writer.writeStartElement(prefix, Sandesha2Constants.Assertions.Q_ELEM_ENABLED.getLocalPart(), namespaceURI);
            writer.writeCharacters(Boolean.toString(this.isEnableMakeConnection()));
            writer.writeEndElement();
            writer.writeStartElement(prefix, Sandesha2Constants.Assertions.Q_ELEM_USE_RM_ANON_URI.getLocalPart(), namespaceURI);
            writer.writeCharacters(Boolean.toString(this.isEnableRMAnonURI()));
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement(prefix, Sandesha2Constants.Assertions.Q_ELEM_USE_SERIALIZATION.getLocalPart(), namespaceURI);
            writer.writeCharacters(Boolean.toString(this.isUseMessageSerialization()));
            writer.writeEndElement();
            writer.writeStartElement(prefix, Sandesha2Constants.Assertions.Q_ELEM_ENFORCE_RM.getLocalPart(), namespaceURI);
            writer.writeCharacters(Boolean.toString(this.isEnforceRM()));
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }
        catch (SandeshaException e) {
            throw new XMLStreamException((Throwable)((Object)e));
        }
    }

    public short getType() {
        return 5;
    }

    public boolean isExponentialBackoff() throws SandeshaException {
        if (this.isExponentialBackoffSet()) {
            return this.exponentialBackoff;
        }
        if (this.parent != null) {
            return this.parent.isExponentialBackoff();
        }
        String message = SandeshaMessageHelper.getMessage("policyHasNotBeenSet", "ExponentialBackoff");
        throw new SandeshaException(message);
    }

    public void setExponentialBackoff(boolean exponentialBackoff) {
        this.exponentialBackoff = exponentialBackoff;
        this.setExponentialBackoffSet(true);
    }

    public long getRetransmissionInterval() throws SandeshaException {
        if (this.isRetransmissionIntervalSet()) {
            return this.retransmissionInterval;
        }
        if (this.parent != null) {
            return this.parent.getRetransmissionInterval();
        }
        String message = SandeshaMessageHelper.getMessage("policyHasNotBeenSet", "RetransmissionInterval");
        throw new SandeshaException(message);
    }

    public void setRetransmissionInterval(long retransmissionInterval) {
        this.retransmissionInterval = retransmissionInterval;
        this.setRetransmissionIntervalSet(true);
    }

    public long getAcknowledgementInterval() throws SandeshaException {
        if (this.isAcknowledgementIntervalSet()) {
            return this.acknowledgementInterval;
        }
        if (this.parent != null) {
            return this.parent.getAcknowledgementInterval();
        }
        String message = SandeshaMessageHelper.getMessage("policyHasNotBeenSet", "AcknowledgementInterval");
        throw new SandeshaException(message);
    }

    public long getInactivityTimeoutInterval() {
        if (this.inactivityTimeoutInterval < 0L) {
            this.setInactiveTimeoutInterval(this.inactiveTimeoutValue, this.inactivityTimeoutMeasure);
        }
        return this.inactivityTimeoutInterval;
    }

    public long getSequenceRemovalTimeoutInterval() {
        if (this.sequenceRemovalTimeoutInterval < 0L) {
            this.setSequenceRemovalTimeoutInterval(this.sequenceRemovalTimeoutValue, this.sequenceRemovalTimeoutMeasure);
        }
        return this.sequenceRemovalTimeoutInterval;
    }

    public void setInactiveTimeoutValue(long inactiveTimeoutValue) {
        this.inactiveTimeoutValue = inactiveTimeoutValue;
        this.setInactiveTimeoutValueSet(true);
    }

    public void setInactivityTimeoutMeasure(String inactivityTimeoutMeasure) {
        this.inactivityTimeoutMeasure = inactivityTimeoutMeasure;
    }

    public void setSequenceRemovalTimeoutValue(long sequenceRemovalTimeoutValue) {
        this.sequenceRemovalTimeoutValue = sequenceRemovalTimeoutValue;
        this.setSequenceRemovalTimeoutValueSet(true);
    }

    public void setSequenceRemovalTimeoutMeasure(String sequenceRemovalTimeoutMeasure) {
        this.sequenceRemovalTimeoutMeasure = sequenceRemovalTimeoutMeasure;
    }

    public boolean isEnableMakeConnection() {
        return this.enableMakeConnection;
    }

    public void setEnableMakeConnection(boolean enableMakeConnection) {
        this.enableMakeConnection = enableMakeConnection;
        this.setEnableMakeConnectionSet(true);
    }

    public boolean isEnableRMAnonURI() {
        return this.enableRMAnonURI;
    }

    public void setEnableRMAnonURI(boolean enableRMAnonURI) {
        this.enableRMAnonURI = enableRMAnonURI;
        this.setEnableRMAnonURISet(true);
    }

    public boolean isUseMessageSerialization() throws SandeshaException {
        if (this.isUseMessageSerializationSet()) {
            return this.useMessageSerialization;
        }
        if (this.parent != null) {
            return this.parent.isUseMessageSerialization();
        }
        String message = SandeshaMessageHelper.getMessage("policyHasNotBeenSet", "UseMessageSerialization");
        throw new SandeshaException(message);
    }

    public void setUseMessageSerialization(boolean useMessageSerialization) {
        this.useMessageSerialization = useMessageSerialization;
        this.setUseMessageSerializationSet(true);
    }

    public boolean equal(PolicyComponent policyComponent) {
        return false;
    }

    public boolean isEnforceRM() throws SandeshaException {
        if (this.isEnforceRMSet()) {
            return this.enforceRM;
        }
        if (this.parent != null) {
            return this.parent.isEnforceRM();
        }
        String message = SandeshaMessageHelper.getMessage("policyHasNotBeenSet", "EnforceRM");
        throw new SandeshaException(message);
    }

    public void setEnforceRM(boolean enforceRM) {
        this.enforceRM = enforceRM;
        this.setEnforceRMSet(true);
    }

    protected boolean isAcknowledgementIntervalSet() {
        return this.acknowledgementIntervalSet;
    }

    protected void setAcknowledgementIntervalSet(boolean acknowledgementIntervalSet) {
        this.acknowledgementIntervalSet = acknowledgementIntervalSet;
    }

    protected boolean isEnableMakeConnectionSet() {
        return this.enableMakeConnectionSet;
    }

    protected void setEnableMakeConnectionSet(boolean enableMakeConnectionSet) {
        this.enableMakeConnectionSet = enableMakeConnectionSet;
    }

    protected boolean isEnableRMAnonURISet() {
        return this.enableRMAnonURISet;
    }

    protected void setEnableRMAnonURISet(boolean enableRMAnonURISet) {
        this.enableRMAnonURISet = enableRMAnonURISet;
    }

    protected boolean isEnforceRMSet() {
        return this.enforceRMSet;
    }

    protected void setEnforceRMSet(boolean enforceRMSet) {
        this.enforceRMSet = enforceRMSet;
    }

    protected boolean isExponentialBackoffSet() {
        return this.exponentialBackoffSet;
    }

    protected void setExponentialBackoffSet(boolean exponentialBackoffSet) {
        this.exponentialBackoffSet = exponentialBackoffSet;
    }

    protected boolean isInactiveTimeoutValueSet() {
        return this.inactiveTimeoutValueSet;
    }

    protected void setInactiveTimeoutValueSet(boolean inactiveTimeoutValueSet) {
        this.inactiveTimeoutValueSet = inactiveTimeoutValueSet;
    }

    protected void setSequenceRemovalTimeoutValueSet(boolean sequenceRemovalTimeoutIntervalSet) {
        this.sequenceRemovalTimeoutIntervalSet = sequenceRemovalTimeoutIntervalSet;
    }

    protected boolean isSequenceRemovalTimeoutValueSet() {
        return this.sequenceRemovalTimeoutIntervalSet;
    }

    protected boolean isInactivityTimeoutIntervalSet() {
        return this.inactivityTimeoutIntervalSet;
    }

    protected void setInactivityTimeoutIntervalSet(boolean inactivityTimeoutIntervalSet) {
        this.inactivityTimeoutIntervalSet = inactivityTimeoutIntervalSet;
    }

    protected boolean isInOrderSet() {
        return this.inOrderSet;
    }

    protected void setInOrderSet(boolean inOrderSet) {
        this.inOrderSet = inOrderSet;
    }

    protected boolean isMaximumRetransmissionCountSet() {
        return this.maximumRetransmissionCountSet;
    }

    protected void setMaximumRetransmissionCountSet(boolean maximumRetransmissionCountSet) {
        this.maximumRetransmissionCountSet = maximumRetransmissionCountSet;
    }

    protected boolean isRetransmissionIntervalSet() {
        return this.retransmissionIntervalSet;
    }

    protected void setRetransmissionIntervalSet(boolean retransmissionIntervalSet) {
        this.retransmissionIntervalSet = retransmissionIntervalSet;
    }

    protected boolean isUseMessageSerializationSet() {
        return this.useMessageSerializationSet;
    }

    protected void setUseMessageSerializationSet(boolean useMessageSerializationSet) {
        this.useMessageSerializationSet = useMessageSerializationSet;
    }

    public SandeshaPolicyBean getParent() {
        return this.parent;
    }

    public void setParent(SandeshaPolicyBean parent) {
        this.parent = parent;
    }

    public boolean isIgnorable() {
        return false;
    }
}

