/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.watch;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.server.watch.WatchManager;
import org.apache.zookeeper.server.watch.WatcherMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RecursiveWatchQtyTest {
    private WatchManager watchManager;
    private static final int clientQty = 25;
    private static final int iterations = 1000;

    @BeforeEach
    public void setup() {
        this.watchManager = new WatchManager();
    }

    @Test
    public void testAddRemove() {
        DummyWatcher watcher1 = new DummyWatcher();
        DummyWatcher watcher2 = new DummyWatcher();
        this.watchManager.addWatch("/a", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE);
        this.watchManager.addWatch("/b", (Watcher)watcher2, WatcherMode.PERSISTENT_RECURSIVE);
        Assertions.assertEquals((int)2, (int)this.watchManager.getRecursiveWatchQty());
        Assertions.assertTrue((boolean)this.watchManager.removeWatcher("/a", (Watcher)watcher1));
        Assertions.assertTrue((boolean)this.watchManager.removeWatcher("/b", (Watcher)watcher2));
        Assertions.assertEquals((int)0, (int)this.watchManager.getRecursiveWatchQty());
    }

    @Test
    public void testAddRemoveAlt() {
        DummyWatcher watcher1 = new DummyWatcher();
        DummyWatcher watcher2 = new DummyWatcher();
        this.watchManager.addWatch("/a", (Watcher)watcher1, WatcherMode.PERSISTENT_RECURSIVE);
        this.watchManager.addWatch("/b", (Watcher)watcher2, WatcherMode.PERSISTENT_RECURSIVE);
        Assertions.assertEquals((int)2, (int)this.watchManager.getRecursiveWatchQty());
        this.watchManager.removeWatcher((Watcher)watcher1);
        this.watchManager.removeWatcher((Watcher)watcher2);
        Assertions.assertEquals((int)0, (int)this.watchManager.getRecursiveWatchQty());
    }

    @Test
    public void testDoubleAdd() {
        DummyWatcher watcher = new DummyWatcher();
        this.watchManager.addWatch("/a", (Watcher)watcher, WatcherMode.PERSISTENT_RECURSIVE);
        this.watchManager.addWatch("/a", (Watcher)watcher, WatcherMode.PERSISTENT_RECURSIVE);
        Assertions.assertEquals((int)1, (int)this.watchManager.getRecursiveWatchQty());
        this.watchManager.removeWatcher((Watcher)watcher);
        Assertions.assertEquals((int)0, (int)this.watchManager.getRecursiveWatchQty());
    }

    @Test
    public void testSameWatcherMultiPath() {
        DummyWatcher watcher = new DummyWatcher();
        this.watchManager.addWatch("/a", (Watcher)watcher, WatcherMode.PERSISTENT_RECURSIVE);
        this.watchManager.addWatch("/a/b", (Watcher)watcher, WatcherMode.PERSISTENT_RECURSIVE);
        this.watchManager.addWatch("/a/b/c", (Watcher)watcher, WatcherMode.PERSISTENT_RECURSIVE);
        Assertions.assertEquals((int)3, (int)this.watchManager.getRecursiveWatchQty());
        Assertions.assertTrue((boolean)this.watchManager.removeWatcher("/a/b", (Watcher)watcher));
        Assertions.assertEquals((int)2, (int)this.watchManager.getRecursiveWatchQty());
        this.watchManager.removeWatcher((Watcher)watcher);
        Assertions.assertEquals((int)0, (int)this.watchManager.getRecursiveWatchQty());
    }

    @Test
    public void testDifferentWatchModes() {
        DummyWatcher watcher = new DummyWatcher();
        this.watchManager.addWatch("/a", (Watcher)watcher, WatcherMode.PERSISTENT);
        Assertions.assertEquals((int)0, (int)this.watchManager.getRecursiveWatchQty());
        this.watchManager.addWatch("/a", (Watcher)watcher, WatcherMode.PERSISTENT_RECURSIVE);
        Assertions.assertEquals((int)1, (int)this.watchManager.getRecursiveWatchQty());
        this.watchManager.addWatch("/a", (Watcher)watcher, WatcherMode.STANDARD);
        Assertions.assertEquals((int)1, (int)this.watchManager.getRecursiveWatchQty());
        Assertions.assertTrue((boolean)this.watchManager.removeWatcher("/a", (Watcher)watcher));
        Assertions.assertEquals((int)0, (int)this.watchManager.getRecursiveWatchQty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecursiveQtyConcurrency() throws Exception {
        WatchManager manager = new WatchManager();
        ExecutorService threadPool = Executors.newFixedThreadPool(25);
        List<Future> tasks = null;
        CountDownLatch completedLatch = new CountDownLatch(25);
        try {
            tasks = IntStream.range(0, 25).mapToObj(__ -> threadPool.submit(() -> this.iterate(manager, completedLatch))).collect(Collectors.toList());
            completedLatch.await();
        }
        finally {
            if (tasks != null) {
                tasks.forEach(t -> t.cancel(true));
            }
            threadPool.shutdownNow();
        }
        int expectedRecursiveQty = (int)manager.getWatch2Paths().values().stream().flatMap(paths -> paths.values().stream()).filter(stats -> stats.hasMode(WatcherMode.PERSISTENT_RECURSIVE)).count();
        Assertions.assertEquals((int)expectedRecursiveQty, (int)manager.getRecursiveWatchQty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterate(WatchManager manager, CountDownLatch completedLatch) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        try {
            for (int i = 0; i < 1000; ++i) {
                boolean doSet;
                String path = "/" + random.nextInt(25);
                boolean bl = doSet = random.nextInt(100) > 33;
                if (doSet) {
                    WatcherMode mode = WatcherMode.values()[random.nextInt(WatcherMode.values().length)];
                    manager.addWatch(path, (Watcher)new DummyWatcher(), mode);
                } else {
                    manager.removeWatcher(path, (Watcher)new DummyWatcher());
                }
                int sleepMillis = random.nextInt(2);
                if (sleepMillis <= 0) continue;
                try {
                    Thread.sleep(sleepMillis);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            completedLatch.countDown();
        }
    }

    private static class DummyWatcher
    implements Watcher {
        private DummyWatcher() {
        }

        public void process(WatchedEvent event) {
        }
    }
}

