/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CloseSessionTxnTest
extends QuorumPeerTestBase {
    @Test
    public void testCloseSessionTxnCompatile() throws Exception {
        this.testCloseSessionWithDifferentConfig(false, false);
        this.testCloseSessionWithDifferentConfig(false, true);
        this.testCloseSessionWithDifferentConfig(true, false);
        this.testCloseSessionWithDifferentConfig(true, true);
    }

    private void testCloseSessionWithDifferentConfig(boolean closeSessionEnabledOnLeader, boolean closeSessionEnabledOnFollower) throws Exception {
        int numServers = 3;
        this.servers = this.LaunchServers(3);
        int leaderId = this.servers.findLeader();
        ZooKeeperServer.setCloseSessionTxnEnabled((boolean)closeSessionEnabledOnLeader);
        int followerA = (leaderId + 1) % 3;
        this.servers.mt[followerA].shutdown();
        CloseSessionTxnTest.waitForOne(this.servers.zk[followerA], ZooKeeper.States.CONNECTING);
        String path = "/testCloseSessionTxnCompatile";
        this.servers.zk[leaderId].create(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        this.servers.restartClient(leaderId, this);
        CloseSessionTxnTest.waitForOne(this.servers.zk[leaderId], ZooKeeper.States.CONNECTED);
        System.setProperty("zookeeper.retainZKDatabase", "true");
        ZooKeeperServer.setCloseSessionTxnEnabled((boolean)closeSessionEnabledOnFollower);
        this.servers.mt[followerA].start();
        CloseSessionTxnTest.waitForOne(this.servers.zk[followerA], ZooKeeper.States.CONNECTED);
        for (int i = 0; i < 3; ++i) {
            CountDownLatch syncedLatch = new CountDownLatch(1);
            this.servers.zk[i].sync(path, (rc, path1, ctx) -> syncedLatch.countDown(), null);
            Assertions.assertTrue((boolean)syncedLatch.await(3L, TimeUnit.SECONDS));
            Assertions.assertNull((Object)this.servers.zk[i].exists(path, false));
        }
    }
}

