/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.component;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.bookkeeper.common.component.ComponentInfoPublisher;
import org.apache.bookkeeper.common.component.Lifecycle;
import org.apache.bookkeeper.common.component.LifecycleComponent;
import org.apache.bookkeeper.common.component.LifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleComponentStack
implements LifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(LifecycleComponentStack.class);
    private final String name;
    private final ImmutableList<LifecycleComponent> components;
    private final ComponentInfoPublisher componentInfoPublisher;

    public static Builder newBuilder() {
        return new Builder();
    }

    private LifecycleComponentStack(String name, ComponentInfoPublisher componentInfoPublisher, ImmutableList<LifecycleComponent> components) {
        this.name = name;
        this.componentInfoPublisher = componentInfoPublisher;
        this.components = components;
    }

    @VisibleForTesting
    public int getNumComponents() {
        return this.components.size();
    }

    @VisibleForTesting
    public LifecycleComponent getComponent(int index) {
        return (LifecycleComponent)this.components.get(index);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Lifecycle.State lifecycleState() {
        return ((LifecycleComponent)this.components.get(0)).lifecycleState();
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.components.forEach(component -> component.addLifecycleListener(listener));
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.components.forEach(component -> component.removeLifecycleListener(listener));
    }

    @Override
    public void publishInfo(ComponentInfoPublisher componentInfoPublisher) {
        this.components.forEach(component -> {
            if (log.isDebugEnabled()) {
                log.debug("calling publishInfo on {} ", component);
            }
            component.publishInfo(componentInfoPublisher);
        });
    }

    @Override
    public void start() {
        this.components.forEach(component -> {
            if (log.isDebugEnabled()) {
                log.debug("calling publishInfo on {} ", component);
            }
            component.publishInfo(this.componentInfoPublisher);
        });
        this.componentInfoPublisher.startupFinished();
        this.components.forEach(component -> component.start());
    }

    @Override
    public void stop() {
        this.components.reverse().forEach(component -> component.stop());
    }

    @Override
    public void close() {
        this.components.reverse().forEach(component -> component.close());
    }

    @Override
    public void setExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        this.components.forEach(component -> component.setExceptionHandler(handler));
    }

    public static class Builder {
        private String name;
        private ComponentInfoPublisher componentInfoPublisher;
        private final List<LifecycleComponent> components = Lists.newArrayList();

        private Builder() {
        }

        public Builder withComponentInfoPublisher(ComponentInfoPublisher componentInfoPublisher) {
            Preconditions.checkNotNull((Object)componentInfoPublisher, (Object)"ComponentInfoPublisher is null");
            this.componentInfoPublisher = componentInfoPublisher;
            return this;
        }

        public Builder addComponent(LifecycleComponent component) {
            Preconditions.checkNotNull((Object)component, (Object)"Lifecycle component is null");
            this.components.add(component);
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public LifecycleComponentStack build() {
            Preconditions.checkNotNull((Object)this.name, (Object)"Lifecycle component stack name is not provided");
            Preconditions.checkArgument((!this.components.isEmpty() ? 1 : 0) != 0, (Object)("Lifecycle component stack is empty : " + this.components));
            return new LifecycleComponentStack(this.name, this.componentInfoPublisher != null ? this.componentInfoPublisher : new ComponentInfoPublisher(), ImmutableList.copyOf(this.components));
        }
    }
}

