/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.CompletionKey;
import org.apache.bookkeeper.proto.CompletionValue;
import org.apache.bookkeeper.proto.PerChannelBookieClient;

class ForceLedgerCompletion
extends CompletionValue {
    final BookkeeperInternalCallbacks.ForceLedgerCallback cb;

    public ForceLedgerCompletion(CompletionKey key, BookkeeperInternalCallbacks.ForceLedgerCallback originalCallback, Object originalCtx, long ledgerId, PerChannelBookieClient perChannelBookieClient) {
        super("ForceLedger", originalCtx, ledgerId, -1L, perChannelBookieClient);
        this.opLogger = perChannelBookieClient.forceLedgerOpLogger;
        this.timeoutOpLogger = perChannelBookieClient.forceLedgerTimeoutOpLogger;
        this.cb = (rc, ledgerId1, addr, ctx) -> {
            this.logOpResult(rc);
            originalCallback.forceLedgerComplete(rc, ledgerId1, addr, originalCtx);
            key.release();
        };
    }

    @Override
    public void errorOut() {
        this.errorOut(-8);
    }

    @Override
    public void errorOut(int rc) {
        this.errorOutAndRunCallback(() -> this.cb.forceLedgerComplete(rc, this.ledgerId, this.perChannelBookieClient.bookieId, this.ctx));
    }

    @Override
    public void handleV3Response(BookkeeperProtocol.Response response) {
        BookkeeperProtocol.ForceLedgerResponse forceLedgerResponse = response.getForceLedgerResponse();
        BookkeeperProtocol.StatusCode status = response.getStatus() == BookkeeperProtocol.StatusCode.EOK ? forceLedgerResponse.getStatus() : response.getStatus();
        long ledgerId = forceLedgerResponse.getLedgerId();
        if (LOG.isDebugEnabled()) {
            this.logResponse(status, "ledger", ledgerId);
        }
        int rc = this.convertStatus(status, -12);
        this.cb.forceLedgerComplete(rc, ledgerId, this.perChannelBookieClient.bookieId, this.ctx);
    }
}

