/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.vector;

import com.google.common.base.Preconditions;
import io.github.jbellis.jvector.util.Bits;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.index.sai.disk.v1.vector.BitsUtil;
import org.apache.cassandra.index.sai.disk.v1.vector.DiskBinarySearch;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.RandomAccessReader;

public class OnDiskOrdinalsMap
implements AutoCloseable {
    private final FileHandle fh;
    private final long ordToRowOffset;
    private final long segmentEnd;
    private final int size;
    private final long rowOrdinalOffset;
    private final Set<Integer> deletedOrdinals = new HashSet<Integer>();

    public OnDiskOrdinalsMap(FileHandle fh, long segmentOffset, long segmentLength) {
        this.segmentEnd = segmentOffset + segmentLength;
        this.fh = fh;
        try (RandomAccessReader reader = fh.createReader();){
            reader.seek(segmentOffset);
            int deletedCount = reader.readInt();
            for (int i = 0; i < deletedCount; ++i) {
                this.deletedOrdinals.add(reader.readInt());
            }
            this.ordToRowOffset = reader.getFilePointer();
            this.size = reader.readInt();
            reader.seek(this.segmentEnd - 8L);
            this.rowOrdinalOffset = reader.readLong();
            assert (this.rowOrdinalOffset < this.segmentEnd) : "rowOrdinalOffset " + this.rowOrdinalOffset + " is not less than segmentEnd " + this.segmentEnd;
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing OnDiskOrdinalsMap at segment " + segmentOffset, e);
        }
    }

    public RowIdsView getRowIdsView() {
        return new RowIdsView();
    }

    public Bits ignoringDeleted(Bits acceptBits) {
        return BitsUtil.bitsIgnoringDeleted(acceptBits, this.deletedOrdinals);
    }

    public OrdinalsView getOrdinalsView() {
        return new OrdinalsView();
    }

    @Override
    public void close() {
        this.fh.close();
    }

    public class OrdinalsView
    implements AutoCloseable {
        final RandomAccessReader reader;
        private final long high;

        public OrdinalsView() {
            this.reader = OnDiskOrdinalsMap.this.fh.createReader();
            this.high = (OnDiskOrdinalsMap.this.segmentEnd - 8L - OnDiskOrdinalsMap.this.rowOrdinalOffset) / 8L;
        }

        public int getOrdinalForRowId(int rowId) throws IOException {
            long index = DiskBinarySearch.searchInt(0L, Math.toIntExact(this.high), rowId, i -> {
                try {
                    long offset = OnDiskOrdinalsMap.this.rowOrdinalOffset + i * 8L;
                    this.reader.seek(offset);
                    return this.reader.readInt();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            if (index < 0L) {
                return -1;
            }
            return this.reader.readInt();
        }

        @Override
        public void close() {
            this.reader.close();
        }
    }

    public class RowIdsView
    implements AutoCloseable {
        final RandomAccessReader reader;

        public RowIdsView() {
            this.reader = OnDiskOrdinalsMap.this.fh.createReader();
        }

        public int[] getSegmentRowIdsMatching(int vectorOrdinal) throws IOException {
            Preconditions.checkArgument((vectorOrdinal < OnDiskOrdinalsMap.this.size ? 1 : 0) != 0, (String)"vectorOrdinal %s is out of bounds %s", (int)vectorOrdinal, (int)OnDiskOrdinalsMap.this.size);
            try {
                this.reader.seek(OnDiskOrdinalsMap.this.ordToRowOffset + 4L + (long)vectorOrdinal * 8L);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Error seeking to index offset for ordinal %d with ordToRowOffset %d", vectorOrdinal, OnDiskOrdinalsMap.this.ordToRowOffset), e);
            }
            long offset = this.reader.readLong();
            try {
                this.reader.seek(offset);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Error seeking to rowIds offset for ordinal %d with ordToRowOffset %d", vectorOrdinal, OnDiskOrdinalsMap.this.ordToRowOffset), e);
            }
            int postingsSize = this.reader.readInt();
            int[] rowIds = new int[postingsSize];
            for (int i = 0; i < rowIds.length; ++i) {
                rowIds[i] = this.reader.readInt();
            }
            return rowIds;
        }

        @Override
        public void close() {
            this.reader.close();
        }
    }
}

