/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.bti;

import java.io.IOException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.io.sstable.format.SortedTablePartitionWriter;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.bti.RowIndexReader;
import org.apache.cassandra.io.sstable.format.bti.RowIndexWriter;
import org.apache.cassandra.io.util.SequentialWriter;

class BtiFormatPartitionWriter
extends SortedTablePartitionWriter {
    private static final int DEFAULT_GRANULARITY = 16384;
    private final RowIndexWriter rowTrie;
    private final int rowIndexBlockSize;
    private int rowIndexBlockCount;

    BtiFormatPartitionWriter(SerializationHeader header, ClusteringComparator comparator, SequentialWriter dataWriter, SequentialWriter rowIndexWriter, Version version) {
        this(header, comparator, dataWriter, rowIndexWriter, version, DatabaseDescriptor.getColumnIndexSize(16384));
    }

    BtiFormatPartitionWriter(SerializationHeader header, ClusteringComparator comparator, SequentialWriter dataWriter, SequentialWriter rowIndexWriter, Version version, int rowIndexBlockSize) {
        super(header, dataWriter, version);
        this.rowIndexBlockSize = rowIndexBlockSize;
        this.rowTrie = new RowIndexWriter(comparator, rowIndexWriter, version);
    }

    @Override
    public void reset() {
        super.reset();
        this.rowTrie.reset();
        this.rowIndexBlockCount = 0;
    }

    @Override
    public void addUnfiltered(Unfiltered unfiltered) throws IOException {
        super.addUnfiltered(unfiltered);
        if (this.currentPosition() - this.startPosition >= (long)this.rowIndexBlockSize) {
            this.addIndexBlock();
        }
    }

    @Override
    public void close() {
        this.rowTrie.close();
    }

    @Override
    public long finish() throws IOException {
        long endPosition = super.finish();
        if (this.rowIndexBlockCount > 0 && this.firstClustering != null) {
            this.addIndexBlock();
        }
        if (this.rowIndexBlockCount > 1) {
            return this.rowTrie.complete(endPosition);
        }
        return -1L;
    }

    protected void addIndexBlock() throws IOException {
        RowIndexReader.IndexInfo cIndexInfo = new RowIndexReader.IndexInfo(this.startPosition, this.startOpenMarker);
        this.rowTrie.add(this.firstClustering, this.lastClustering, cIndexInfo);
        this.firstClustering = null;
        ++this.rowIndexBlockCount;
    }

    public int getRowIndexBlockCount() {
        return this.rowIndexBlockCount;
    }
}

