/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.marshal.ValueComparators;
import org.apache.cassandra.serializers.AbstractMapSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;

public class SetSerializer<T>
extends AbstractMapSerializer<Set<T>> {
    private static final ConcurrentMap<TypeSerializer<?>, SetSerializer> instances = new ConcurrentHashMap();
    public final TypeSerializer<T> elements;
    private final ValueComparators comparators;

    public static <T> SetSerializer<T> getInstance(TypeSerializer<T> elements, ValueComparators comparators) {
        SetSerializer t = (SetSerializer)instances.get(elements);
        if (t == null) {
            t = instances.computeIfAbsent(elements, k -> new SetSerializer(k, comparators));
        }
        return t;
    }

    public SetSerializer(TypeSerializer<T> elements, ValueComparators comparators) {
        super(false);
        this.elements = elements;
        this.comparators = comparators;
    }

    @Override
    public List<ByteBuffer> serializeValues(Set<T> values) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(values.size());
        for (T value : values) {
            buffers.add(this.elements.serialize(value));
        }
        buffers.sort(this.comparators.buffer);
        return buffers;
    }

    @Override
    public int getElementCount(Set<T> value) {
        return value.size();
    }

    @Override
    public <V> void validate(V input, ValueAccessor<V> accessor) {
        if (accessor.isEmpty(input)) {
            throw new MarshalException("Not enough bytes to read a set");
        }
        try {
            if (accessor.isEmpty(input)) {
                return;
            }
            int n = SetSerializer.readCollectionSize(input, accessor);
            int offset = SetSerializer.sizeOfCollectionSize();
            for (int i = 0; i < n; ++i) {
                V value = SetSerializer.readNonNullValue(input, accessor, offset);
                offset += SetSerializer.sizeOfValue(value, accessor);
                this.elements.validate(value, accessor);
            }
            if (!accessor.isEmptyFromOffset(input, offset)) {
                throw new MarshalException("Unexpected extraneous bytes after set value");
            }
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a set");
        }
    }

    @Override
    public <V> Set<T> deserialize(V input, ValueAccessor<V> accessor) {
        try {
            int n = SetSerializer.readCollectionSize(input, accessor);
            int offset = SetSerializer.sizeOfCollectionSize();
            if (n < 0) {
                throw new MarshalException("The data cannot be deserialized as a set");
            }
            LinkedHashSet<T> l = new LinkedHashSet<T>(Math.min(n, 256));
            for (int i = 0; i < n; ++i) {
                V value = SetSerializer.readNonNullValue(input, accessor, offset);
                offset += SetSerializer.sizeOfValue(value, accessor);
                this.elements.validate(value, accessor);
                l.add(this.elements.deserialize(value, accessor));
            }
            if (!accessor.isEmptyFromOffset(input, offset)) {
                throw new MarshalException("Unexpected extraneous bytes after set value");
            }
            return l;
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a set");
        }
    }

    @Override
    public String toString(Set<T> value) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean isFirst = true;
        for (T element : value) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.elements.toString(element));
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Class<Set<T>> getType() {
        return Set.class;
    }

    @Override
    public ByteBuffer getSerializedValue(ByteBuffer input, ByteBuffer key, AbstractType<?> comparator) {
        try {
            int n = SetSerializer.readCollectionSize(input, ByteBufferAccessor.instance);
            int offset = SetSerializer.sizeOfCollectionSize();
            for (int i = 0; i < n; ++i) {
                ByteBuffer value = SetSerializer.readValue(input, ByteBufferAccessor.instance, offset);
                offset += SetSerializer.sizeOfValue(value, ByteBufferAccessor.instance);
                int comparison = comparator.compareForCQL(value, key);
                if (comparison == 0) {
                    return value;
                }
                if (comparison <= 0) continue;
                return null;
            }
            return null;
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a set");
        }
    }
}

