/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.cleaner;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.TargetMajorVersion;
import net.openhft.chronicle.core.cleaner.spi.ByteBufferCleanerService;

@TargetMajorVersion(majorVersion=9, includeNewer=true)
public final class Jdk9ByteBufferCleanerService
implements ByteBufferCleanerService {
    private static final MethodHandle INVOKE_CLEANER_METHOD = Jdk9ByteBufferCleanerService.getInvokeCleanerMethod();

    private static MethodHandle getInvokeCleanerMethod() {
        if (!Jvm.isJava9Plus()) {
            return null;
        }
        MethodType signature = MethodType.methodType(Void.TYPE, ByteBuffer.class);
        try {
            return MethodHandles.publicLookup().findVirtual(UnsafeMemory.UNSAFE.getClass(), "invokeCleaner", signature);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @Override
    public void clean(ByteBuffer buffer) {
        try {
            INVOKE_CLEANER_METHOD.invokeExact(UnsafeMemory.UNSAFE, buffer);
        }
        catch (Throwable throwable) {
            throw Jvm.rethrow(throwable);
        }
    }

    @Override
    public ByteBufferCleanerService.Impact impact() {
        return ByteBufferCleanerService.Impact.NO_IMPACT;
    }
}

