/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.sort;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.ashwood.AshwoodEntitySorter;
import org.apache.cayenne.lifecycle.sort.SortWeight;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.commons.collections.comparators.ReverseComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedAshwoodEntitySorter
extends AshwoodEntitySorter {
    private Comparator<DbEntity> weightedDbEntityComparator = new WeightedDbEntityComparator();
    private Comparator<ObjEntity> weightedObjEntityComparator = new WeightedObjEntityComparator();
    private Map<DbEntity, Integer> entityWeights = Collections.EMPTY_MAP;

    protected void doIndexSorter() {
        super.doIndexSorter();
        this.entityWeights = new HashMap<DbEntity, Integer>();
        for (ObjEntity entity : this.entityResolver.getObjEntities()) {
            Class type = this.entityResolver.getClassDescriptor(entity.getName()).getObjectClass();
            SortWeight weight = type.getAnnotation(SortWeight.class);
            if (weight == null) continue;
            this.entityWeights.put(entity.getDbEntity(), weight.value());
        }
    }

    protected Comparator<DbEntity> getDbEntityComparator(boolean dependantFirst) {
        ReverseComparator c = this.weightedDbEntityComparator;
        if (dependantFirst) {
            c = new ReverseComparator(c);
        }
        return c;
    }

    protected Comparator<ObjEntity> getObjEntityComparator(boolean dependantFirst) {
        ReverseComparator c = this.weightedObjEntityComparator;
        if (dependantFirst) {
            c = new ReverseComparator(c);
        }
        return c;
    }

    private int getWeight(DbEntity e) {
        Integer w = this.entityWeights.get(e);
        return w != null ? w : 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WeightedObjEntityComparator
    implements Comparator<ObjEntity> {
        private WeightedObjEntityComparator() {
        }

        @Override
        public int compare(ObjEntity o1, ObjEntity o2) {
            if (o1 == o2) {
                return 0;
            }
            DbEntity t1 = o1.getDbEntity();
            DbEntity t2 = o2.getDbEntity();
            return WeightedAshwoodEntitySorter.this.weightedDbEntityComparator.compare(t1, t2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class WeightedDbEntityComparator
    implements Comparator<DbEntity> {
        private WeightedDbEntityComparator() {
        }

        @Override
        public int compare(DbEntity t1, DbEntity t2) {
            if (t1 == t2) {
                return 0;
            }
            int delta = WeightedAshwoodEntitySorter.this.getWeight(t1) - WeightedAshwoodEntitySorter.this.getWeight(t2);
            return delta != 0 ? delta : WeightedAshwoodEntitySorter.this.dbEntityComparator.compare(t1, t2);
        }
    }
}

