/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master.clustermeta;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.meta.AppDiskUsageMetric;
import org.apache.celeborn.common.meta.AppDiskUsageSnapShot;
import org.apache.celeborn.common.meta.ApplicationMeta;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.DiskStatus;
import org.apache.celeborn.common.meta.WorkerEventInfo;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.meta.WorkerStatus;
import org.apache.celeborn.common.network.CelebornRackResolver;
import org.apache.celeborn.common.protocol.PbAppDiskUsageSnapshot;
import org.apache.celeborn.common.protocol.PbApplicationMeta;
import org.apache.celeborn.common.protocol.PbSnapshotMetaInfo;
import org.apache.celeborn.common.protocol.PbWorkerEventInfo;
import org.apache.celeborn.common.protocol.PbWorkerStatus;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.rpc.RpcEnv;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.PbSerDeUtils;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.common.util.WorkerStatusUtils;
import org.apache.celeborn.service.deploy.master.clustermeta.IMetadataHandler;
import org.apache.celeborn.service.deploy.master.clustermeta.ResourceProtos;
import org.apache.hadoop.net.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public abstract class AbstractMetaManager
implements IMetadataHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMetaManager.class);
    public final Set<String> registeredShuffle = ConcurrentHashMap.newKeySet();
    public final Set<String> hostnameSet = ConcurrentHashMap.newKeySet();
    public final Set<WorkerInfo> workers = ConcurrentHashMap.newKeySet();
    public final ConcurrentHashMap<WorkerInfo, Long> lostWorkers = JavaUtils.newConcurrentHashMap();
    public final ConcurrentHashMap<WorkerInfo, WorkerEventInfo> workerEventInfos = JavaUtils.newConcurrentHashMap();
    public final ConcurrentHashMap<String, Long> appHeartbeatTime = JavaUtils.newConcurrentHashMap();
    public final Set<WorkerInfo> excludedWorkers = ConcurrentHashMap.newKeySet();
    public final Set<WorkerInfo> manuallyExcludedWorkers = ConcurrentHashMap.newKeySet();
    public final Set<WorkerInfo> shutdownWorkers = ConcurrentHashMap.newKeySet();
    public final Set<WorkerInfo> workerLostEvents = ConcurrentHashMap.newKeySet();
    protected RpcEnv rpcEnv;
    protected CelebornConf conf;
    protected CelebornRackResolver rackResolver;
    public long initialEstimatedPartitionSize;
    public long estimatedPartitionSize;
    public final LongAdder partitionTotalWritten = new LongAdder();
    public final LongAdder partitionTotalFileCount = new LongAdder();
    public AppDiskUsageMetric appDiskUsageMetric = null;
    public final ConcurrentHashMap<String, ApplicationMeta> applicationMetas = JavaUtils.newConcurrentHashMap();

    public void updateRequestSlotsMeta(String shuffleKey, String hostName, Map<String, Map<String, Integer>> workerWithAllocations) {
        this.registeredShuffle.add(shuffleKey);
        String appId = (String)Utils.splitShuffleKey((String)shuffleKey)._1;
        this.appHeartbeatTime.compute(appId, (applicationId, oldTimestamp) -> {
            long oldTime = System.currentTimeMillis();
            if (oldTimestamp != null) {
                oldTime = oldTimestamp;
            }
            return Math.max(System.currentTimeMillis(), oldTime);
        });
        if (hostName != null) {
            this.hostnameSet.add(hostName);
        }
    }

    public void updateUnregisterShuffleMeta(String shuffleKey) {
        this.registeredShuffle.remove(shuffleKey);
    }

    public void updateAppHeartbeatMeta(String appId, long time, long totalWritten, long fileCount) {
        this.appHeartbeatTime.put(appId, time);
        this.partitionTotalWritten.add(totalWritten);
        this.partitionTotalFileCount.add(fileCount);
    }

    public void updateAppLostMeta(String appId) {
        this.registeredShuffle.removeIf(shuffleKey -> shuffleKey.startsWith(appId));
        this.appHeartbeatTime.remove(appId);
        this.applicationMetas.remove(appId);
    }

    public void updateWorkerExcludeMeta(List<WorkerInfo> workersToAdd, List<WorkerInfo> workersToRemove) {
        this.manuallyExcludedWorkers.addAll(workersToAdd);
        workersToRemove.forEach(this.manuallyExcludedWorkers::remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWorkerLostMeta(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort) {
        WorkerInfo worker = new WorkerInfo(host, rpcPort, pushPort, fetchPort, replicatePort);
        this.workerLostEvents.add(worker);
        Set<WorkerInfo> set = this.workers;
        synchronized (set) {
            this.workers.remove(worker);
            this.lostWorkers.put(worker, System.currentTimeMillis());
        }
        this.excludedWorkers.remove(worker);
        this.workerLostEvents.remove(worker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWorkerRemoveMeta(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort) {
        WorkerInfo worker = new WorkerInfo(host, rpcPort, pushPort, fetchPort, replicatePort);
        Set<WorkerInfo> set = this.workers;
        synchronized (set) {
            this.workers.remove(worker);
            this.lostWorkers.put(worker, System.currentTimeMillis());
        }
        this.excludedWorkers.remove(worker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWorkersUnavailableInfoMeta(List<WorkerInfo> unavailableWorkers) {
        Set<WorkerInfo> set = this.workers;
        synchronized (set) {
            for (WorkerInfo workerInfo : unavailableWorkers) {
                if (!this.lostWorkers.containsKey(workerInfo)) continue;
                this.lostWorkers.remove(workerInfo);
                this.shutdownWorkers.remove(workerInfo);
                this.workerEventInfos.remove(workerInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWorkerHeartbeatMeta(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, Map<String, DiskInfo> disks, Map<UserIdentifier, ResourceConsumption> userResourceConsumption, Map<String, Long> estimatedAppDiskUsage, long time, WorkerStatus workerStatus, boolean highWorkload) {
        WorkerInfo worker = new WorkerInfo(host, rpcPort, pushPort, fetchPort, replicatePort, -1, disks, userResourceConsumption);
        AtomicLong availableSlots = new AtomicLong();
        LOG.debug("update worker {}:{} heartbeat {}", new Object[]{host, rpcPort, disks});
        Set<WorkerInfo> set = this.workers;
        synchronized (set) {
            Optional<WorkerInfo> workerInfo = this.workers.stream().filter(w -> w.equals((Object)worker)).findFirst();
            workerInfo.ifPresent(info -> {
                info.updateThenGetDiskInfos(disks, Option.apply((Object)this.estimatedPartitionSize));
                info.updateThenGetUserResourceConsumption(userResourceConsumption);
                availableSlots.set(info.totalAvailableSlots());
                info.lastHeartbeat_$eq(time);
                info.setWorkerStatus(workerStatus);
            });
        }
        WorkerEventInfo workerEventInfo = this.workerEventInfos.get(worker);
        if (workerEventInfo != null && WorkerStatusUtils.meetFinalState((WorkerEventInfo)workerEventInfo, (WorkerStatus)workerStatus)) {
            this.workerEventInfos.remove(worker);
            if (workerStatus.getState() == PbWorkerStatus.State.Normal) {
                this.shutdownWorkers.remove(worker);
            }
        }
        this.appDiskUsageMetric.update(estimatedAppDiskUsage);
        long healthyDiskNum = disks.values().stream().filter(s -> s.status().equals((Object)DiskStatus.HEALTHY)).count();
        if (!this.excludedWorkers.contains(worker) && ((disks.isEmpty() || healthyDiskNum <= 0L) && !this.conf.hasHDFSStorage() || highWorkload)) {
            LOG.debug("Worker: {} num total slots is 0, add to excluded list", (Object)worker);
            this.excludedWorkers.add(worker);
        } else if ((availableSlots.get() > 0L || this.conf.hasHDFSStorage()) && !highWorkload) {
            this.excludedWorkers.remove(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRegisterWorkerMeta(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, int internalPort, String networkLocation, Map<String, DiskInfo> disks, Map<UserIdentifier, ResourceConsumption> userResourceConsumption) {
        WorkerInfo workerInfo = new WorkerInfo(host, rpcPort, pushPort, fetchPort, replicatePort, internalPort, disks, userResourceConsumption);
        workerInfo.lastHeartbeat_$eq(System.currentTimeMillis());
        if (networkLocation != null && !networkLocation.isEmpty() && !"/default-rack".equals(networkLocation)) {
            workerInfo.networkLocation_$eq(networkLocation);
        } else {
            workerInfo.networkLocation_$eq(this.rackResolver.resolve(host).getNetworkLocation());
        }
        workerInfo.updateDiskMaxSlots(this.estimatedPartitionSize);
        Set<WorkerInfo> set = this.workers;
        synchronized (set) {
            if (!this.workers.contains(workerInfo)) {
                this.workers.add(workerInfo);
            }
            this.shutdownWorkers.remove(workerInfo);
            this.lostWorkers.remove(workerInfo);
            this.excludedWorkers.remove(workerInfo);
            this.workerEventInfos.remove(workerInfo);
        }
    }

    public void writeMetaInfoToFile(File file) throws IOException, RuntimeException {
        byte[] snapshotBytes = PbSerDeUtils.toPbSnapshotMetaInfo((Long)this.estimatedPartitionSize, this.registeredShuffle, this.hostnameSet, this.excludedWorkers, this.manuallyExcludedWorkers, this.workerLostEvents, this.appHeartbeatTime, this.workers, (Long)this.partitionTotalWritten.sum(), (Long)this.partitionTotalFileCount.sum(), (AppDiskUsageSnapShot[])this.appDiskUsageMetric.snapShots(), (AppDiskUsageSnapShot)((AppDiskUsageSnapShot)this.appDiskUsageMetric.currentSnapShot().get()), this.lostWorkers, this.shutdownWorkers, this.workerEventInfos, this.applicationMetas).toByteArray();
        Files.write(file.toPath(), snapshotBytes, new OpenOption[0]);
    }

    public void restoreMetaFromFile(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            PbSnapshotMetaInfo snapshotMetaInfo = PbSnapshotMetaInfo.parseFrom((InputStream)in);
            this.cleanUpState();
            this.estimatedPartitionSize = snapshotMetaInfo.getEstimatedPartitionSize();
            this.registeredShuffle.addAll((Collection<String>)snapshotMetaInfo.getRegisteredShuffleList());
            this.hostnameSet.addAll((Collection<String>)snapshotMetaInfo.getHostnameSetList());
            this.excludedWorkers.addAll(snapshotMetaInfo.getExcludedWorkersList().stream().map(PbSerDeUtils::fromPbWorkerInfo).collect(Collectors.toSet()));
            this.manuallyExcludedWorkers.addAll(snapshotMetaInfo.getManuallyExcludedWorkersList().stream().map(PbSerDeUtils::fromPbWorkerInfo).collect(Collectors.toSet()));
            this.workerLostEvents.addAll(snapshotMetaInfo.getWorkerLostEventsList().stream().map(PbSerDeUtils::fromPbWorkerInfo).collect(Collectors.toSet()));
            this.appHeartbeatTime.putAll(snapshotMetaInfo.getAppHeartbeatTimeMap());
            this.registeredShuffle.forEach(shuffleKey -> {
                String appId = shuffleKey.split("-")[0];
                if (!this.appHeartbeatTime.containsKey(appId)) {
                    this.appHeartbeatTime.put(appId, System.currentTimeMillis());
                }
            });
            Set workerInfoSet = snapshotMetaInfo.getWorkersList().stream().map(PbSerDeUtils::fromPbWorkerInfo).collect(Collectors.toSet());
            List workerHostList = workerInfoSet.stream().filter(w -> "/default-rack".equals(w.networkLocation())).map(WorkerInfo::host).collect(Collectors.toList());
            scala.collection.immutable.Map resolveMap = this.rackResolver.resolveToMap(workerHostList);
            this.workers.addAll(workerInfoSet.stream().peek(workerInfo -> {
                if ("/default-rack".equals(workerInfo.networkLocation())) {
                    workerInfo.networkLocation_$eq(((Node)resolveMap.get((Object)workerInfo.host()).get()).getNetworkLocation());
                }
            }).collect(Collectors.toSet()));
            snapshotMetaInfo.getLostWorkersMap().forEach((key, value) -> this.lostWorkers.put(WorkerInfo.fromUniqueId((String)key), (Long)value));
            snapshotMetaInfo.getWorkerEventInfosMap().entrySet().forEach(entry -> this.workerEventInfos.put(WorkerInfo.fromUniqueId((String)((String)entry.getKey())), PbSerDeUtils.fromPbWorkerEventInfo((PbWorkerEventInfo)((PbWorkerEventInfo)entry.getValue()))));
            this.shutdownWorkers.addAll(snapshotMetaInfo.getShutdownWorkersList().stream().map(PbSerDeUtils::fromPbWorkerInfo).collect(Collectors.toSet()));
            this.partitionTotalWritten.add(snapshotMetaInfo.getPartitionTotalWritten());
            this.partitionTotalFileCount.add(snapshotMetaInfo.getPartitionTotalFileCount());
            this.appDiskUsageMetric.restoreFromSnapshot((AppDiskUsageSnapShot[])snapshotMetaInfo.getAppDiskUsageMetricSnapshotsList().stream().map(PbSerDeUtils::fromPbAppDiskUsageSnapshot).toArray(AppDiskUsageSnapShot[]::new));
            this.appDiskUsageMetric.currentSnapShot_$eq(new AtomicReference<AppDiskUsageSnapShot>(PbSerDeUtils.fromPbAppDiskUsageSnapshot((PbAppDiskUsageSnapshot)snapshotMetaInfo.getCurrentAppDiskUsageMetricsSnapshot())));
            snapshotMetaInfo.getApplicationMetasMap().forEach((key, value) -> this.applicationMetas.put((String)key, PbSerDeUtils.fromPbApplicationMeta((PbApplicationMeta)value)));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        LOG.info("Successfully restore meta info from snapshot {}", (Object)file.getAbsolutePath());
        LOG.info("Worker size: {}, Registered shuffle size: {}. Worker excluded list size: {}. Manually Excluded list size: {}", new Object[]{this.workers.size(), this.registeredShuffle.size(), this.excludedWorkers.size(), this.manuallyExcludedWorkers.size()});
        this.workers.forEach(workerInfo -> LOG.info(workerInfo.toString()));
        this.registeredShuffle.forEach(shuffle -> LOG.info("RegisteredShuffle {}", shuffle));
    }

    private void cleanUpState() {
        this.registeredShuffle.clear();
        this.hostnameSet.clear();
        this.workers.clear();
        this.lostWorkers.clear();
        this.appHeartbeatTime.clear();
        this.excludedWorkers.clear();
        this.shutdownWorkers.clear();
        this.manuallyExcludedWorkers.clear();
        this.workerLostEvents.clear();
        this.partitionTotalWritten.reset();
        this.partitionTotalFileCount.reset();
        this.workerEventInfos.clear();
        this.applicationMetas.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMetaByReportWorkerUnavailable(List<WorkerInfo> failedWorkers) {
        Set<WorkerInfo> set = this.workers;
        synchronized (set) {
            this.shutdownWorkers.addAll(failedWorkers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWorkerEventMeta(int workerEventTypeValue, List<WorkerInfo> workerInfoList) {
        long eventTime = System.currentTimeMillis();
        ResourceProtos.WorkerEventType eventType = ResourceProtos.WorkerEventType.forNumber(workerEventTypeValue);
        Set<WorkerInfo> set = this.workers;
        synchronized (set) {
            for (WorkerInfo workerInfo : workerInfoList) {
                WorkerEventInfo workerEventInfo = this.workerEventInfos.get(workerInfo);
                LOG.info("Received worker event: {} for worker: {}", (Object)eventType, (Object)workerInfo.toUniqueId());
                if (workerEventInfo != null && workerEventInfo.isSameEvent(eventType.getNumber())) continue;
                if (eventType == ResourceProtos.WorkerEventType.None) {
                    this.workerEventInfos.remove(workerInfo);
                    continue;
                }
                this.workerEventInfos.put(workerInfo, new WorkerEventInfo(eventType.getNumber(), eventTime));
            }
        }
    }

    public void updatePartitionSize() {
        long oldEstimatedPartitionSize = this.estimatedPartitionSize;
        long tmpTotalWritten = this.partitionTotalWritten.sumThenReset();
        long tmpFileCount = this.partitionTotalFileCount.sumThenReset();
        LOG.debug("update partition size total written {}, file count {}", (Object)Utils.bytesToString((long)tmpTotalWritten), (Object)tmpFileCount);
        this.estimatedPartitionSize = tmpFileCount != 0L ? Math.max(this.conf.minPartitionSizeToEstimate(), Math.min(tmpTotalWritten / tmpFileCount, this.conf.maxPartitionSizeToEstimate())) : this.initialEstimatedPartitionSize;
        LOG.warn("Celeborn cluster estimated partition size changed from {} to {}", (Object)Utils.bytesToString((long)oldEstimatedPartitionSize), (Object)Utils.bytesToString((long)this.estimatedPartitionSize));
        this.workers.stream().filter(worker -> !this.excludedWorkers.contains(worker) && !this.manuallyExcludedWorkers.contains(worker)).forEach(workerInfo -> workerInfo.updateDiskMaxSlots(this.estimatedPartitionSize));
    }

    public boolean isWorkerAvailable(WorkerInfo workerInfo) {
        return !this.excludedWorkers.contains(workerInfo) && !this.shutdownWorkers.contains(workerInfo) && !this.manuallyExcludedWorkers.contains(workerInfo) && !this.workerEventInfos.containsKey(workerInfo) && workerInfo.getWorkerStatus().getState() == PbWorkerStatus.State.Normal;
    }

    public void updateApplicationMeta(ApplicationMeta applicationMeta) {
        this.applicationMetas.putIfAbsent(applicationMeta.appId(), applicationMeta);
    }
}

