/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.meta;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.meta.FileMeta;
import org.apache.celeborn.common.meta.MapFileMeta;
import org.apache.celeborn.common.meta.ReduceFileMeta;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.util.Utils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskFileInfo
extends FileInfo {
    private static final Logger logger = LoggerFactory.getLogger(DiskFileInfo.class);
    private final String filePath;
    private final StorageInfo.Type storageType;

    public DiskFileInfo(UserIdentifier userIdentifier, boolean partitionSplitEnabled, FileMeta fileMeta, String filePath, StorageInfo.Type storageType) {
        super(userIdentifier, partitionSplitEnabled, fileMeta);
        this.filePath = filePath;
        this.storageType = storageType;
    }

    public DiskFileInfo(UserIdentifier userIdentifier, boolean partitionSplitEnabled, FileMeta fileMeta, String filePath, long bytesFlushed) {
        super(userIdentifier, partitionSplitEnabled, fileMeta);
        this.filePath = filePath;
        this.storageType = StorageInfo.Type.HDD;
        this.bytesFlushed = bytesFlushed;
    }

    @VisibleForTesting
    public DiskFileInfo(File file, UserIdentifier userIdentifier, CelebornConf conf) {
        this(userIdentifier, true, (FileMeta)new ReduceFileMeta(new ArrayList<Long>(Arrays.asList(0L)), conf.shuffleChunkSize()), file.getAbsolutePath(), StorageInfo.Type.HDD);
    }

    public DiskFileInfo(UserIdentifier userIdentifier, FileMeta fileMeta, String filePath) {
        super(userIdentifier, true, fileMeta);
        this.filePath = filePath;
        this.storageType = StorageInfo.Type.HDD;
    }

    public File getFile() {
        return new File(this.filePath);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getSortedPath() {
        return Utils.getSortedFilePath(this.filePath);
    }

    public String getIndexPath() {
        return Utils.getIndexFilePath(this.filePath);
    }

    public Path getHdfsPath() {
        return new Path(this.filePath);
    }

    public Path getHdfsIndexPath() {
        return new Path(Utils.getIndexFilePath(this.filePath));
    }

    public Path getHdfsSortedPath() {
        return new Path(Utils.getSortedFilePath(this.filePath));
    }

    public Path getHdfsWriterSuccessPath() {
        return new Path(Utils.getWriteSuccessFilePath(this.filePath));
    }

    public Path getHdfsPeerWriterSuccessPath() {
        return new Path(Utils.getWriteSuccessFilePath(Utils.getPeerPath(this.filePath)));
    }

    public void deleteAllFiles(FileSystem hdfsFs) {
        if (this.isHdfs()) {
            try {
                hdfsFs.delete(this.getHdfsPath(), false);
                hdfsFs.delete(this.getHdfsWriterSuccessPath(), false);
                hdfsFs.delete(this.getHdfsIndexPath(), false);
                hdfsFs.delete(this.getHdfsSortedPath(), false);
            }
            catch (Exception e) {
                logger.debug("delete HDFS file {},{},{},{} failed {}", new Object[]{this.getHdfsPath(), this.getHdfsWriterSuccessPath(), this.getHdfsIndexPath(), this.getHdfsSortedPath(), e});
            }
        } else {
            this.getFile().delete();
            new File(this.getIndexPath()).delete();
            new File(this.getSortedPath()).delete();
        }
    }

    public String getMountPoint() {
        return ((MapFileMeta)this.fileMeta).getMountPoint();
    }

    public void setMountPoint(String mountPoint) {
        ((MapFileMeta)this.fileMeta).setMountPoint(mountPoint);
    }

    public boolean isHdfs() {
        return Utils.isHdfsPath(this.filePath);
    }
}

