/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.network;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.celeborn.common.network.TransportContext;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientBootstrap;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.plugin.flink.network.TransportFrameDecoderWithBufferSupplier;
import org.apache.celeborn.plugin.flink.utils.Utils;
import org.apache.celeborn.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkTransportClientFactory
extends TransportClientFactory {
    public static final Logger logger = LoggerFactory.getLogger(FlinkTransportClientFactory.class);
    private ConcurrentHashMap<Long, Supplier<ByteBuf>> bufferSuppliers = JavaUtils.newConcurrentHashMap();
    private final int fetchMaxRetries;

    public FlinkTransportClientFactory(TransportContext context, int fetchMaxRetries, List<TransportClientBootstrap> bootstraps) {
        super(context, bootstraps);
        this.fetchMaxRetries = fetchMaxRetries;
        this.pooledAllocator = new UnpooledByteBufAllocator(true);
    }

    public TransportClient createClientWithRetry(String remoteHost, int remotePort) throws IOException, InterruptedException {
        int retryCount = this.fetchMaxRetries;
        while (retryCount > 0) {
            try {
                return this.createClient(remoteHost, remotePort);
            }
            catch (Exception e) {
                logger.warn("Retrying ({}/{}) times create client to {}:{}", new Object[]{--retryCount, this.fetchMaxRetries, remoteHost, remotePort, e});
                if (retryCount != 0) continue;
                if (e instanceof InterruptedException || e instanceof IOException) {
                    throw e;
                }
                Utils.rethrowAsRuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public TransportClient createClient(String remoteHost, int remotePort) throws IOException, InterruptedException {
        return this.createClient(remoteHost, remotePort, -1, new TransportFrameDecoderWithBufferSupplier(this.bufferSuppliers));
    }

    public void registerSupplier(long streamId, Supplier<ByteBuf> supplier) {
        this.bufferSuppliers.put(streamId, supplier);
    }

    public void unregisterSupplier(long streamId) {
        this.bufferSuppliers.remove(streamId);
    }
}

