/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.xdr.type;

import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.org.apache.kerby.xdr.XdrDataType;
import org.apache.hadoop.shaded.org.apache.kerby.xdr.type.XdrSimple;

public class XdrInteger
extends XdrSimple<Integer> {
    public XdrInteger() {
        this((Integer)null);
    }

    public XdrInteger(Integer value) {
        super(XdrDataType.INTEGER, value);
    }

    @Override
    protected int encodingBodyLength() {
        return 4;
    }

    @Override
    protected void toBytes() {
        int value = (Integer)this.getValue();
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(value);
        buffer.flip();
        this.setBytes(buffer.array());
    }

    @Override
    protected void toValue() {
        if (this.getBytes().length != 4) {
            byte[] intBytes = ByteBuffer.allocate(4).put(this.getBytes(), 0, 4).array();
            this.setBytes(intBytes);
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.getBytes());
        this.setValue(buffer.getInt());
    }
}

