/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.metrics.source;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.metrics.CelebornHistogram;
import org.apache.celeborn.common.metrics.CelebornTimer;
import org.apache.celeborn.common.metrics.MetricLabels$;
import org.apache.celeborn.common.metrics.ResettableSlidingWindowReservoir;
import org.apache.celeborn.common.metrics.source.AbstractSource$;
import org.apache.celeborn.common.metrics.source.GaugeSupplier;
import org.apache.celeborn.common.metrics.source.NamedCounter;
import org.apache.celeborn.common.metrics.source.NamedGauge;
import org.apache.celeborn.common.metrics.source.NamedHistogram;
import org.apache.celeborn.common.metrics.source.NamedTimer;
import org.apache.celeborn.common.metrics.source.Source;
import org.apache.celeborn.common.metrics.source.TimerSupplier;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\rUf!B&M\u0003\u0003I\u0006\u0002\u00036\u0001\u0005\u0003\u0005\u000b\u0011B6\t\u0011=\u0004!\u0011!Q\u0001\nADQa\u001f\u0001\u0005\u0002qD\u0011\"!\u0001\u0001\u0005\u0004%\t%a\u0001\t\u0011\u0005]\u0001\u0001)A\u0005\u0003\u000bA\u0011\"!\u0007\u0001\u0005\u0004%\t!a\u0007\t\u0011\u0005\r\u0002\u0001)A\u0005\u0003;A\u0011\"!\n\u0001\u0005\u0004%\t!a\n\t\u0011\u0005=\u0002\u0001)A\u0005\u0003SA\u0011\"!\r\u0001\u0005\u0004%\t!a\r\t\u0011\u0005m\u0002\u0001)A\u0005\u0003kA\u0011\"!\u0010\u0001\u0005\u0004%\t!a\u0007\t\u0011\u0005}\u0002\u0001)A\u0005\u0003;A\u0011\"!\u0011\u0001\u0005\u0004%\t!a\u0011\t\u0011\u0005e\u0003\u0001)A\u0005\u0003\u000bB\u0011\"a\u0017\u0001\u0005\u0004%\t!!\u0018\t\u0011\u0005\u0015\u0004\u0001)A\u0005\u0003?B\u0011\"a\u001a\u0001\u0005\u0004%\t!!\u001b\t\u0011\u0005E\u0004\u0001)A\u0005\u0003WB\u0011\"a\u001d\u0001\u0005\u0004%\t!!\u001e\t\u0011\u0005u\u0004\u0001)A\u0005\u0003oB\u0011\"a \u0001\u0005\u0004%\t!!!\t\u0011\u0005%\u0005\u0001)A\u0005\u0003\u0007C\u0011\"a#\u0001\u0005\u0004%\t!!$\t\u000f\u0005=\u0005\u0001)A\u0005a\"I\u0011\u0011\u0013\u0001C\u0002\u0013\u0005\u00111\u0013\u0005\t\u0003?\u0003\u0001\u0015!\u0003\u0002\u0016\"I\u0011\u0011\u0015\u0001C\u0002\u0013E\u00111\u0015\u0005\t\u0003w\u0003\u0001\u0015!\u0003\u0002&\"9\u00111\u001a\u0001\u0005\u0002\u00055\u0007bBAf\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0003\u0017\u0004A\u0011\u0001B\u0003\u0011%\u0011i\u0002AI\u0001\n\u0003\u0011y\u0002C\u0004\u0002L\u0002!\tA!\u000f\t\u0013\t\u001d\u0003A1A\u0005\u0012\t%\u0003\u0002\u0003B/\u0001\u0001\u0006IAa\u0013\t\u000f\t}\u0003\u0001\"\u0001\u0003b!9!q\f\u0001\u0005\u0002\t\u0015\u0004\"\u0003B6\u0001\t\u0007I\u0011\u0003B7\u0011!\u00119\b\u0001Q\u0001\n\t=\u0004b\u0002B=\u0001\u0011\u0005!1\u0010\u0005\b\u0005s\u0002A\u0011\u0001B@\u0011\u001d\u0011)\t\u0001C\u0001\u0005\u000fCqAa'\u0001\t\u0003\u0011i\nC\u0004\u0003,\u0002!\tA!,\t\u000f\t]\u0006\u0001\"\u0001\u0003:\"9!Q\u0018\u0001\u0005\u0002\t}\u0006b\u0002Bc\u0001\u0011\u0005!q\u0019\u0005\b\u0005\u0013\u0004A\u0011\u0001Bf\u0011\u001d\u0011\t\u000e\u0001C\u0001\u0005'DqA!7\u0001\t\u0003\u0011Y\u000eC\u0004\u0003b\u0002!\tEa9\t\u000f\t\u0005\b\u0001\"\u0001\u0003~\"91\u0011\u0003\u0001\u0005B\rM\u0001bBB\t\u0001\u0011\u00051\u0011\u0004\u0005\b\u0007C\u0001A\u0011IB\u0012\u0011\u001d\u0019\t\u0003\u0001C\u0001\u0007SAqa!\r\u0001\t\u0003\u0019\u0019\u0004C\u0004\u0004<\u0001!\tb!\u0010\t\u000f\r\u0015\u0003\u0001\"\u0001\u0004H!91Q\t\u0001\u0005B\r-\u0003bBB#\u0001\u0011\u000511\u000b\u0005\b\u00077\u0002A\u0011BB/\u0011\u001d\u0019\u0019\u0007\u0001C\t\u0007KBqaa\u001a\u0001\t\u0013\u0019I\u0007C\u0004\u0004p\u0001!\ta!\u001d\t\u000f\r]\u0004\u0001\"\u0001\u0004z!91\u0011\u0012\u0001\u0005\u0002\r-\u0005bBBI\u0001\u0011\u000511\u0013\u0005\b\u00073\u0003A\u0011IBN\u0011\u001d\u0019i\n\u0001C!\u0007KBqaa(\u0001\t#\u0019\t\u000bC\u0004\u0004&\u0002!\taa*\t\u000f\r5\u0006\u0001\"\u0005\u00040\nq\u0011IY:ue\u0006\u001cGoU8ve\u000e,'BA'O\u0003\u0019\u0019x.\u001e:dK*\u0011q\nU\u0001\b[\u0016$(/[2t\u0015\t\t&+\u0001\u0004d_6lwN\u001c\u0006\u0003'R\u000b\u0001bY3mK\n|'O\u001c\u0006\u0003+Z\u000ba!\u00199bG\",'\"A,\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001Q\u0006\r\u001a\t\u00037zk\u0011\u0001\u0018\u0006\u0002;\u0006)1oY1mC&\u0011q\f\u0018\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005\u0014W\"\u0001'\n\u0005\rd%AB*pkJ\u001cW\r\u0005\u0002fQ6\taM\u0003\u0002h!\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002jM\n9Aj\\4hS:<\u0017\u0001B2p]\u001a\u0004\"\u0001\\7\u000e\u0003AK!A\u001c)\u0003\u0019\r+G.\u001a2pe:\u001cuN\u001c4\u0002\tI|G.\u001a\t\u0003cbt!A\u001d<\u0011\u0005MdV\"\u0001;\u000b\u0005UD\u0016A\u0002\u001fs_>$h(\u0003\u0002x9\u00061\u0001K]3eK\u001aL!!\u001f>\u0003\rM#(/\u001b8h\u0015\t9H,\u0001\u0004=S:LGO\u0010\u000b\u0004{z|\bCA1\u0001\u0011\u0015Q7\u00011\u0001l\u0011\u0015y7\u00011\u0001q\u00039iW\r\u001e:jGJ+w-[:uef,\"!!\u0002\u0011\t\u0005\u001d\u00111C\u0007\u0003\u0003\u0013Q1aTA\u0006\u0015\u0011\ti!a\u0004\u0002\u0011\r|G-\u00195bY\u0016T!!!\u0005\u0002\u0007\r|W.\u0003\u0003\u0002\u0016\u0005%!AD'fiJL7MU3hSN$(/_\u0001\u0010[\u0016$(/[2SK\u001eL7\u000f\u001e:zA\u0005AR.\u001a;sS\u000e\u001c8\u000b\\5eS:<w+\u001b8e_^\u001c\u0016N_3\u0016\u0005\u0005u\u0001cA.\u0002 %\u0019\u0011\u0011\u0005/\u0003\u0007%sG/A\rnKR\u0014\u0018nY:TY&$\u0017N\\4XS:$wn^*ju\u0016\u0004\u0013!E7fiJL7m]*b[BdWMU1uKV\u0011\u0011\u0011\u0006\t\u00047\u0006-\u0012bAA\u00179\n1Ai\\;cY\u0016\f!#\\3ue&\u001c7oU1na2,'+\u0019;fA\u0005iR.\u001a;sS\u000e\u001c8i\u001c7mK\u000e$8I]5uS\u000e\fG.\u00128bE2,G-\u0006\u0002\u00026A\u00191,a\u000e\n\u0007\u0005eBLA\u0004C_>dW-\u00198\u0002=5,GO]5dg\u000e{G\u000e\\3di\u000e\u0013\u0018\u000e^5dC2,e.\u00192mK\u0012\u0004\u0013aD7fiJL7m]\"ba\u0006\u001c\u0017\u000e^=\u0002!5,GO]5dg\u000e\u000b\u0007/Y2jif\u0004\u0013\u0001D5o]\u0016\u0014X*\u001a;sS\u000e\u001cXCAA#!\u0015\t9%!\u0016q\u001b\t\tIE\u0003\u0003\u0002L\u00055\u0013AC2p]\u000e,(O]3oi*!\u0011qJA)\u0003\u0011)H/\u001b7\u000b\u0005\u0005M\u0013\u0001\u00026bm\u0006LA!a\u0016\u0002J\t)2i\u001c8dkJ\u0014XM\u001c;MS:\\W\rZ)vKV,\u0017!D5o]\u0016\u0014X*\u001a;sS\u000e\u001c\b%A\u0007uS6,'oU;qa2LWM]\u000b\u0003\u0003?\u00022!YA1\u0013\r\t\u0019\u0007\u0014\u0002\u000e)&lWM]*vaBd\u0017.\u001a:\u0002\u001dQLW.\u001a:TkB\u0004H.[3sA\u0005qQ.\u001a;sS\u000e\u001c8\t\\3b]\u0016\u0014XCAA6!\u0011\t9%!\u001c\n\t\u0005=\u0014\u0011\n\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017aD7fiJL7m]\"mK\u0006tWM\u001d\u0011\u0002\u0013I|G.\u001a'bE\u0016dWCAA<!\u0015Y\u0016\u0011\u00109q\u0013\r\tY\b\u0018\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u0015I|G.\u001a'bE\u0016d\u0007%\u0001\u0007ti\u0006$\u0018n\u0019'bE\u0016d7/\u0006\u0002\u0002\u0004B)\u0011/!\"qa&\u0019\u0011q\u0011>\u0003\u00075\u000b\u0007/A\u0007ti\u0006$\u0018n\u0019'bE\u0016d7\u000fI\u0001\u0013gR\fG/[2MC\n,Gn]*ue&tw-F\u0001q\u0003M\u0019H/\u0019;jG2\u000b'-\u001a7t'R\u0014\u0018N\\4!\u0003A\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8MC\n,G.\u0006\u0002\u0002\u0016B!\u0011qSAO\u001b\t\tIJ\u0003\u0003\u0002\u001c\u0006E\u0013\u0001\u00027b]\u001eL1!_AM\u0003E\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8MC\n,G\u000eI\u0001\f]\u0006lW\rZ$bk\u001e,7/\u0006\u0002\u0002&B9\u0011qIATa\u0006-\u0016\u0002BAU\u0003\u0013\u0012\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1qa\u0011\ti+a.\u0011\u000b\u0005\fy+a-\n\u0007\u0005EFJ\u0001\u0006OC6,GmR1vO\u0016\u0004B!!.\u000282\u0001AaCA];\u0005\u0005\t\u0011!B\u0001\u0003{\u00131a\u0018\u00132\u00031q\u0017-\\3e\u000f\u0006,x-Z:!#\u0011\ty,!2\u0011\u0007m\u000b\t-C\u0002\u0002Dr\u0013qAT8uQ&tw\rE\u0002\\\u0003\u000fL1!!3]\u0005\r\te._\u0001\tC\u0012$w)Y;hKV!\u0011qZAv)!\t\t.a6\u0002\\\u0006}\u0007cA.\u0002T&\u0019\u0011Q\u001b/\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u00033t\u0002\u0019\u00019\u0002\t9\fW.\u001a\u0005\b\u0003;t\u0002\u0019AAB\u0003\u0019a\u0017MY3mg\"9\u0011\u0011\u001d\u0010A\u0002\u0005\r\u0018!B4bk\u001e,\u0007CBA\u0004\u0003K\fI/\u0003\u0003\u0002h\u0006%!!B$bk\u001e,\u0007\u0003BA[\u0003W$q!!<\u001f\u0005\u0004\tiLA\u0001U+\u0011\t\tPa\u0001\u0015\u0011\u0005E\u00171_A{\u0003{Da!!7 \u0001\u0004\u0001\bbBAo?\u0001\u0007\u0011q\u001f\t\u0007\u0003s\fY\u0010\u001d9\u000e\u0005\u00055\u0013\u0002BAD\u0003\u001bBq!!9 \u0001\u0004\ty\u0010\u0005\u0004\u0002\b\u0005\u0015(\u0011\u0001\t\u0005\u0003k\u0013\u0019\u0001B\u0004\u0002n~\u0011\r!!0\u0016\t\t\u001d!q\u0003\u000b\u0007\u0005\u0013\u0011IBa\u0007\u0015\t\u0005E'1\u0002\u0005\b\u0005\u001b\u0001\u0003\u0019\u0001B\b\u0003\u00051\u0007#B.\u0003\u0012\tU\u0011b\u0001B\n9\nIa)\u001e8di&|g\u000e\r\t\u0005\u0003k\u00139\u0002B\u0004\u0002n\u0002\u0012\r!!0\t\r\u0005e\u0007\u00051\u0001q\u0011%\ti\u000e\tI\u0001\u0002\u0004\t\u0019)\u0001\nbI\u0012<\u0015-^4fI\u0011,g-Y;mi\u0012\u0012T\u0003\u0002B\u0011\u0005o)\"Aa\t+\t\u0005\r%QE\u0016\u0003\u0005O\u0001BA!\u000b\u000345\u0011!1\u0006\u0006\u0005\u0005[\u0011y#A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u0007/\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00036\t-\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00129\u0011Q^\u0011C\u0002\u0005uV\u0003\u0002B\u001e\u0005\u000b\"b!!5\u0003>\t}\u0002BBAmE\u0001\u0007\u0001\u000fC\u0004\u0002b\n\u0002\rA!\u0011\u0011\r\u0005\u001d\u0011Q\u001dB\"!\u0011\t)L!\u0012\u0005\u000f\u00055(E1\u0001\u0002>\u0006Ya.Y7fIRKW.\u001a:t+\t\u0011Y\u0005E\u0004\u0002H\u0005\u001d\u0006O!\u0014\u0011\u000fm\u000bIHa\u0014\u0003VA\u0019\u0011M!\u0015\n\u0007\tMCJ\u0001\u0006OC6,G\rV5nKJ\u0004r!a\u0012\u0002(B\u00149\u0006E\u0002\\\u00053J1Aa\u0017]\u0005\u0011auN\\4\u0002\u00199\fW.\u001a3US6,'o\u001d\u0011\u0002\u0011\u0005$G\rV5nKJ$B!!5\u0003d!1\u0011\u0011\\\u0013A\u0002A$b!!5\u0003h\t%\u0004BBAmM\u0001\u0007\u0001\u000fC\u0004\u0002^\u001a\u0002\r!a!\u0002\u001b9\fW.\u001a3D_VtG/\u001a:t+\t\u0011y\u0007E\u0004\u0002H\u0005\u001d\u0006O!\u001d\u0011\u0007\u0005\u0014\u0019(C\u0002\u0003v1\u0013ABT1nK\u0012\u001cu.\u001e8uKJ\faB\\1nK\u0012\u001cu.\u001e8uKJ\u001c\b%\u0001\u0006bI\u0012\u001cu.\u001e8uKJ$B!!5\u0003~!1\u0011\u0011\\\u0015A\u0002A$b!!5\u0003\u0002\n\r\u0005BBAmU\u0001\u0007\u0001\u000fC\u0004\u0002^*\u0002\r!a!\u0002\u0011\r|WO\u001c;feN$\"A!#\u0011\r\t-%Q\u0013B9\u001d\u0011\u0011iI!%\u000f\u0007M\u0014y)C\u0001^\u0013\r\u0011\u0019\nX\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u00119J!'\u0003\t1K7\u000f\u001e\u0006\u0004\u0005'c\u0016AB4bk\u001e,7\u000f\u0006\u0002\u0003 B1!1\u0012BK\u0005C\u0003DAa)\u0003(B)\u0011-a,\u0003&B!\u0011Q\u0017BT\t-\u0011I\u000bLA\u0001\u0002\u0003\u0015\t!!0\u0003\u0007}#3'\u0001\u0006iSN$xn\u001a:b[N$\"Aa,\u0011\r\t-%Q\u0013BY!\r\t'1W\u0005\u0004\u0005kc%A\u0004(b[\u0016$\u0007*[:u_\u001e\u0014\u0018-\\\u0001\u0007i&lWM]:\u0015\u0005\tm\u0006C\u0002BF\u0005+\u0013y%A\u0006hCV<W-\u0012=jgR\u001cHCBA\u001b\u0005\u0003\u0014\u0019\r\u0003\u0004\u0002Z>\u0002\r\u0001\u001d\u0005\b\u0003;|\u0003\u0019AAB\u0003)qW-\u001a3TC6\u0004H.\u001a\u000b\u0003\u0003k\tQB]3n_Z,7i\\;oi\u0016\u0014HCBAi\u0005\u001b\u0014y\r\u0003\u0004\u0002ZF\u0002\r\u0001\u001d\u0005\b\u0003;\f\u0004\u0019AAB\u0003-\u0011X-\\8wK\u001e\u000bWoZ3\u0015\r\u0005E'Q\u001bBl\u0011\u0019\tIN\ra\u0001a\"9\u0011Q\u001c\u001aA\u0002\u0005\r\u0015\u0001\u0004:f[>4X-T3ue&\u001cG#\u00029\u0003^\n}\u0007BBAmg\u0001\u0007\u0001\u000fC\u0004\u0002^N\u0002\r!a!\u0002\rM\fW\u000e\u001d7f+\u0011\u0011)Oa;\u0015\r\t\u001d(Q\u001fB})\u0011\u0011IO!<\u0011\t\u0005U&1\u001e\u0003\b\u0003[$$\u0019AA_\u0011!\u0011i\u0001\u000eCA\u0002\t=\b#B.\u0003r\n%\u0018b\u0001Bz9\nAAHY=oC6,g\b\u0003\u0004\u0003xR\u0002\r\u0001]\u0001\f[\u0016$(/[2t\u001d\u0006lW\r\u0003\u0004\u0003|R\u0002\r\u0001]\u0001\u0004W\u0016LX\u0003\u0002B\u0000\u0007\u000b!\u0002b!\u0001\u0004\f\r51q\u0002\u000b\u0005\u0007\u0007\u00199\u0001\u0005\u0003\u00026\u000e\u0015AaBAwk\t\u0007\u0011Q\u0018\u0005\t\u0005\u001b)D\u00111\u0001\u0004\nA)1L!=\u0004\u0004!1!q_\u001bA\u0002ADaAa?6\u0001\u0004\u0001\bbBAok\u0001\u0007\u00111Q\u0001\u000bgR\f'\u000f\u001e+j[\u0016\u0014HCBAi\u0007+\u00199\u0002\u0003\u0004\u0003xZ\u0002\r\u0001\u001d\u0005\u0007\u0005w4\u0004\u0019\u00019\u0015\u0011\u0005E71DB\u000f\u0007?AaAa>8\u0001\u0004\u0001\bB\u0002B~o\u0001\u0007\u0001\u000fC\u0004\u0002^^\u0002\r!a!\u0002\u0013M$x\u000e\u001d+j[\u0016\u0014HCBAi\u0007K\u00199\u0003\u0003\u0004\u0003xb\u0002\r\u0001\u001d\u0005\u0007\u0005wD\u0004\u0019\u00019\u0015\u0011\u0005E71FB\u0017\u0007_AaAa>:\u0001\u0004\u0001\bB\u0002B~s\u0001\u0007\u0001\u000fC\u0004\u0002^f\u0002\r!a!\u0002\u0019\u0011|7\u000b^1siRKW.\u001a:\u0015\u0011\u0005E7QGB\u001c\u0007sAaAa>;\u0001\u0004\u0001\bB\u0002B~u\u0001\u0007\u0001\u000fC\u0004\u0002^j\u0002\r!a!\u0002\u0017\u0011|7\u000b^8q)&lWM\u001d\u000b\t\u0003#\u001cyd!\u0011\u0004D!1!q_\u001eA\u0002ADaAa?<\u0001\u0004\u0001\bbBAow\u0001\u0007\u00111Q\u0001\u000bS:\u001c7i\\;oi\u0016\u0014H\u0003BAi\u0007\u0013BaAa>=\u0001\u0004\u0001HCBAi\u0007\u001b\u001ay\u0005\u0003\u0004\u0003xv\u0002\r\u0001\u001d\u0005\b\u0007#j\u0004\u0019\u0001B,\u0003\u0011Ign\u0019,\u0015\u0011\u0005E7QKB,\u00073BaAa>?\u0001\u0004\u0001\bbBB)}\u0001\u0007!q\u000b\u0005\b\u0003;t\u0004\u0019AAB\u00039\u0019G.Z1s\u001f2$g+\u00197vKN$B!!5\u0004`!91\u0011M A\u0002\tU\u0013aA7ba\u0006a1\u000f^1si\u000ecW-\u00198feR\u0011\u0011\u0011[\u0001\u0013kB$\u0017\r^3J]:,'/T3ue&\u001c7\u000f\u0006\u0003\u0002R\u000e-\u0004BBB7\u0003\u0002\u0007\u0001/A\u0002tiJ\fQB]3d_J$7i\\;oi\u0016\u0014H\u0003BAi\u0007gBqa!\u001eC\u0001\u0004\u0011\t(\u0001\u0002oG\u0006Y!/Z2pe\u0012<\u0015-^4f)\u0011\t\tna\u001f\t\u000f\ru4\t1\u0001\u0004\u0000\u0005\u0011an\u001a\u0019\u0005\u0007\u0003\u001b)\tE\u0003b\u0003_\u001b\u0019\t\u0005\u0003\u00026\u000e\u0015E\u0001DBD\u0007w\n\t\u0011!A\u0003\u0002\u0005u&aA0%i\u0005y!/Z2pe\u0012D\u0015n\u001d;pOJ\fW\u000e\u0006\u0003\u0002R\u000e5\u0005bBBH\t\u0002\u0007!\u0011W\u0001\u0003]\"\f1B]3d_J$G+[7feR!\u0011\u0011[BK\u0011\u001d\u00199*\u0012a\u0001\u0005\u001f\n!A\u001c;\u0002\u0015\u001d,G/T3ue&\u001c7\u000fF\u0001q\u0003\u001d!Wm\u001d;s_f\fAB\\8s[\u0006d\u0017N_3LKf$2\u0001]BR\u0011\u0019\u0011Y\u0010\u0013a\u0001a\u0006\u0011\"/\u001a9peRt\u0015M\\8t\u0003Nl\u0015\u000e\u001c7t)\u0011\tIc!+\t\u000f\r-\u0016\n1\u0001\u0002*\u0005)a/\u00197vK\u0006qR.\u001a;sS\u000et\u0015-\\3XSRD7)^:u_6L'0\u001a3MC\n,Gn\u001d\u000b\u0006a\u000eE61\u0017\u0005\u0007\u0005oT\u0005\u0019\u00019\t\u000f\u0005u'\n1\u0001\u0002\u0004\u0002")
public abstract class AbstractSource
implements Source,
Logging {
    private final MetricRegistry metricRegistry;
    private final int metricsSlidingWindowSize;
    private final double metricsSampleRate;
    private final boolean metricsCollectCriticalEnabled;
    private final int metricsCapacity;
    private final ConcurrentLinkedQueue<String> innerMetrics;
    private final TimerSupplier timerSupplier;
    private final ScheduledExecutorService metricsCleaner;
    private final Tuple2<String, String> roleLabel;
    private final scala.collection.immutable.Map<String, String> staticLabels;
    private final String staticLabelsString;
    private final String applicationLabel;
    private final ConcurrentHashMap<String, NamedGauge<?>> namedGauges;
    private final ConcurrentHashMap<String, Tuple2<NamedTimer, ConcurrentHashMap<String, Object>>> namedTimers;
    private final ConcurrentHashMap<String, NamedCounter> namedCounters;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        AbstractSource abstractSource = this;
        synchronized (abstractSource) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    @Override
    public MetricRegistry metricRegistry() {
        return this.metricRegistry;
    }

    public int metricsSlidingWindowSize() {
        return this.metricsSlidingWindowSize;
    }

    public double metricsSampleRate() {
        return this.metricsSampleRate;
    }

    public boolean metricsCollectCriticalEnabled() {
        return this.metricsCollectCriticalEnabled;
    }

    public int metricsCapacity() {
        return this.metricsCapacity;
    }

    public ConcurrentLinkedQueue<String> innerMetrics() {
        return this.innerMetrics;
    }

    public TimerSupplier timerSupplier() {
        return this.timerSupplier;
    }

    public ScheduledExecutorService metricsCleaner() {
        return this.metricsCleaner;
    }

    public Tuple2<String, String> roleLabel() {
        return this.roleLabel;
    }

    public scala.collection.immutable.Map<String, String> staticLabels() {
        return this.staticLabels;
    }

    public String staticLabelsString() {
        return this.staticLabelsString;
    }

    public String applicationLabel() {
        return this.applicationLabel;
    }

    public ConcurrentHashMap<String, NamedGauge<?>> namedGauges() {
        return this.namedGauges;
    }

    public <T> void addGauge(String name, scala.collection.immutable.Map<String, String> labels, Gauge<T> gauge) {
        if (gauge.getValue() instanceof Number) {
            this.namedGauges().putIfAbsent(this.metricNameWithCustomizedLabels(name, labels), new NamedGauge<T>(name, gauge, (scala.collection.immutable.Map<String, String>)labels.$plus$plus(this.staticLabels())));
            return;
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(50).append("Add gauge ").append(name).append(" failed, the value type ").append(gauge.getValue().getClass()).append(" is not a number").toString());
    }

    public <T> void addGauge(String name, Map<String, String> labels, Gauge<T> gauge) {
        this.addGauge(name, (scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(labels).asScala()).toMap(Predef$.MODULE$.$conforms()), gauge);
    }

    public <T> void addGauge(String name, scala.collection.immutable.Map<String, String> labels, Function0<T> f) {
        this.addGauge(name, labels, this.metricRegistry().gauge(this.metricNameWithCustomizedLabels(name, labels), new GaugeSupplier<T>(f)));
    }

    public <T> void addGauge(String name, Gauge<T> gauge) {
        this.addGauge(name, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), gauge);
    }

    public <T> scala.collection.immutable.Map<String, String> addGauge$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public ConcurrentHashMap<String, Tuple2<NamedTimer, ConcurrentHashMap<String, Object>>> namedTimers() {
        return this.namedTimers;
    }

    public void addTimer(String name) {
        this.addTimer(name, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public void addTimer(String name, scala.collection.immutable.Map<String, String> labels) {
        String metricNameWithLabel = this.metricNameWithCustomizedLabels(name, labels);
        this.namedTimers().computeIfAbsent(metricNameWithLabel, x$1 -> {
            NamedTimer namedTimer = new NamedTimer(name, this.metricRegistry().timer(metricNameWithLabel, (MetricRegistry.MetricSupplier)this.timerSupplier()), (scala.collection.immutable.Map<String, String>)labels.$plus$plus(this.staticLabels()));
            ConcurrentHashMap values = JavaUtils.newConcurrentHashMap();
            return new Tuple2((Object)namedTimer, values);
        });
    }

    public ConcurrentHashMap<String, NamedCounter> namedCounters() {
        return this.namedCounters;
    }

    public void addCounter(String name) {
        this.addCounter(name, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public void addCounter(String name, scala.collection.immutable.Map<String, String> labels) {
        String metricNameWithLabel = this.metricNameWithCustomizedLabels(name, labels);
        this.namedCounters().putIfAbsent(metricNameWithLabel, new NamedCounter(name, this.metricRegistry().counter(metricNameWithLabel), (scala.collection.immutable.Map<String, String>)labels.$plus$plus(this.staticLabels())));
    }

    public List<NamedCounter> counters() {
        return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.namedCounters().values()).asScala()).toList();
    }

    public List<NamedGauge<?>> gauges() {
        return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.namedGauges().values()).asScala()).toList();
    }

    public List<NamedHistogram> histograms() {
        return List$.MODULE$.empty();
    }

    public List<NamedTimer> timers() {
        return (List)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.namedTimers().values()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$2 -> (NamedTimer)x$2._1(), List$.MODULE$.canBuildFrom());
    }

    public boolean gaugeExists(String name, scala.collection.immutable.Map<String, String> labels) {
        return this.namedGauges().containsKey(this.metricNameWithCustomizedLabels(name, labels));
    }

    public boolean needSample() {
        if (this.metricsSampleRate() >= 1.0) {
            return true;
        }
        if (this.metricsSampleRate() <= 0.0) {
            return false;
        }
        return Random$.MODULE$.nextDouble() <= this.metricsSampleRate();
    }

    public void removeCounter(String name, scala.collection.immutable.Map<String, String> labels) {
        this.namedCounters().remove(this.removeMetric(name, labels));
    }

    public void removeGauge(String name, scala.collection.immutable.Map<String, String> labels) {
        this.namedGauges().remove(this.removeMetric(name, labels));
    }

    public String removeMetric(String name, scala.collection.immutable.Map<String, String> labels) {
        String metricNameWithLabel = this.metricNameWithCustomizedLabels(name, labels);
        this.metricRegistry().remove(metricNameWithLabel);
        return metricNameWithLabel;
    }

    @Override
    public <T> T sample(String metricsName, String key, Function0<T> f) {
        return this.sample(metricsName, key, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), f);
    }

    public <T> T sample(String metricsName, String key, scala.collection.immutable.Map<String, String> labels, Function0<T> f) {
        boolean sample = this.needSample();
        Object r = null;
        try {
            if (sample) {
                this.doStartTimer(metricsName, key, labels);
            }
            r = f.apply();
        }
        finally {
            if (sample) {
                this.doStopTimer(metricsName, key, labels);
            }
        }
        return (T)r;
    }

    @Override
    public void startTimer(String metricsName, String key) {
        this.startTimer(metricsName, key, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public void startTimer(String metricsName, String key, scala.collection.immutable.Map<String, String> labels) {
        if (this.needSample()) {
            this.doStartTimer(metricsName, key, labels);
            return;
        }
    }

    @Override
    public void stopTimer(String metricsName, String key) {
        this.stopTimer(metricsName, key, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public void stopTimer(String metricsName, String key, scala.collection.immutable.Map<String, String> labels) {
        this.doStopTimer(metricsName, key, labels);
    }

    public void doStartTimer(String metricsName, String key, scala.collection.immutable.Map<String, String> labels) {
        String metricNameWithLabel = this.metricNameWithCustomizedLabels(metricsName, labels);
        Tuple2<NamedTimer, ConcurrentHashMap<String, Object>> pair = this.namedTimers().get(metricNameWithLabel);
        if (pair != null) {
            ((ConcurrentHashMap)pair._2()).put(key, BoxesRunTime.boxToLong((long)System.nanoTime()));
            return;
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(18).append("Metric ").append(metricNameWithLabel).append(" not found!").toString());
    }

    public void doStopTimer(String metricsName, String key, scala.collection.immutable.Map<String, String> labels) {
        block5: {
            String metricNameWithLabel = this.metricNameWithCustomizedLabels(metricsName, labels);
            try {
                Option startTime;
                Tuple2<NamedTimer, ConcurrentHashMap<String, Object>> tuple2 = this.namedTimers().get(metricNameWithLabel);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                NamedTimer namedTimer = (NamedTimer)tuple2._1();
                ConcurrentHashMap map = (ConcurrentHashMap)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)namedTimer, (Object)map);
                NamedTimer namedTimer2 = (NamedTimer)tuple22._1();
                ConcurrentHashMap map2 = (ConcurrentHashMap)tuple22._2();
                Option option = startTime = Option$.MODULE$.apply(map2.remove(key));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    long t = BoxesRunTime.unboxToLong((Object)some.value());
                    namedTimer2.timer().update(System.nanoTime() - t, TimeUnit.NANOSECONDS);
                    if (namedTimer2.timer().getCount() % (long)this.metricsSlidingWindowSize() != 0L) break block5;
                    this.recordTimer(namedTimer2);
                    break block5;
                }
                if (None$.MODULE$.equals(option)) {
                    break block5;
                }
                throw new MatchError((Object)option);
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(50).append("Exception encountered during stop timer of metric ").append(metricNameWithLabel).toString(), e);
            }
        }
    }

    public void incCounter(String metricsName) {
        this.incCounter(metricsName, 1L);
    }

    @Override
    public void incCounter(String metricsName, long incV) {
        this.incCounter(metricsName, incV, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public void incCounter(String metricsName, long incV, scala.collection.immutable.Map<String, String> labels) {
        String metricNameWithLabel = this.metricNameWithCustomizedLabels(metricsName, labels);
        NamedCounter counter = this.namedCounters().get(metricNameWithLabel);
        if (counter != null) {
            counter.counter().inc(incV);
            return;
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(18).append("Metric ").append(metricNameWithLabel).append(" not found!").toString());
    }

    public void org$apache$celeborn$common$metrics$source$AbstractSource$$clearOldValues(ConcurrentHashMap<String, Object> map) {
        if (map.size() > 5000) {
            long threshTime = System.nanoTime() - 900000000000L;
            Iterator<Map.Entry<String, Object>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                if (BoxesRunTime.unboxToLong((Object)entry.getValue()) >= threshTime) continue;
                it.remove();
            }
            return;
        }
    }

    public void startCleaner() {
        Runnable cleanTask = new Runnable(this){
            private final /* synthetic */ AbstractSource $outer;

            public void run() {
                Utils$.MODULE$.tryLogNonFatalError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter($this.$outer.namedTimers().values()).asScala()).toArray(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1 & Serializable & scala.Serializable)x$4 -> (ConcurrentHashMap)x$4._2(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ConcurrentHashMap.class))))).foreach((Function1 & Serializable & scala.Serializable)map -> {
                    $anon$1.$anonfun$run$3(this, map);
                    return BoxedUnit.UNIT;
                }));
            }

            public static final /* synthetic */ void $anonfun$run$3($anon$1 $this, ConcurrentHashMap map) {
                $this.$outer.org$apache$celeborn$common$metrics$source$AbstractSource$$clearOldValues(map);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.celeborn.common.metrics.source.AbstractSource$$anon$1 ), $anonfun$run$2(scala.Tuple2 ), $anonfun$run$3$adapted(org.apache.celeborn.common.metrics.source.AbstractSource$$anon$1 java.util.concurrent.ConcurrentHashMap )}, serializedLambda);
            }
        };
        this.metricsCleaner().scheduleWithFixedDelay(cleanTask, 10L, 10L, TimeUnit.MINUTES);
    }

    private void updateInnerMetrics(String str) {
        ConcurrentLinkedQueue<String> concurrentLinkedQueue = this.innerMetrics();
        synchronized (concurrentLinkedQueue) {
            Object object = this.innerMetrics().size() >= this.metricsCapacity() ? this.innerMetrics().remove() : BoxedUnit.UNIT;
            this.innerMetrics().offer(str);
        }
    }

    public void recordCounter(NamedCounter nc) {
        long timestamp = System.currentTimeMillis();
        String label = nc.labelString();
        this.updateInnerMetrics(new java.lang.StringBuilder(8).append(this.normalizeKey(nc.name())).append("Count").append(label).append(" ").append(nc.counter().getCount()).append(" ").append(timestamp).append("\n").toString());
    }

    public void recordGauge(NamedGauge<?> ng) {
        long timestamp = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        String label = ng.labelString();
        sb.append(new java.lang.StringBuilder(8).append(this.normalizeKey(ng.name())).append("Value").append(label).append(" ").append(ng.gauge().getValue()).append(" ").append(timestamp).append("\n").toString());
        this.updateInnerMetrics(sb.toString());
    }

    public void recordHistogram(NamedHistogram nh) {
        long timestamp = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        Snapshot snapshot = nh.histogram().getSnapshot();
        String prefix = this.normalizeKey(nh.name());
        String label = nh.labelString();
        sb.append(new java.lang.StringBuilder(8).append(prefix).append("Count").append(label).append(" ").append(nh.histogram().getCount()).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(6).append(prefix).append("Max").append(label).append(" ").append(this.reportNanosAsMills(snapshot.getMax())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(7).append(prefix).append("Mean").append(label).append(" ").append(this.reportNanosAsMills(snapshot.getMean())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(6).append(prefix).append("Min").append(label).append(" ").append(this.reportNanosAsMills(snapshot.getMin())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("50thPercentile").append(label).append(" ").append(this.reportNanosAsMills(snapshot.getMedian())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("75thPercentile").append(label).append(" ").append(this.reportNanosAsMills(snapshot.get75thPercentile())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("95thPercentile").append(label).append(" ").append(this.reportNanosAsMills(snapshot.get95thPercentile())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("98thPercentile").append(label).append(" ").append(this.reportNanosAsMills(snapshot.get98thPercentile())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("99thPercentile").append(label).append(" ").append(this.reportNanosAsMills(snapshot.get99thPercentile())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(18).append(prefix).append("999thPercentile").append(label).append(" ").append(this.reportNanosAsMills(snapshot.get999thPercentile())).append(" ").append(timestamp).append("\n").toString());
        this.updateInnerMetrics(sb.toString());
    }

    public void recordTimer(NamedTimer nt) {
        long timestamp = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        Snapshot snapshot = nt.timer().getSnapshot();
        String prefix = this.normalizeKey(nt.name());
        String label = nt.labelString();
        sb.append(new java.lang.StringBuilder(8).append(prefix).append("Count").append(label).append(" ").append(nt.timer().getCount()).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(6).append(prefix).append("Max").append(label).append(" ").append(this.reportNanosAsMills(snapshot.getMax())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(7).append(prefix).append("Mean").append(label).append(" ").append(this.reportNanosAsMills(snapshot.getMean())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(6).append(prefix).append("Min").append(label).append(" ").append(this.reportNanosAsMills(snapshot.getMin())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("50thPercentile").append(label).append(" ").append(this.reportNanosAsMills(snapshot.getMedian())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("75thPercentile").append(label).append(" ").append(this.reportNanosAsMills(snapshot.get75thPercentile())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("95thPercentile").append(label).append(" ").append(this.reportNanosAsMills(snapshot.get95thPercentile())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("98thPercentile").append(label).append(" ").append(this.reportNanosAsMills(snapshot.get98thPercentile())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(17).append(prefix).append("99thPercentile").append(label).append(" ").append(this.reportNanosAsMills(snapshot.get99thPercentile())).append(" ").append(timestamp).append("\n").toString());
        sb.append(new java.lang.StringBuilder(18).append(prefix).append("999thPercentile").append(label).append(" ").append(this.reportNanosAsMills(snapshot.get999thPercentile())).append(" ").append(timestamp).append("\n").toString());
        this.updateInnerMetrics(sb.toString());
    }

    @Override
    public String getMetrics() {
        String string;
        ConcurrentLinkedQueue<String> concurrentLinkedQueue = this.innerMetrics();
        synchronized (concurrentLinkedQueue) {
            this.counters().foreach((Function1 & Serializable & scala.Serializable)c -> {
                this.recordCounter(c);
                return BoxedUnit.UNIT;
            });
            this.gauges().foreach((Function1 & Serializable & scala.Serializable)g -> {
                this.recordGauge(g);
                return BoxedUnit.UNIT;
            });
            this.histograms().foreach((Function1 & Serializable & scala.Serializable)h -> {
                AbstractSource.$anonfun$getMetrics$3(this, h);
                return BoxedUnit.UNIT;
            });
            this.timers().foreach((Function1 & Serializable & scala.Serializable)t -> {
                AbstractSource.$anonfun$getMetrics$4(this, t);
                return BoxedUnit.UNIT;
            });
            StringBuilder sb = new StringBuilder();
            while (!this.innerMetrics().isEmpty()) {
                sb.append(this.innerMetrics().poll());
            }
            this.innerMetrics().clear();
            string = sb.toString();
        }
        return string;
    }

    @Override
    public void destroy() {
        this.metricsCleaner().shutdown();
        this.namedCounters().clear();
        this.namedGauges().clear();
        this.namedTimers().clear();
        this.innerMetrics().clear();
        this.metricRegistry().removeMatching(new MetricFilter(null){

            public boolean matches(String s, Metric metric) {
                return true;
            }
        });
    }

    public String normalizeKey(String key) {
        return new java.lang.StringBuilder(9).append("metrics_").append(key.replaceAll("[^a-zA-Z0-9]", "_")).append("_").toString();
    }

    public double reportNanosAsMills(double value) {
        return package$.MODULE$.BigDecimal().apply(value / (double)1000000).setScale(2, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).toDouble();
    }

    public String metricNameWithCustomizedLabels(String metricsName, scala.collection.immutable.Map<String, String> labels) {
        if (labels.isEmpty()) {
            return new java.lang.StringBuilder(0).append(metricsName).append(this.staticLabelsString()).toString();
        }
        return new java.lang.StringBuilder(0).append(metricsName).append(MetricLabels$.MODULE$.labelString((scala.collection.immutable.Map<String, String>)labels.$plus$plus(this.staticLabels()))).toString();
    }

    public static final /* synthetic */ void $anonfun$getMetrics$3(AbstractSource $this, NamedHistogram h) {
        $this.recordHistogram(h);
        ((ResettableSlidingWindowReservoir)((CelebornHistogram)((Object)h)).reservoir()).reset();
    }

    public static final /* synthetic */ void $anonfun$getMetrics$4(AbstractSource $this, NamedTimer t) {
        $this.recordTimer(t);
        ((ResettableSlidingWindowReservoir)((CelebornTimer)t.timer()).reservoir()).reset();
    }

    public AbstractSource(CelebornConf conf, String role) {
        Logging.$init$(this);
        this.metricRegistry = new MetricRegistry();
        this.metricsSlidingWindowSize = conf.metricsSlidingWindowSize();
        this.metricsSampleRate = conf.metricsSampleRate();
        this.metricsCollectCriticalEnabled = conf.metricsCollectCriticalEnabled();
        this.metricsCapacity = conf.metricsCapacity();
        this.innerMetrics = new ConcurrentLinkedQueue();
        this.timerSupplier = new TimerSupplier(this.metricsSlidingWindowSize());
        this.metricsCleaner = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("worker-metrics-cleaner");
        this.roleLabel = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"role"), (Object)role);
        this.staticLabels = conf.metricsExtraLabels().$plus(this.roleLabel());
        this.staticLabelsString = MetricLabels$.MODULE$.labelString(this.staticLabels());
        this.applicationLabel = "applicationId";
        this.namedGauges = JavaUtils.newConcurrentHashMap();
        this.namedTimers = JavaUtils.newConcurrentHashMap();
        this.namedCounters = JavaUtils.newConcurrentHashMap();
    }
}

