/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;

public interface Preconditions {
    public static void assertTrue(boolean value) {
        if (!value) {
            throw new IllegalStateException();
        }
    }

    public static void assertTrue(boolean value, Object message) {
        if (!value) {
            if (message instanceof Supplier) {
                message = ((Supplier)message).get();
            }
            throw new IllegalStateException(String.valueOf(message));
        }
    }

    public static void assertTrue(boolean value, String format, Object ... args) {
        if (!value) {
            throw new IllegalStateException(String.format(format, args));
        }
    }

    public static void assertTrue(boolean value, Supplier<Object> message) {
        if (!value) {
            throw new IllegalStateException(String.valueOf(message.get()));
        }
    }

    public static void assertSame(long expected, long computed, String name) {
        Preconditions.assertTrue(expected == computed, () -> name + ": expected == " + expected + " but computed == " + computed);
    }

    public static void assertSame(Object expected, Object computed, String name) {
        Preconditions.assertTrue(expected == computed, () -> name + ": expected == " + expected + " but computed == " + computed);
    }

    public static void assertNull(Object object, Supplier<Object> message) {
        Preconditions.assertTrue(object == null, message);
    }

    public static void assertNull(Object object, String name) {
        Preconditions.assertNull(object, () -> name + " is expected to be null but " + name + " = " + object + " != null, class = " + object.getClass());
    }

    public static <T> T assertNotNull(T object, Supplier<Object> message) {
        Preconditions.assertTrue(object != null, message);
        return object;
    }

    public static <T> T assertNotNull(T object, String name) {
        Preconditions.assertTrue(object != null, () -> name + " == null");
        return object;
    }

    public static <T> T assertNotNull(T object, String format, Object ... args) {
        Preconditions.assertTrue(object != null, format, args);
        return object;
    }

    public static <T> T assertInstanceOf(Object object, Class<T> clazz) {
        Preconditions.assertTrue(clazz.isInstance(object), () -> "Required instance of " + clazz + " but object.getClass() is " + object.getClass());
        return clazz.cast(object);
    }

    public static <K, V> void assertEmpty(Map<K, V> map, Object name) {
        Preconditions.assertTrue(map.isEmpty(), () -> "The " + name + " map is non-empty: " + map);
    }

    public static <T> void assertUnique(Iterable<T> first) {
        Preconditions.assertUnique(first, Collections.emptyList());
    }

    public static <T> void assertUnique(Iterable<T> original, Iterable<T> toBeAdded) {
        HashSet<T> set = new HashSet<T>();
        for (Object t : original) {
            Preconditions.assertTrue(set.add(t), () -> "Found duplicated element " + t + " in " + original);
        }
        for (Object t : toBeAdded) {
            Preconditions.assertTrue(set.add(t), () -> "Found duplicated element " + t + " when adding " + toBeAdded + " to " + original);
        }
    }
}

