/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.service.config;

import java.io.IOException;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.server.common.service.config.ConfigService;
import org.apache.celeborn.server.common.service.config.DbConfigServiceImpl;
import org.apache.celeborn.server.common.service.config.FsConfigServiceImpl;

public class DynamicConfigServiceFactory {
    private static volatile ConfigService _INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigService getConfigService(CelebornConf celebornConf) throws IOException {
        if (celebornConf.dynamicConfigStoreBackend().isEmpty()) {
            return null;
        }
        if (_INSTANCE != null) return _INSTANCE;
        Class<DynamicConfigServiceFactory> clazz = DynamicConfigServiceFactory.class;
        synchronized (DynamicConfigServiceFactory.class) {
            if (_INSTANCE != null) return _INSTANCE;
            String configStoreBackend = (String)celebornConf.dynamicConfigStoreBackend().get();
            _INSTANCE = "FS".equals(configStoreBackend) ? new FsConfigServiceImpl(celebornConf) : new DbConfigServiceImpl(celebornConf);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _INSTANCE;
        }
    }
}

