/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntFunction;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.identity.UserIdentifier$;
import org.apache.celeborn.common.meta.AppDiskUsage;
import org.apache.celeborn.common.meta.AppDiskUsageSnapShot;
import org.apache.celeborn.common.meta.ApplicationMeta;
import org.apache.celeborn.common.meta.DiskFileInfo;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.FileMeta;
import org.apache.celeborn.common.meta.MapFileMeta;
import org.apache.celeborn.common.meta.ReduceFileMeta;
import org.apache.celeborn.common.meta.WorkerEventInfo;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.meta.WorkerInfo$;
import org.apache.celeborn.common.meta.WorkerStatus;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.protocol.PbAppDiskUsage;
import org.apache.celeborn.common.protocol.PbAppDiskUsageSnapshot;
import org.apache.celeborn.common.protocol.PbApplicationMeta;
import org.apache.celeborn.common.protocol.PbDiskInfo;
import org.apache.celeborn.common.protocol.PbFileInfo;
import org.apache.celeborn.common.protocol.PbFileInfoMap;
import org.apache.celeborn.common.protocol.PbPackedPartitionLocations;
import org.apache.celeborn.common.protocol.PbPackedPartitionLocationsPair;
import org.apache.celeborn.common.protocol.PbPackedWorkerResource;
import org.apache.celeborn.common.protocol.PbPartitionLocation;
import org.apache.celeborn.common.protocol.PbResourceConsumption;
import org.apache.celeborn.common.protocol.PbSnapshotMetaInfo;
import org.apache.celeborn.common.protocol.PbSortedShuffleFileSet;
import org.apache.celeborn.common.protocol.PbStoreVersion;
import org.apache.celeborn.common.protocol.PbUserIdentifier;
import org.apache.celeborn.common.protocol.PbWorkerEventInfo;
import org.apache.celeborn.common.protocol.PbWorkerInfo;
import org.apache.celeborn.common.protocol.PbWorkerResource;
import org.apache.celeborn.common.protocol.PbWorkerStatus;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.util.CollectionUtils;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.shaded.com.google.protobuf.InvalidProtocolBufferException;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PbSerDeUtils$ {
    public static PbSerDeUtils$ MODULE$;

    static {
        new PbSerDeUtils$();
    }

    public java.util.Set<String> fromPbSortedShuffleFileSet(byte[] data) throws InvalidProtocolBufferException {
        PbSortedShuffleFileSet pbSortedShuffleFileSet = PbSortedShuffleFileSet.parseFrom(data);
        ConcurrentHashMap.KeySetView<String, Boolean> files = ConcurrentHashMap.newKeySet();
        files.addAll(pbSortedShuffleFileSet.getFilesList());
        return files;
    }

    public byte[] toPbSortedShuffleFileSet(java.util.Set<String> files) {
        return PbSortedShuffleFileSet.newBuilder().addAllFiles(files).build().toByteArray();
    }

    public ArrayList<Integer> fromPbStoreVersion(byte[] data) throws InvalidProtocolBufferException {
        PbStoreVersion pbStoreVersion = PbStoreVersion.parseFrom(data);
        ArrayList<Integer> versions = new ArrayList<Integer>();
        versions.add(Predef$.MODULE$.int2Integer(pbStoreVersion.getMajor()));
        versions.add(Predef$.MODULE$.int2Integer(pbStoreVersion.getMinor()));
        return versions;
    }

    public byte[] toPbStoreVersion(int major, int minor) {
        return PbStoreVersion.newBuilder().setMajor(major).setMinor(minor).build().toByteArray();
    }

    public DiskInfo fromPbDiskInfo(PbDiskInfo pbDiskInfo) {
        DiskInfo diskInfo = new DiskInfo(pbDiskInfo.getMountPoint(), pbDiskInfo.getUsableSpace(), pbDiskInfo.getAvgFlushTime(), pbDiskInfo.getAvgFetchTime(), pbDiskInfo.getUsedSlots()).setStatus(Utils$.MODULE$.toDiskStatus(pbDiskInfo.getStatus())).setTotalSpace(pbDiskInfo.getTotalSpace());
        diskInfo.setStorageType(StorageInfo.typesMap.get(BoxesRunTime.boxToInteger((int)pbDiskInfo.getStorageType())));
        return diskInfo;
    }

    public PbDiskInfo toPbDiskInfo(DiskInfo diskInfo) {
        return PbDiskInfo.newBuilder().setMountPoint(diskInfo.mountPoint()).setUsableSpace(diskInfo.actualUsableSpace()).setAvgFlushTime(diskInfo.avgFlushTime()).setAvgFetchTime(diskInfo.avgFetchTime()).setUsedSlots(diskInfo.activeSlots()).setStatus(diskInfo.status().getValue()).setStorageType(diskInfo.storageType().getValue()).setTotalSpace(diskInfo.totalSpace()).build();
    }

    public DiskFileInfo fromPbFileInfo(PbFileInfo pbFileInfo) {
        return this.fromPbFileInfo(pbFileInfo, this.fromPbUserIdentifier(pbFileInfo.getUserIdentifier()));
    }

    public DiskFileInfo fromPbFileInfo(PbFileInfo pbFileInfo, UserIdentifier userIdentifier) {
        FileMeta fileMeta;
        PartitionType partitionType = Utils$.MODULE$.toPartitionType(pbFileInfo.getPartitionType());
        if (((Object)((Object)PartitionType.REDUCE)).equals((Object)partitionType)) {
            fileMeta = new ReduceFileMeta(pbFileInfo.getChunkOffsetsList());
        } else if (((Object)((Object)PartitionType.MAP)).equals((Object)partitionType)) {
            fileMeta = new MapFileMeta(pbFileInfo.getBufferSize(), pbFileInfo.getNumSubpartitions());
        } else {
            if (((Object)((Object)PartitionType.MAPGROUP)).equals((Object)partitionType)) {
                throw new NotImplementedError("Map group is not implemented");
            }
            throw new MatchError((Object)partitionType);
        }
        ReduceFileMeta meta = fileMeta;
        return new DiskFileInfo(userIdentifier, pbFileInfo.getPartitionSplitEnabled(), (FileMeta)meta, pbFileInfo.getFilePath(), pbFileInfo.getBytesFlushed());
    }

    public PbFileInfo toPbFileInfo(DiskFileInfo fileInfo) {
        PbFileInfo.Builder builder;
        PbFileInfo.Builder builder2 = PbFileInfo.newBuilder().setFilePath(fileInfo.getFilePath()).setUserIdentifier(this.toPbUserIdentifier(fileInfo.getUserIdentifier())).setBytesFlushed(fileInfo.getFileLength()).setPartitionSplitEnabled(fileInfo.isPartitionSplitEnabled());
        if (fileInfo.getFileMeta() instanceof MapFileMeta) {
            MapFileMeta mapFileMeta = (MapFileMeta)fileInfo.getFileMeta();
            builder2.setPartitionType(PartitionType.MAP.getValue());
            builder2.setBufferSize(mapFileMeta.getBufferSize());
            builder = builder2.setNumSubpartitions(mapFileMeta.getNumSubpartitions());
        } else {
            ReduceFileMeta reduceFileMeta = (ReduceFileMeta)fileInfo.getFileMeta();
            builder2.setPartitionType(PartitionType.REDUCE.getValue());
            builder = builder2.addAllChunkOffsets(reduceFileMeta.getChunkOffsets());
        }
        return builder2.build();
    }

    public ConcurrentHashMap<String, DiskFileInfo> fromPbFileInfoMap(byte[] data, ConcurrentHashMap<String, UserIdentifier> cache) throws InvalidProtocolBufferException {
        PbFileInfoMap pbFileInfoMap = PbFileInfoMap.parseFrom(data);
        ConcurrentHashMap<String, DiskFileInfo> fileInfoMap = JavaUtils.newConcurrentHashMap();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(pbFileInfoMap.getValuesMap().entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            String fileName = (String)entry.getKey();
            PbFileInfo pbFileInfo = (PbFileInfo)entry.getValue();
            PbUserIdentifier pbUserIdentifier = pbFileInfo.getUserIdentifier();
            String userIdentifierKey = new StringBuilder(1).append(pbUserIdentifier.getTenantId()).append("-").append(pbUserIdentifier.getName()).toString();
            if (!cache.containsKey(userIdentifierKey)) {
                DiskFileInfo fileInfo = MODULE$.fromPbFileInfo(pbFileInfo);
                cache.put(userIdentifierKey, fileInfo.getUserIdentifier());
                return fileInfoMap.put(fileName, fileInfo);
            }
            DiskFileInfo fileInfo = MODULE$.fromPbFileInfo(pbFileInfo, (UserIdentifier)cache.get(userIdentifierKey));
            return fileInfoMap.put(fileName, fileInfo);
        });
        return fileInfoMap;
    }

    public byte[] toPbFileInfoMap(ConcurrentHashMap<String, DiskFileInfo> fileInfoMap) {
        ConcurrentHashMap<String, PbFileInfo> pbFileInfoMap = JavaUtils.newConcurrentHashMap();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(fileInfoMap.entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> pbFileInfoMap.put((String)entry.getKey(), MODULE$.toPbFileInfo((DiskFileInfo)entry.getValue())));
        return PbFileInfoMap.newBuilder().putAllValues(pbFileInfoMap).build().toByteArray();
    }

    public UserIdentifier fromPbUserIdentifier(PbUserIdentifier pbUserIdentifier) {
        return new UserIdentifier(pbUserIdentifier.getTenantId(), pbUserIdentifier.getName());
    }

    public PbUserIdentifier toPbUserIdentifier(UserIdentifier userIdentifier) {
        return PbUserIdentifier.newBuilder().setTenantId(userIdentifier.tenantId()).setName(userIdentifier.name()).build();
    }

    public ResourceConsumption fromPbResourceConsumption(PbResourceConsumption pbResourceConsumption) {
        return new ResourceConsumption(pbResourceConsumption.getDiskBytesWritten(), pbResourceConsumption.getDiskFileCount(), pbResourceConsumption.getHdfsBytesWritten(), pbResourceConsumption.getHdfsFileCount(), this.fromPbSubResourceConsumptions(pbResourceConsumption.getSubResourceConsumptionsMap()));
    }

    public PbResourceConsumption toPbResourceConsumption(ResourceConsumption resourceConsumption) {
        return PbResourceConsumption.newBuilder().setDiskBytesWritten(resourceConsumption.diskBytesWritten()).setDiskFileCount(resourceConsumption.diskFileCount()).setHdfsBytesWritten(resourceConsumption.hdfsBytesWritten()).setHdfsFileCount(resourceConsumption.hdfsFileCount()).putAllSubResourceConsumptions(this.toPbSubResourceConsumptions(resourceConsumption.subResourceConsumptions())).build();
    }

    public Map<String, ResourceConsumption> fromPbSubResourceConsumptions(Map<String, PbResourceConsumption> pbSubResourceConsumptions) {
        if (CollectionUtils.isEmpty(pbSubResourceConsumptions)) {
            return null;
        }
        return (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbSubResourceConsumptions).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                PbResourceConsumption pbResourceConsumption = (PbResourceConsumption)tuple2._2();
                return new Tuple2((Object)key, (Object)MODULE$.fromPbResourceConsumption(pbResourceConsumption));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public Map<String, PbResourceConsumption> toPbSubResourceConsumptions(Map<String, ResourceConsumption> subResourceConsumptions) {
        if (CollectionUtils.isEmpty(subResourceConsumptions)) {
            return new HashMap<String, PbResourceConsumption>();
        }
        return (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(subResourceConsumptions).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                ResourceConsumption resourceConsumption = (ResourceConsumption)tuple2._2();
                return new Tuple2((Object)key, (Object)MODULE$.toPbResourceConsumption(resourceConsumption));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public Map<UserIdentifier, ResourceConsumption> fromPbUserResourceConsumption(Map<String, PbResourceConsumption> pbUserResourceConsumption) {
        return (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbUserResourceConsumption).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String userIdentifierString = (String)tuple2._1();
                PbResourceConsumption pbResourceConsumption = (PbResourceConsumption)tuple2._2();
                return new Tuple2((Object)UserIdentifier$.MODULE$.apply(userIdentifierString), (Object)MODULE$.fromPbResourceConsumption(pbResourceConsumption));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public Map<String, PbResourceConsumption> toPbUserResourceConsumption(Map<UserIdentifier, ResourceConsumption> userResourceConsumption) {
        return (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(userResourceConsumption).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                UserIdentifier userIdentifier = (UserIdentifier)tuple2._1();
                ResourceConsumption resourceConsumption = (ResourceConsumption)tuple2._2();
                return new Tuple2((Object)userIdentifier.toString(), (Object)MODULE$.toPbResourceConsumption(resourceConsumption));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public WorkerInfo fromPbWorkerInfo(PbWorkerInfo pbWorkerInfo) {
        ConcurrentHashMap<String, DiskInfo> disks = JavaUtils.newConcurrentHashMap();
        if (pbWorkerInfo.getDisksCount() > 0) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbWorkerInfo.getDisksList()).asScala()).foreach((Function1 & Serializable & scala.Serializable)pbDiskInfo -> disks.put(pbDiskInfo.getMountPoint(), MODULE$.fromPbDiskInfo((PbDiskInfo)pbDiskInfo)));
        }
        Map<UserIdentifier, ResourceConsumption> userResourceConsumption = this.fromPbUserResourceConsumption(pbWorkerInfo.getUserResourceConsumptionMap());
        return new WorkerInfo(pbWorkerInfo.getHost(), pbWorkerInfo.getRpcPort(), pbWorkerInfo.getPushPort(), pbWorkerInfo.getFetchPort(), pbWorkerInfo.getReplicatePort(), pbWorkerInfo.getInternalPort(), disks, userResourceConsumption);
    }

    public PbWorkerInfo toPbWorkerInfo(WorkerInfo workerInfo, boolean eliminateUserResourceConsumption, boolean eliminateDiskInfo) {
        Object object;
        PbWorkerInfo.Builder builder = PbWorkerInfo.newBuilder().setHost(workerInfo.host()).setRpcPort(workerInfo.rpcPort()).setFetchPort(workerInfo.fetchPort()).setPushPort(workerInfo.pushPort()).setReplicatePort(workerInfo.replicatePort()).setInternalPort(workerInfo.internalPort());
        Object object2 = !eliminateUserResourceConsumption ? builder.putAllUserResourceConsumption(this.toPbUserResourceConsumption(workerInfo.userResourceConsumption())) : BoxedUnit.UNIT;
        if (!eliminateDiskInfo) {
            Collection<DiskInfo> diskInfos = workerInfo.diskInfos().values();
            ArrayList pbDiskInfos = new ArrayList();
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(diskInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)diskInfo -> BoxesRunTime.boxToBoolean((boolean)pbDiskInfos.add(PbSerDeUtils$.MODULE$.toPbDiskInfo(diskInfo))));
            object = builder.addAllDisks(pbDiskInfos);
        } else {
            object = BoxedUnit.UNIT;
        }
        return builder.build();
    }

    public PartitionLocation fromPbPartitionLocation(PbPartitionLocation pbLoc) {
        PartitionLocation partitionLocation;
        block2: {
            PartitionLocation.Mode mode = PartitionLocation.Mode.PRIMARY;
            if (pbLoc.getMode().equals(PbPartitionLocation.Mode.Replica)) {
                mode = PartitionLocation.Mode.REPLICA;
            }
            partitionLocation = new PartitionLocation(pbLoc.getId(), pbLoc.getEpoch(), pbLoc.getHost(), pbLoc.getRpcPort(), pbLoc.getPushPort(), pbLoc.getFetchPort(), pbLoc.getReplicatePort(), mode, null, StorageInfo.fromPb(pbLoc.getStorageInfo()), Utils$.MODULE$.byteStringToRoaringBitmap(pbLoc.getMapIdBitmap()));
            if (!pbLoc.hasPeer()) break block2;
            PbPartitionLocation peerPb = pbLoc.getPeer();
            PartitionLocation.Mode peerMode = PartitionLocation.Mode.PRIMARY;
            if (peerPb.getMode() == PbPartitionLocation.Mode.Replica) {
                peerMode = PartitionLocation.Mode.REPLICA;
            }
            PartitionLocation peerLocation = new PartitionLocation(peerPb.getId(), peerPb.getEpoch(), peerPb.getHost(), peerPb.getRpcPort(), peerPb.getPushPort(), peerPb.getFetchPort(), peerPb.getReplicatePort(), peerMode, partitionLocation, StorageInfo.fromPb(peerPb.getStorageInfo()), Utils$.MODULE$.byteStringToRoaringBitmap(peerPb.getMapIdBitmap()));
            partitionLocation.setPeer(peerLocation);
        }
        return partitionLocation;
    }

    public PbPartitionLocation toPbPartitionLocation(PartitionLocation location) {
        Object object;
        PbPartitionLocation.Builder builder = PbPartitionLocation.newBuilder();
        PbPartitionLocation.Builder builder2 = location.getMode() == PartitionLocation.Mode.PRIMARY ? builder.setMode(PbPartitionLocation.Mode.Primary) : builder.setMode(PbPartitionLocation.Mode.Replica);
        builder.setHost(location.getHost()).setEpoch(location.getEpoch()).setId(location.getId()).setRpcPort(location.getRpcPort()).setPushPort(location.getPushPort()).setFetchPort(location.getFetchPort()).setReplicatePort(location.getReplicatePort()).setStorageInfo(StorageInfo.toPb(location.getStorageInfo())).setMapIdBitmap(Utils$.MODULE$.roaringBitmapToByteString(location.getMapIdBitMap()));
        if (location.hasPeer()) {
            PbPartitionLocation.Builder peerBuilder = PbPartitionLocation.newBuilder();
            PbPartitionLocation.Builder builder3 = location.getPeer().getMode() == PartitionLocation.Mode.PRIMARY ? peerBuilder.setMode(PbPartitionLocation.Mode.Primary) : peerBuilder.setMode(PbPartitionLocation.Mode.Replica);
            peerBuilder.setHost(location.getPeer().getHost()).setEpoch(location.getPeer().getEpoch()).setId(location.getPeer().getId()).setRpcPort(location.getPeer().getRpcPort()).setPushPort(location.getPeer().getPushPort()).setFetchPort(location.getPeer().getFetchPort()).setReplicatePort(location.getPeer().getReplicatePort()).setStorageInfo(StorageInfo.toPb(location.getPeer().getStorageInfo())).setMapIdBitmap(Utils$.MODULE$.roaringBitmapToByteString(location.getMapIdBitMap()));
            object = builder.setPeer(peerBuilder.build());
        } else {
            object = BoxedUnit.UNIT;
        }
        return builder.build();
    }

    public HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>> fromPbWorkerResource(Map<String, PbWorkerResource> pbWorkerResource) {
        HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>> slots = new HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>>();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbWorkerResource).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String uniqueId = (String)tuple2._1();
                PbWorkerResource pbWorkerResource = (PbWorkerResource)tuple2._2();
                String networkLocation = pbWorkerResource.getNetworkLocation();
                WorkerInfo workerInfo = WorkerInfo$.MODULE$.fromUniqueId(uniqueId);
                workerInfo.networkLocation_$eq(networkLocation);
                ArrayList primaryPartitionLocation = new ArrayList((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbWorkerResource.getPrimaryPartitionsList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbLoc -> MODULE$.fromPbPartitionLocation((PbPartitionLocation)pbLoc), Buffer$.MODULE$.canBuildFrom())).asJava());
                ArrayList replicaPartitionLocation = new ArrayList((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbWorkerResource.getReplicaPartitionsList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbLoc -> MODULE$.fromPbPartitionLocation((PbPartitionLocation)pbLoc), Buffer$.MODULE$.canBuildFrom())).asJava());
                return slots.put(workerInfo, new Tuple2(primaryPartitionLocation, replicaPartitionLocation));
            }
            throw new MatchError((Object)tuple2);
        });
        return slots;
    }

    public Map<String, PbWorkerResource> toPbWorkerResource(HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>> workerResource) {
        return (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(workerResource).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                WorkerInfo workerInfo = (WorkerInfo)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    java.util.List primaryLocations = (java.util.List)tuple22._1();
                    java.util.List replicaLocations = (java.util.List)tuple22._2();
                    java.util.List primaryPartitions = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(primaryLocations).asScala()).map((Function1 & Serializable & scala.Serializable)location -> MODULE$.toPbPartitionLocation((PartitionLocation)location), Buffer$.MODULE$.canBuildFrom())).asJava();
                    java.util.List replicaPartitions = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicaLocations).asScala()).map((Function1 & Serializable & scala.Serializable)location -> MODULE$.toPbPartitionLocation((PartitionLocation)location), Buffer$.MODULE$.canBuildFrom())).asJava();
                    PbWorkerResource pbWorkerResource = PbWorkerResource.newBuilder().addAllPrimaryPartitions(primaryPartitions).addAllReplicaPartitions(replicaPartitions).setNetworkLocation(workerInfo.networkLocation()).build();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)workerInfo.toUniqueId()), (Object)pbWorkerResource);
                }
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public AppDiskUsage fromPbAppDiskUsage(PbAppDiskUsage pbAppDiskUsage) {
        return new AppDiskUsage(pbAppDiskUsage.getAppId(), pbAppDiskUsage.getEstimatedUsage());
    }

    public PbAppDiskUsage toPbAppDiskUsage(AppDiskUsage appDiskUsage) {
        return PbAppDiskUsage.newBuilder().setAppId(appDiskUsage.appId()).setEstimatedUsage(appDiskUsage.estimatedUsage()).build();
    }

    public AppDiskUsageSnapShot fromPbAppDiskUsageSnapshot(PbAppDiskUsageSnapshot pbAppDiskUsageSnapShot) {
        AppDiskUsageSnapShot snapShot = new AppDiskUsageSnapShot(pbAppDiskUsageSnapShot.getTopItemCount());
        snapShot.startSnapShotTime_$eq(pbAppDiskUsageSnapShot.getStartSnapShotTime());
        snapShot.endSnapShotTime_$eq(pbAppDiskUsageSnapShot.getEndSnapshotTime());
        snapShot.restoreFromSnapshot((AppDiskUsage[])((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbAppDiskUsageSnapShot.getTopNItemsList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbAppDiskUsage -> MODULE$.fromPbAppDiskUsage((PbAppDiskUsage)pbAppDiskUsage), Buffer$.MODULE$.canBuildFrom())).asJava()).stream().toArray((IntFunction<A[]>)new IntFunction<AppDiskUsage[]>(){

            public AppDiskUsage[] apply(int value) {
                return new AppDiskUsage[value];
            }
        }));
        return snapShot;
    }

    public PbAppDiskUsageSnapshot toPbAppDiskUsageSnapshot(AppDiskUsageSnapShot snapshots) {
        return PbAppDiskUsageSnapshot.newBuilder().setTopItemCount(snapshots.topItemCount()).setStartSnapShotTime(snapshots.startSnapShotTime()).setEndSnapshotTime(snapshots.endSnapShotTime()).addAllTopNItems((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])snapshots.topNItems())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PbSerDeUtils$.$anonfun$toPbAppDiskUsageSnapshot$1(x$1))))).map((Function1 & Serializable & scala.Serializable)appDiskUsage -> MODULE$.toPbAppDiskUsage((AppDiskUsage)appDiskUsage), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PbAppDiskUsage.class))))).toList()).asJava()).build();
    }

    public PbSnapshotMetaInfo toPbSnapshotMetaInfo(Long estimatedPartitionSize, java.util.Set<String> registeredShuffle, java.util.Set<String> hostnameSet, java.util.Set<WorkerInfo> excludedWorkers, java.util.Set<WorkerInfo> manuallyExcludedWorkers, java.util.Set<WorkerInfo> workerLostEvent, Map<String, Long> appHeartbeatTime, java.util.Set<WorkerInfo> workers, Long partitionTotalWritten, Long partitionTotalFileCount, AppDiskUsageSnapShot[] appDiskUsageMetricSnapshots, AppDiskUsageSnapShot currentAppDiskUsageMetricsSnapshot, ConcurrentHashMap<WorkerInfo, Long> lostWorkers, java.util.Set<WorkerInfo> shutdownWorkers, ConcurrentHashMap<WorkerInfo, WorkerEventInfo> workerEventInfos, ConcurrentHashMap<String, ApplicationMeta> applicationMetas) {
        PbSnapshotMetaInfo.Builder builder = PbSnapshotMetaInfo.newBuilder().setEstimatedPartitionSize(Predef$.MODULE$.Long2long(estimatedPartitionSize)).addAllRegisteredShuffle(registeredShuffle).addAllHostnameSet(hostnameSet).addAllExcludedWorkers((Iterable)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(excludedWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.toPbWorkerInfo((WorkerInfo)x$2, true, false), Set$.MODULE$.canBuildFrom())).asJava()).addAllManuallyExcludedWorkers((Iterable)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(manuallyExcludedWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.toPbWorkerInfo((WorkerInfo)x$3, true, false), Set$.MODULE$.canBuildFrom())).asJava()).addAllWorkerLostEvents((Iterable)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(workerLostEvent).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.toPbWorkerInfo((WorkerInfo)x$4, true, false), Set$.MODULE$.canBuildFrom())).asJava()).putAllAppHeartbeatTime(appHeartbeatTime).addAllWorkers((Iterable)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(workers).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.toPbWorkerInfo((WorkerInfo)x$5, true, false), Set$.MODULE$.canBuildFrom())).asJava()).setPartitionTotalWritten(Predef$.MODULE$.Long2long(partitionTotalWritten)).setPartitionTotalFileCount(Predef$.MODULE$.Long2long(partitionTotalFileCount)).addAllAppDiskUsageMetricSnapshots((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])appDiskUsageMetricSnapshots)).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)PbSerDeUtils$.$anonfun$toPbSnapshotMetaInfo$5(x$6))))).map((Function1 & Serializable & scala.Serializable)snapshots -> MODULE$.toPbAppDiskUsageSnapshot((AppDiskUsageSnapShot)snapshots), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PbAppDiskUsageSnapshot.class))))).toList()).asJava()).putAllLostWorkers((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(lostWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                WorkerInfo worker = (WorkerInfo)tuple2._1();
                Long time = (Long)tuple2._2();
                if (worker != null) {
                    WorkerInfo workerInfo = worker;
                    if (time != null) {
                        Long l = time;
                        return new Tuple2((Object)workerInfo.toUniqueId(), (Object)l);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).asJava()).addAllShutdownWorkers((Iterable)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(shutdownWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> MODULE$.toPbWorkerInfo((WorkerInfo)x$7, true, false), Set$.MODULE$.canBuildFrom())).asJava()).putAllWorkerEventInfos((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(workerEventInfos).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                WorkerInfo worker = (WorkerInfo)tuple2._1();
                WorkerEventInfo workerEventInfo = (WorkerEventInfo)tuple2._2();
                return new Tuple2((Object)worker.toUniqueId(), (Object)MODULE$.toPbWorkerEventInfo(workerEventInfo));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).asJava());
        Object object = currentAppDiskUsageMetricsSnapshot != null ? builder.setCurrentAppDiskUsageMetricsSnapshot(this.toPbAppDiskUsageSnapshot(currentAppDiskUsageMetricsSnapshot)) : BoxedUnit.UNIT;
        Map pbApplicationMetas = (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(applicationMetas).asScala()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                String appId = (String)tuple2._1();
                ApplicationMeta applicationMeta = (ApplicationMeta)tuple2._2();
                return new Tuple2((Object)appId, (Object)MODULE$.toPbApplicationMeta(applicationMeta));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).asJava();
        Object object2 = CollectionUtils.isNotEmpty(pbApplicationMetas) ? builder.putAllApplicationMetas(pbApplicationMetas) : BoxedUnit.UNIT;
        return builder.build();
    }

    public PbApplicationMeta toPbApplicationMeta(ApplicationMeta meta) {
        return PbApplicationMeta.newBuilder().setAppId(meta.appId()).setSecret(meta.secret()).build();
    }

    public ApplicationMeta fromPbApplicationMeta(PbApplicationMeta pbApplicationMeta) {
        return new ApplicationMeta(pbApplicationMeta.getAppId(), pbApplicationMeta.getSecret());
    }

    public PbWorkerStatus toPbWorkerStatus(WorkerStatus workerStatus) {
        return PbWorkerStatus.newBuilder().setState(workerStatus.getState()).setStateStartTime(workerStatus.getStateStartTime()).build();
    }

    public WorkerStatus fromPbWorkerStatus(PbWorkerStatus pbWorkerStatus) {
        return new WorkerStatus(pbWorkerStatus.getState().getNumber(), pbWorkerStatus.getStateStartTime());
    }

    public PbWorkerEventInfo toPbWorkerEventInfo(WorkerEventInfo workerEventInfo) {
        return PbWorkerEventInfo.newBuilder().setEventStartTime(workerEventInfo.getEventStartTime()).setWorkerEventType(workerEventInfo.getEventType()).build();
    }

    public WorkerEventInfo fromPbWorkerEventInfo(PbWorkerEventInfo pbWorkerEventInfo) {
        return new WorkerEventInfo(pbWorkerEventInfo.getWorkerEventType().getNumber(), pbWorkerEventInfo.getEventStartTime());
    }

    private PbPackedPartitionLocations.Builder toPackedPartitionLocation(PbPackedPartitionLocations.Builder pbPackedLocationsBuilder, scala.collection.immutable.Map<String, Object> workerIdIndex, scala.collection.immutable.Map<String, Object> mountPointsIndex, PartitionLocation location) {
        pbPackedLocationsBuilder.addIds(location.getId());
        pbPackedLocationsBuilder.addEpoches(location.getEpoch());
        pbPackedLocationsBuilder.addWorkerIds(BoxesRunTime.unboxToInt((Object)workerIdIndex.apply((Object)location.getWorker().toUniqueId())));
        pbPackedLocationsBuilder.addMapIdBitMap(Utils$.MODULE$.roaringBitmapToByteString(location.getMapIdBitMap()));
        pbPackedLocationsBuilder.addTypes(location.getStorageInfo().getType().getValue());
        pbPackedLocationsBuilder.addMountPoints(BoxesRunTime.unboxToInt((Object)mountPointsIndex.apply((Object)location.getStorageInfo().getMountPoint())));
        pbPackedLocationsBuilder.addFinalResult(location.getStorageInfo().isFinalResult());
        PbPackedPartitionLocations.Builder builder = location.getStorageInfo().getFilePath() != null && new StringOps(Predef$.MODULE$.augmentString(location.getStorageInfo().getFilePath())).nonEmpty() ? pbPackedLocationsBuilder.addFilePaths(location.getStorageInfo().getFilePath().substring(location.getStorageInfo().getMountPoint().length())) : pbPackedLocationsBuilder.addFilePaths("");
        pbPackedLocationsBuilder.addAvailableStorageTypes(location.getStorageInfo().availableStorageTypes);
        return pbPackedLocationsBuilder.addModes(location.getMode().mode());
    }

    public PbPackedPartitionLocationsPair toPbPackedPartitionLocationsPair(List<PartitionLocation> inputLocations) {
        PbPackedPartitionLocationsPair.Builder packedLocationPairsBuilder = PbPackedPartitionLocationsPair.newBuilder();
        PbPackedPartitionLocations.Builder packedLocationsBuilder = PbPackedPartitionLocations.newBuilder();
        List implicateLocations = (List)((TraversableLike)inputLocations.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getPeer(), List$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)PbSerDeUtils$.$anonfun$toPbPackedPartitionLocationsPair$2(x$9)));
        List allLocations = (List)inputLocations.$plus$plus((GenTraversableOnce)implicateLocations, List$.MODULE$.canBuildFrom());
        ArrayList<String> workerIdList = new ArrayList<String>((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)allLocations.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getWorker().toUniqueId(), List$.MODULE$.canBuildFrom())).toSet()).asJava());
        scala.collection.immutable.Map workerIdIndex = ((TraversableOnce)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(workerIdList).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        ArrayList<String> mountPointsList = new ArrayList<String>((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)allLocations.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.getStorageInfo().getMountPoint(), List$.MODULE$.canBuildFrom())).toSet()).asJava());
        scala.collection.immutable.Map mountPointsIndex = ((TraversableOnce)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(mountPointsList).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        packedLocationsBuilder.addAllWorkerIdsSet(workerIdList);
        packedLocationsBuilder.addAllMountPointsSet(mountPointsList);
        scala.collection.immutable.Map locationIndexes = ((TraversableOnce)allLocations.zipWithIndex(List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        allLocations.foreach((Function1 & Serializable & scala.Serializable)location -> {
            MODULE$.toPackedPartitionLocation(packedLocationsBuilder, (scala.collection.immutable.Map<String, Object>)workerIdIndex, (scala.collection.immutable.Map<String, Object>)mountPointsIndex, (PartitionLocation)location);
            if (location.getPeer() != null) {
                return packedLocationPairsBuilder.addPeerIndexes(BoxesRunTime.unboxToInt((Object)locationIndexes.apply((Object)location.getPeer())));
            }
            return packedLocationPairsBuilder.addPeerIndexes(Integer.MAX_VALUE);
        });
        packedLocationPairsBuilder.setInputLocationSize(inputLocations.size());
        return packedLocationPairsBuilder.setLocations(packedLocationsBuilder.build()).build();
    }

    public Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>> fromPbPackedPartitionLocationsPair(PbPackedPartitionLocationsPair pbPartitionLocationsPair) {
        int index;
        ArrayList<PartitionLocation> primaryLocations = new ArrayList<PartitionLocation>();
        ArrayList<PartitionLocation> replicateLocations = new ArrayList<PartitionLocation>();
        PbPackedPartitionLocations pbPackedPartitionLocations = pbPartitionLocationsPair.getLocations();
        int inputLocationSize = pbPartitionLocationsPair.getInputLocationSize();
        java.util.List<Integer> idList = pbPackedPartitionLocations.getIdsList();
        int locationCount = idList.size();
        ArrayList<PartitionLocation> locations = new ArrayList<PartitionLocation>();
        for (index = 0; index < locationCount; ++index) {
            Object object;
            PartitionLocation loc = this.fromPackedPartitionLocations(pbPackedPartitionLocations, index);
            if (index < inputLocationSize) {
                PartitionLocation.Mode mode = loc.getMode();
                PartitionLocation.Mode mode2 = PartitionLocation.Mode.PRIMARY;
                object = BoxesRunTime.boxToBoolean((boolean)(!(mode != null ? !((Object)((Object)mode)).equals((Object)mode2) : mode2 != null) ? primaryLocations.add(loc) : replicateLocations.add(loc)));
            } else {
                object = BoxedUnit.UNIT;
            }
            locations.add(loc);
        }
        for (index = 0; index < locationCount; ++index) {
            int replicateIndex = pbPartitionLocationsPair.getPeerIndexes(index);
            if (replicateIndex == Integer.MAX_VALUE) continue;
            ((PartitionLocation)locations.get(index)).setPeer((PartitionLocation)locations.get(replicateIndex));
        }
        return new Tuple2(primaryLocations, replicateLocations);
    }

    private PartitionLocation fromPackedPartitionLocations(PbPackedPartitionLocations pbPackedPartitionLocations, int index) {
        String filePath;
        String[] workerIdParts = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.parseColonSeparatedHostPorts(pbPackedPartitionLocations.getWorkerIdsSet(pbPackedPartitionLocations.getWorkerIds(index)), 4))).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String string = filePath = pbPackedPartitionLocations.getFilePaths(index);
        String string2 = "";
        if (string == null ? string2 != null : !string.equals(string2)) {
            filePath = new StringBuilder(0).append(pbPackedPartitionLocations.getMountPointsSet(pbPackedPartitionLocations.getMountPoints(index))).append(pbPackedPartitionLocations.getFilePaths(index)).toString();
        }
        PartitionLocation.Mode mode = pbPackedPartitionLocations.getModes(index) == PartitionLocation.Mode.PRIMARY.mode() ? PartitionLocation.Mode.PRIMARY : PartitionLocation.Mode.REPLICA;
        return new PartitionLocation(pbPackedPartitionLocations.getIds(index), pbPackedPartitionLocations.getEpoches(index), workerIdParts[0], new StringOps(Predef$.MODULE$.augmentString(workerIdParts[1])).toInt(), new StringOps(Predef$.MODULE$.augmentString(workerIdParts[2])).toInt(), new StringOps(Predef$.MODULE$.augmentString(workerIdParts[3])).toInt(), new StringOps(Predef$.MODULE$.augmentString(workerIdParts[4])).toInt(), mode, null, new StorageInfo(StorageInfo.typesMap.get(BoxesRunTime.boxToInteger((int)pbPackedPartitionLocations.getTypes(index))), pbPackedPartitionLocations.getMountPointsSet(pbPackedPartitionLocations.getMountPoints(index)), pbPackedPartitionLocations.getFinalResult(index), filePath, pbPackedPartitionLocations.getAvailableStorageTypes(index)), Utils$.MODULE$.byteStringToRoaringBitmap(pbPackedPartitionLocations.getMapIdBitMap(index)));
    }

    public HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>> fromPbPackedWorkerResource(Map<String, PbPackedWorkerResource> pbWorkerResource) {
        HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>> slots = new HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>>();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbWorkerResource).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String uniqueId = (String)tuple2._1();
                PbPackedWorkerResource pbPackedWorkerResource = (PbPackedWorkerResource)tuple2._2();
                String networkLocation = pbPackedWorkerResource.getNetworkLocation();
                WorkerInfo workerInfo = WorkerInfo$.MODULE$.fromUniqueId(uniqueId);
                workerInfo.networkLocation_$eq(networkLocation);
                Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>> tuple22 = MODULE$.fromPbPackedPartitionLocationsPair(pbPackedWorkerResource.getLocationPairs());
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                java.util.List primaryLocations = (java.util.List)tuple22._1();
                java.util.List replicateLocations = (java.util.List)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)primaryLocations, (Object)replicateLocations);
                java.util.List primaryLocations2 = (java.util.List)tuple23._1();
                java.util.List replicateLocations2 = (java.util.List)tuple23._2();
                return slots.put(workerInfo, new Tuple2((Object)primaryLocations2, (Object)replicateLocations2));
            }
            throw new MatchError((Object)tuple2);
        });
        return slots;
    }

    public Map<String, PbPackedWorkerResource> toPbPackedWorkerResource(HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>> workerResource) {
        return (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(workerResource).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                WorkerInfo workerInfo = (WorkerInfo)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    java.util.List primaryLocations = (java.util.List)tuple22._1();
                    java.util.List replicaLocations = (java.util.List)tuple22._2();
                    PbPackedWorkerResource pbWorkerResource = PbPackedWorkerResource.newBuilder().setLocationPairs(MODULE$.toPbPackedPartitionLocationsPair((List<PartitionLocation>)((List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(primaryLocations).asScala()).toList().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(replicaLocations).asScala()).toList(), List$.MODULE$.canBuildFrom())))).setNetworkLocation(workerInfo.networkLocation()).build();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)workerInfo.toUniqueId()), (Object)pbWorkerResource);
                }
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public static final /* synthetic */ boolean $anonfun$toPbAppDiskUsageSnapshot$1(AppDiskUsage x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$toPbSnapshotMetaInfo$5(AppDiskUsageSnapShot x$6) {
        return x$6 != null;
    }

    public static final /* synthetic */ boolean $anonfun$toPbPackedPartitionLocationsPair$2(PartitionLocation x$9) {
        return x$9 == null;
    }

    private PbSerDeUtils$() {
        MODULE$ = this;
    }
}

