/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.leader;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.leader.LeaderProtoUtils;
import org.apache.ratis.server.storage.FileChunkReader;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.util.JavaUtils;

class InstallSnapshotRequests
implements Iterable<RaftProtos.InstallSnapshotRequestProto> {
    private final RaftServer.Division server;
    private final RaftPeerId followerId;
    private final Function<FileInfo, Path> getRelativePath;
    private final SnapshotInfo snapshot;
    private final String requestId;
    private final int snapshotChunkMaxSize;
    private final long totalSize;
    private int requestIndex = 0;
    private int fileIndex = 0;
    private FileChunkReader current;

    InstallSnapshotRequests(RaftServer.Division server, RaftPeerId followerId, String requestId, SnapshotInfo snapshot, int snapshotChunkMaxSize) {
        Function<Path, Path> relativize;
        this.server = server;
        this.followerId = followerId;
        this.requestId = requestId;
        this.snapshot = snapshot;
        this.snapshotChunkMaxSize = snapshotChunkMaxSize;
        this.totalSize = snapshot.getFiles().stream().mapToLong(FileInfo::getFileSize).reduce(Long::sum).orElseThrow(() -> new IllegalStateException("Failed to compute total size for snapshot " + snapshot));
        File snapshotDir = server.getStateMachine().getStateMachineStorage().getSnapshotDir();
        if (snapshotDir != null) {
            Path dir = snapshotDir.toPath();
            relativize = p -> new File("sm", dir.relativize((Path)p).toString()).toPath();
        } else {
            Path dir = server.getRaftStorage().getStorageDir().getRoot().toPath();
            relativize = dir::relativize;
        }
        this.getRelativePath = info -> Optional.of(info.getPath()).filter(Path::isAbsolute).map(relativize).orElseGet(() -> ((FileInfo)info).getPath());
    }

    @Override
    public Iterator<RaftProtos.InstallSnapshotRequestProto> iterator() {
        return new Iterator<RaftProtos.InstallSnapshotRequestProto>(){

            @Override
            public boolean hasNext() {
                return InstallSnapshotRequests.this.fileIndex < InstallSnapshotRequests.this.snapshot.getFiles().size();
            }

            @Override
            @SuppressFBWarnings(value={"IT_NO_SUCH_ELEMENT"})
            public RaftProtos.InstallSnapshotRequestProto next() {
                return InstallSnapshotRequests.this.nextInstallSnapshotRequestProto();
            }
        };
    }

    private RaftProtos.InstallSnapshotRequestProto nextInstallSnapshotRequestProto() {
        int numFiles = this.snapshot.getFiles().size();
        if (this.fileIndex >= numFiles) {
            throw new NoSuchElementException("fileIndex = " + this.fileIndex + " >= numFiles = " + numFiles);
        }
        FileInfo info = (FileInfo)this.snapshot.getFiles().get(this.fileIndex);
        try {
            RaftProtos.FileChunkProto chunk;
            if (this.current == null) {
                this.current = new FileChunkReader(info, this.getRelativePath.apply(info));
            }
            if ((chunk = this.current.readFileChunk(this.snapshotChunkMaxSize)).getDone()) {
                this.current.close();
                this.current = null;
                ++this.fileIndex;
            }
            boolean done = this.fileIndex == numFiles && chunk.getDone();
            return this.newInstallSnapshotRequest(chunk, done);
        }
        catch (IOException e) {
            if (this.current != null) {
                try {
                    this.current.close();
                    this.current = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new IllegalStateException("Failed to iterate installSnapshot requests: " + this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaftProtos.InstallSnapshotRequestProto newInstallSnapshotRequest(RaftProtos.FileChunkProto chunk, boolean done) {
        RaftServer.Division division = this.server;
        synchronized (division) {
            RaftProtos.InstallSnapshotRequestProto.SnapshotChunkProto.Builder b = LeaderProtoUtils.toSnapshotChunkProtoBuilder(this.requestId, this.requestIndex++, this.snapshot.getTermIndex(), chunk, this.totalSize, done);
            return LeaderProtoUtils.toInstallSnapshotRequestProto(this.server, this.followerId, b);
        }
    }

    public String toString() {
        return this.server.getId() + "->" + this.followerId + JavaUtils.getClassSimpleName(this.getClass()) + ": requestId=" + this.requestId + ", requestIndex=" + this.requestIndex + ", fileIndex=" + this.fileIndex + ", currentFile=" + this.current + ", snapshot=" + this.snapshot;
    }
}

