/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.xdr.type;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.org.apache.kerby.xdr.XdrDataType;
import org.apache.hadoop.shaded.org.apache.kerby.xdr.type.AbstractXdrType;

public abstract class XdrSimple<T>
extends AbstractXdrType<T> {
    private byte[] bytes;

    public XdrSimple(XdrDataType dataTypeNo) {
        this(dataTypeNo, null);
    }

    public XdrSimple(XdrDataType xdrDataType, T value) {
        super(xdrDataType, value);
    }

    protected byte[] getBytes() {
        return this.bytes;
    }

    protected void setBytes(byte[] bytes) {
        this.bytes = (byte[])(bytes != null ? (byte[])bytes.clone() : null);
    }

    protected byte[] encodeBody() throws IOException {
        if (this.bytes == null) {
            this.toBytes();
        }
        return this.bytes;
    }

    @Override
    protected void encodeBody(ByteBuffer buffer) throws IOException {
        byte[] body = this.encodeBody();
        if (body != null) {
            buffer.put(body);
        }
    }

    @Override
    protected int encodingBodyLength() throws IOException {
        if (this.getValue() == null) {
            return 0;
        }
        if (this.bytes == null) {
            this.toBytes();
        }
        return this.bytes.length;
    }

    @Override
    public void decode(ByteBuffer content) throws IOException {
        this.decodeBody(content);
    }

    protected void decodeBody(ByteBuffer body) throws IOException {
        byte[] result = body.array();
        if (result.length > 0) {
            this.setBytes(result);
            this.toValue();
        }
    }

    protected abstract void toValue() throws IOException;

    protected abstract void toBytes() throws IOException;

    public static boolean isSimple(XdrDataType dataType) {
        switch (dataType) {
            case BOOLEAN: 
            case INTEGER: 
            case UNSIGNED_INTEGER: 
            case ENUM: 
            case STRING: {
                return true;
            }
        }
        return false;
    }
}

