/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.plugin.flink.RemoteShuffleInputGateDelegation;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentProvider;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.runtime.io.PullingAsyncDataInput;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.LocalConnectionManager;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferDecompressor;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.throughput.ThroughputCalculator;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;
import org.apache.flink.util.function.SupplierWithException;

public class RemoteShuffleInputGate
extends IndexedInputGate {
    private final RemoteShuffleInputGateDelegation inputGateDelegation;

    public RemoteShuffleInputGate(CelebornConf celebornConf, String taskName, int gateIndex, InputGateDeploymentDescriptor gateDescriptor, SupplierWithException<BufferPool, IOException> bufferPoolFactory, BufferDecompressor bufferDecompressor, int numConcurrentReading) {
        this.inputGateDelegation = new RemoteShuffleInputGateDelegation(celebornConf, taskName, gateIndex, gateDescriptor, bufferPoolFactory, bufferDecompressor, numConcurrentReading, this.availabilityHelper, gateDescriptor.getConsumedSubpartitionIndexRange().getStartIndex(), gateDescriptor.getConsumedSubpartitionIndexRange().getEndIndex());
    }

    public void setup() throws IOException {
        this.inputGateDelegation.setup();
    }

    public int getGateIndex() {
        return this.inputGateDelegation.getGateIndex();
    }

    public int getNumberOfInputChannels() {
        return this.inputGateDelegation.getBufferReaders().size();
    }

    public boolean isFinished() {
        return this.inputGateDelegation.isFinished();
    }

    public Optional<BufferOrEvent> getNext() {
        throw new UnsupportedOperationException("Not implemented (DataSet API is not supported).");
    }

    public Optional<BufferOrEvent> pollNext() throws IOException {
        return this.inputGateDelegation.pollNext();
    }

    public void close() throws Exception {
        this.inputGateDelegation.close();
    }

    public List<InputChannelInfo> getChannelInfos() {
        return this.inputGateDelegation.getChannelsInfo();
    }

    public void requestPartitions() {
    }

    public void checkpointStarted(CheckpointBarrier barrier) {
    }

    public void checkpointStopped(long cancelledCheckpointId) {
    }

    public void triggerDebloating() {
    }

    public List<InputChannelInfo> getUnfinishedChannels() {
        return Collections.emptyList();
    }

    public PullingAsyncDataInput.EndOfDataStatus hasReceivedEndOfData() {
        if (this.inputGateDelegation.getPendingEndOfDataEvents() > 0L) {
            return PullingAsyncDataInput.EndOfDataStatus.NOT_END_OF_DATA;
        }
        return PullingAsyncDataInput.EndOfDataStatus.DRAINED;
    }

    public void finishReadRecoveredState() {
    }

    public InputChannel getChannel(int channelIndex) {
        return new FakedRemoteInputChannel(channelIndex);
    }

    public void sendTaskEvent(TaskEvent event) {
        throw new FlinkRuntimeException("Method should not be called.");
    }

    public void resumeConsumption(InputChannelInfo channelInfo) {
        throw new FlinkRuntimeException("Method should not be called.");
    }

    public void acknowledgeAllRecordsProcessed(InputChannelInfo inputChannelInfo) {
    }

    public CompletableFuture<Void> getStateConsumedFuture() {
        return CompletableFuture.completedFuture(null);
    }

    public String toString() {
        return String.format("ReadGate [owning task: %s, gate index: %d, descriptor: %s]", this.inputGateDelegation.getTaskName(), this.inputGateDelegation.getGateIndex(), this.inputGateDelegation.getGateDescriptor().toString());
    }

    private static class FakedChannelStateWriter
    implements ChannelStateWriter {
        private FakedChannelStateWriter() {
        }

        public void start(long cpId, CheckpointOptions checkpointOptions) {
        }

        public void addInputData(long cpId, InputChannelInfo info, int startSeqNum, CloseableIterator<Buffer> data) {
        }

        public void addOutputData(long cpId, ResultSubpartitionInfo info, int startSeqNum, Buffer ... data) {
        }

        public void addOutputDataFuture(long l, ResultSubpartitionInfo resultSubpartitionInfo, int i, CompletableFuture<List<Buffer>> completableFuture) throws IllegalArgumentException {
        }

        public void finishInput(long checkpointId) {
        }

        public void finishOutput(long checkpointId) {
        }

        public void abort(long checkpointId, Throwable cause, boolean cleanup) {
        }

        public ChannelStateWriter.ChannelStateWriteResult getAndRemoveWriteResult(long checkpointId) {
            return null;
        }

        public void close() {
        }
    }

    private static class FakedMemorySegmentProvider
    implements MemorySegmentProvider {
        private FakedMemorySegmentProvider() {
        }

        public Collection<MemorySegment> requestUnpooledMemorySegments(int i) throws IOException {
            return null;
        }

        public void recycleUnpooledMemorySegments(Collection<MemorySegment> collection) throws IOException {
        }
    }

    private class FakedRemoteInputChannel
    extends RemoteInputChannel {
        FakedRemoteInputChannel(int channelIndex) {
            super(new SingleInputGate(RemoteShuffleInputGate.this.inputGateDelegation.getTaskName(), RemoteShuffleInputGate.this.inputGateDelegation.getGateIndex(), new IntermediateDataSetID(), ResultPartitionType.BLOCKING, new IndexRange(0, 0), 1, (a, b, c) -> {}, () -> null, null, (MemorySegmentProvider)new FakedMemorySegmentProvider(), 0, new ThroughputCalculator((Clock)SystemClock.getInstance()), null), channelIndex, new ResultPartitionID(), 0, new ConnectionID(new TaskManagerLocation(ResourceID.generate(), InetAddress.getLoopbackAddress(), 1), 0), (ConnectionManager)new LocalConnectionManager(), 0, 0, 0, (Counter)new SimpleCounter(), (Counter)new SimpleCounter(), (ChannelStateWriter)new FakedChannelStateWriter());
        }
    }
}

