/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.brotli;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.brotli.BrotliCompressorInputStream;
import org.apache.commons.compress.compressors.brotli.BrotliUtils;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BrotliCompressorInputStreamTest
extends AbstractTest {
    BrotliCompressorInputStreamTest() {
    }

    @Test
    void testAvailableShouldReturnZero() throws IOException {
        try (InputStream is = BrotliCompressorInputStreamTest.newInputStream("brotli.testdata.compressed");
             BrotliCompressorInputStream in = new BrotliCompressorInputStream(is);){
            Assertions.assertEquals((int)0, (int)in.available());
        }
    }

    @Test
    void testBrotliDecode() throws IOException {
        try (InputStream inputStream = BrotliCompressorInputStreamTest.newInputStream("brotli.testdata.compressed");
             BrotliCompressorInputStream brotliInputStream = new BrotliCompressorInputStream(inputStream);){
            byte[] expected = BrotliCompressorInputStreamTest.readAllBytes("brotli.testdata.uncompressed");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)brotliInputStream, (OutputStream)bos);
            Assertions.assertArrayEquals((byte[])expected, (byte[])bos.toByteArray());
        }
    }

    @Test
    void testBrotliUnarchive() throws Exception {
        File output = this.newTempFile("bla.tar");
        try (InputStream is = BrotliCompressorInputStreamTest.newInputStream("bla.tar.br");
             CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("br", is);){
            Files.copy((InputStream)in, output.toPath(), new CopyOption[0]);
        }
    }

    @Test
    void testCachingIsEnabledByDefaultAndBrotliIsPresent() {
        Assertions.assertEquals((Object)BrotliUtils.CachedAvailability.CACHED_AVAILABLE, (Object)BrotliUtils.getCachedBrotliAvailability());
        Assertions.assertTrue((boolean)BrotliUtils.isBrotliCompressionAvailable());
    }

    @Test
    void testCanTurnOffCaching() {
        try {
            BrotliUtils.setCacheBrotliAvailablity((boolean)false);
            Assertions.assertEquals((Object)BrotliUtils.CachedAvailability.DONT_CACHE, (Object)BrotliUtils.getCachedBrotliAvailability());
            Assertions.assertTrue((boolean)BrotliUtils.isBrotliCompressionAvailable());
        }
        finally {
            BrotliUtils.setCacheBrotliAvailablity((boolean)true);
        }
    }

    @Test
    void testMultiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        byte[] buf = new byte[2];
        try (InputStream is = BrotliCompressorInputStreamTest.newInputStream("brotli.testdata.compressed");
             BrotliCompressorInputStream in = new BrotliCompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read(buf));
            Assertions.assertEquals((int)-1, (int)in.read(buf));
        }
    }

    @Test
    void testShouldBeAbleToSkipAByte() throws IOException {
        try (InputStream is = BrotliCompressorInputStreamTest.newInputStream("brotli.testdata.compressed");
             BrotliCompressorInputStream in = new BrotliCompressorInputStream(is);){
            Assertions.assertEquals((long)1L, (long)in.skip(1L));
        }
    }

    @Test
    void testSingleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        try (InputStream is = BrotliCompressorInputStreamTest.newInputStream("brotli.testdata.compressed");
             BrotliCompressorInputStream in = new BrotliCompressorInputStream(is);){
            IOUtils.toByteArray((InputStream)in);
            Assertions.assertEquals((int)-1, (int)in.read());
            Assertions.assertEquals((int)-1, (int)in.read());
        }
    }

    @Test
    void testSingleByteReadWorksAsExpected() throws IOException {
        try (InputStream is = BrotliCompressorInputStreamTest.newInputStream("brotli.testdata.compressed");
             BrotliCompressorInputStream in = new BrotliCompressorInputStream(is);){
            Assertions.assertEquals((int)88, (int)in.read());
        }
    }

    @Test
    void testTurningOnCachingReEvaluatesAvailability() {
        try {
            BrotliUtils.setCacheBrotliAvailablity((boolean)false);
            Assertions.assertEquals((Object)BrotliUtils.CachedAvailability.DONT_CACHE, (Object)BrotliUtils.getCachedBrotliAvailability());
            BrotliUtils.setCacheBrotliAvailablity((boolean)true);
            Assertions.assertEquals((Object)BrotliUtils.CachedAvailability.CACHED_AVAILABLE, (Object)BrotliUtils.getCachedBrotliAvailability());
        }
        finally {
            BrotliUtils.setCacheBrotliAvailablity((boolean)true);
        }
    }
}

