/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.beanutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.beanutils.BeanDeclaration;
import org.apache.commons.configuration2.beanutils.CombinedBeanDeclaration;
import org.apache.commons.configuration2.beanutils.ConstructorArg;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestCombinedBeanDeclaration {
    private BeanDeclaration[] declarations;

    private CombinedBeanDeclaration createCombinedDeclaration() {
        this.declarations = new BeanDeclaration[3];
        for (int i = 0; i < this.declarations.length; ++i) {
            this.declarations[i] = (BeanDeclaration)Mockito.mock(BeanDeclaration.class);
        }
        return new CombinedBeanDeclaration(this.declarations);
    }

    private BeanDeclaration decl(int idx) {
        return this.declarations[idx];
    }

    @Test
    public void testGetBeanClassNameDefined() {
        CombinedBeanDeclaration cd = this.createCombinedDeclaration();
        Mockito.when((Object)this.decl(0).getBeanClassName()).thenReturn(null);
        Mockito.when((Object)this.decl(1).getBeanClassName()).thenReturn((Object)this.getClass().getName());
        Assertions.assertEquals((Object)this.getClass().getName(), (Object)cd.getBeanClassName());
        ((BeanDeclaration)Mockito.verify((Object)this.decl(0))).getBeanClassName();
        ((BeanDeclaration)Mockito.verify((Object)this.decl(1))).getBeanClassName();
        this.verifyNoMoreDeclarationInteractions();
    }

    @Test
    public void testGetBeanClassNameUndefined() {
        CombinedBeanDeclaration cd = new CombinedBeanDeclaration(new BeanDeclaration[0]);
        Assertions.assertNull((Object)cd.getBeanClassName());
    }

    @Test
    public void testGetBeanFactoryNameDefined() {
        CombinedBeanDeclaration cd = this.createCombinedDeclaration();
        String name = "someTestBeanFactory";
        Mockito.when((Object)this.decl(0).getBeanFactoryName()).thenReturn(null);
        Mockito.when((Object)this.decl(1).getBeanFactoryName()).thenReturn((Object)"someTestBeanFactory");
        Assertions.assertEquals((Object)"someTestBeanFactory", (Object)cd.getBeanFactoryName());
        ((BeanDeclaration)Mockito.verify((Object)this.decl(0))).getBeanFactoryName();
        ((BeanDeclaration)Mockito.verify((Object)this.decl(1))).getBeanFactoryName();
        this.verifyNoMoreDeclarationInteractions();
    }

    @Test
    public void testGetBeanFactoryNameUndefined() {
        CombinedBeanDeclaration cd = new CombinedBeanDeclaration(new BeanDeclaration[0]);
        Assertions.assertNull((Object)cd.getBeanFactoryName());
    }

    @Test
    public void testGetBeanFactoryParameterDefined() {
        CombinedBeanDeclaration cd = this.createCombinedDeclaration();
        Object param = new Object();
        Mockito.when((Object)this.decl(0).getBeanFactoryParameter()).thenReturn(null);
        Mockito.when((Object)this.decl(1).getBeanFactoryParameter()).thenReturn(param);
        Assertions.assertSame((Object)param, (Object)cd.getBeanFactoryParameter());
        ((BeanDeclaration)Mockito.verify((Object)this.decl(0))).getBeanFactoryParameter();
        ((BeanDeclaration)Mockito.verify((Object)this.decl(1))).getBeanFactoryParameter();
        this.verifyNoMoreDeclarationInteractions();
    }

    @Test
    public void testGetBeanFactoryParameterUndefined() {
        CombinedBeanDeclaration cd = new CombinedBeanDeclaration(new BeanDeclaration[0]);
        Assertions.assertNull((Object)cd.getBeanFactoryParameter());
    }

    @Test
    public void testGetBeanProperties() {
        HashMap<String, String> props1 = new HashMap<String, String>();
        HashMap<String, String> props2 = new HashMap<String, String>();
        HashMap<String, String> props3 = new HashMap<String, String>();
        props1.put("param1", "value1");
        props1.put("param2", "value2");
        props2.put("param2", "othervalue");
        props2.put("param3", "value3");
        props3.put("param1", "differentvalue");
        props3.put("param4", "value4");
        CombinedBeanDeclaration cd = this.createCombinedDeclaration();
        Mockito.when((Object)this.decl(0).getBeanProperties()).thenReturn(props1);
        Mockito.when((Object)this.decl(1).getBeanProperties()).thenReturn(props2);
        Mockito.when((Object)this.decl(2).getBeanProperties()).thenReturn(props3);
        Map props = cd.getBeanProperties();
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("param1", "value1");
        expected.put("param2", "value2");
        expected.put("param3", "value3");
        expected.put("param4", "value4");
        Assertions.assertEquals(expected, (Object)props);
        ((BeanDeclaration)Mockito.verify((Object)this.decl(0))).getBeanProperties();
        ((BeanDeclaration)Mockito.verify((Object)this.decl(1))).getBeanProperties();
        ((BeanDeclaration)Mockito.verify((Object)this.decl(2))).getBeanProperties();
        this.verifyNoMoreDeclarationInteractions();
    }

    @Test
    public void testGetBeanPropertiesNull() {
        BeanDeclaration child = (BeanDeclaration)Mockito.mock(BeanDeclaration.class);
        Mockito.when((Object)child.getBeanProperties()).thenReturn(null);
        CombinedBeanDeclaration cd = new CombinedBeanDeclaration(new BeanDeclaration[]{child});
        Assertions.assertEquals(Collections.emptyMap(), (Object)cd.getBeanProperties());
        ((BeanDeclaration)Mockito.verify((Object)child)).getBeanProperties();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{child});
    }

    @Test
    public void testGetConstructorArgsDefined() {
        CombinedBeanDeclaration cd = this.createCombinedDeclaration();
        List<ConstructorArg> args = Arrays.asList(ConstructorArg.forValue((Object)42));
        Mockito.when((Object)this.decl(0).getConstructorArgs()).thenReturn(null);
        Mockito.when((Object)this.decl(1).getConstructorArgs()).thenReturn(args);
        Assertions.assertSame(args, (Object)cd.getConstructorArgs());
        ((BeanDeclaration)Mockito.verify((Object)this.decl(0))).getConstructorArgs();
        ((BeanDeclaration)Mockito.verify((Object)this.decl(1))).getConstructorArgs();
        this.verifyNoMoreDeclarationInteractions();
    }

    @Test
    public void testGetConstructorArgsUndefined() {
        CombinedBeanDeclaration cd = this.createCombinedDeclaration();
        Mockito.when((Object)this.decl(0).getConstructorArgs()).thenReturn(null);
        Mockito.when((Object)this.decl(1).getConstructorArgs()).thenReturn(new ArrayList());
        Mockito.when((Object)this.decl(2).getConstructorArgs()).thenReturn(null);
        Assertions.assertEquals(Collections.emptyList(), new ArrayList(cd.getConstructorArgs()));
        ((BeanDeclaration)Mockito.verify((Object)this.decl(0))).getConstructorArgs();
        ((BeanDeclaration)Mockito.verify((Object)this.decl(1))).getConstructorArgs();
        ((BeanDeclaration)Mockito.verify((Object)this.decl(2))).getConstructorArgs();
        this.verifyNoMoreDeclarationInteractions();
    }

    @Test
    public void testGetNestedBeanDeclarations() {
        HashMap<String, String> decls1 = new HashMap<String, String>();
        HashMap<String, String> decls2 = new HashMap<String, String>();
        HashMap<String, String> decls3 = new HashMap<String, String>();
        decls1.put("param1", "value1");
        decls1.put("param2", "value2");
        decls2.put("param2", "othervalue");
        decls2.put("param3", "value3");
        decls3.put("param1", "differentvalue");
        decls3.put("param4", "value4");
        CombinedBeanDeclaration cd = this.createCombinedDeclaration();
        Mockito.when((Object)this.decl(0).getNestedBeanDeclarations()).thenReturn(decls1);
        Mockito.when((Object)this.decl(1).getNestedBeanDeclarations()).thenReturn(decls2);
        Mockito.when((Object)this.decl(2).getNestedBeanDeclarations()).thenReturn(decls3);
        Map decls = cd.getNestedBeanDeclarations();
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("param1", "value1");
        expected.put("param2", "value2");
        expected.put("param3", "value3");
        expected.put("param4", "value4");
        Assertions.assertEquals(expected, (Object)decls);
        ((BeanDeclaration)Mockito.verify((Object)this.decl(0))).getNestedBeanDeclarations();
        ((BeanDeclaration)Mockito.verify((Object)this.decl(1))).getNestedBeanDeclarations();
        ((BeanDeclaration)Mockito.verify((Object)this.decl(2))).getNestedBeanDeclarations();
        this.verifyNoMoreDeclarationInteractions();
    }

    @Test
    public void testGetNestedBeanDeclarationsNull() {
        BeanDeclaration child = (BeanDeclaration)Mockito.mock(BeanDeclaration.class);
        Mockito.when((Object)child.getNestedBeanDeclarations()).thenReturn(null);
        CombinedBeanDeclaration cd = new CombinedBeanDeclaration(new BeanDeclaration[]{child});
        Assertions.assertEquals(Collections.emptyMap(), (Object)cd.getNestedBeanDeclarations());
        ((BeanDeclaration)Mockito.verify((Object)child)).getNestedBeanDeclarations();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{child});
    }

    private void verifyNoMoreDeclarationInteractions() {
        Mockito.verifyNoMoreInteractions((Object[])this.declarations);
    }
}

