/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.Map;
import org.apache.commons.configuration2.ConfigurationConsumer;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.PropertiesConfigurationLayout;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.PropertiesBuilderParametersImpl;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestPropertiesBuilderParametersImpl {
    private PropertiesBuilderParametersImpl params;

    @BeforeEach
    public void setUp() throws Exception {
        this.params = new PropertiesBuilderParametersImpl();
    }

    @Test
    public void testBeanPropertiesAccess() throws Exception {
        PropertiesConfiguration.IOFactory factory = (PropertiesConfiguration.IOFactory)Mockito.mock(PropertiesConfiguration.IOFactory.class);
        BeanHelper.setProperty((Object)this.params, (String)"IOFactory", (Object)factory);
        BeanHelper.setProperty((Object)this.params, (String)"throwExceptionOnMissing", (Object)Boolean.TRUE);
        BeanHelper.setProperty((Object)this.params, (String)"fileName", (Object)"test.properties");
        Assertions.assertEquals((Object)"test.properties", (Object)this.params.getFileHandler().getFileName());
        Map paramsMap = this.params.getParameters();
        Assertions.assertEquals((Object)Boolean.TRUE, paramsMap.get("throwExceptionOnMissing"));
        Assertions.assertSame((Object)factory, this.params.getParameters().get("IOFactory"));
    }

    @Test
    public void testInheritFrom() {
        PropertiesConfiguration.IOFactory factory = (PropertiesConfiguration.IOFactory)Mockito.mock(PropertiesConfiguration.IOFactory.class);
        ConfigurationConsumer includeListener = (ConfigurationConsumer)Mockito.mock(ConfigurationConsumer.class);
        this.params.setIOFactory(factory).setIncludeListener(includeListener).setIncludesAllowed(false).setLayout(new PropertiesConfigurationLayout()).setThrowExceptionOnMissing(true);
        PropertiesBuilderParametersImpl params2 = new PropertiesBuilderParametersImpl();
        params2.inheritFrom(this.params.getParameters());
        Map parameters = params2.getParameters();
        Assertions.assertEquals((Object)Boolean.TRUE, parameters.get("throwExceptionOnMissing"));
        Assertions.assertEquals((Object)includeListener, parameters.get("includeListener"));
        Assertions.assertEquals((Object)factory, parameters.get("IOFactory"));
        Assertions.assertEquals((Object)Boolean.FALSE, parameters.get("includesAllowed"));
        Assertions.assertNull(parameters.get("layout"));
    }

    @Test
    public void testSetIncludeListener() {
        ConfigurationConsumer includeListener = (ConfigurationConsumer)Mockito.mock(ConfigurationConsumer.class);
        Assertions.assertSame((Object)this.params, (Object)this.params.setIncludeListener(includeListener));
        Assertions.assertSame((Object)includeListener, this.params.getParameters().get("includeListener"));
    }

    @Test
    public void testSetIncludeListenerProperty() throws ConfigurationException {
        ConfigurationConsumer includeListener = PropertiesConfiguration.DEFAULT_INCLUDE_LISTENER;
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{this.params.setIncludeListener(includeListener)});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertEquals((Object)includeListener, (Object)config.getIncludeListener());
    }

    @Test
    public void testSetIncludesAllowed() {
        Assertions.assertSame((Object)this.params, (Object)this.params.setIncludesAllowed(true));
        Assertions.assertEquals((Object)Boolean.TRUE, this.params.getParameters().get("includesAllowed"));
    }

    @Test
    public void testSetIOFactory() {
        PropertiesConfiguration.IOFactory factory = (PropertiesConfiguration.IOFactory)Mockito.mock(PropertiesConfiguration.IOFactory.class);
        Assertions.assertSame((Object)this.params, (Object)this.params.setIOFactory(factory));
        Assertions.assertSame((Object)factory, this.params.getParameters().get("IOFactory"));
    }

    @Test
    public void testSetIOFactoryProperty() throws ConfigurationException {
        PropertiesConfiguration.DefaultIOFactory factory = new PropertiesConfiguration.DefaultIOFactory();
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{this.params.setIOFactory((PropertiesConfiguration.IOFactory)factory)});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertEquals((Object)factory, (Object)config.getIOFactory());
    }

    @Test
    public void testSetLayout() {
        PropertiesConfigurationLayout layout = new PropertiesConfigurationLayout();
        Assertions.assertSame((Object)this.params, (Object)this.params.setLayout(layout));
        Assertions.assertSame((Object)layout, this.params.getParameters().get("layout"));
    }
}

